/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_2_0;

import com.liferay.layout.page.template.internal.upgrade.v2_0_0.util.LayoutPageTemplateCollectionTable;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class LayoutPageTemplateCollectionUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this.upgradeLayoutPageTemplateCollectionKey();
    }

    protected void upgradeLayoutPageTemplateCollectionKey() throws SQLException {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select layoutPageTemplateCollectionId, name from LayoutPageTemplateCollection");
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update LayoutPageTemplateCollection set lptCollectionKey = ? where layoutPageTemplateCollectionId = ?"));){
            while (resultSet.next()) {
                long layoutPageTemplateCollectionId = resultSet.getLong("layoutPageTemplateCollectionId");
                String name = resultSet.getString("name");
                preparedStatement.setString(1, this._generateLayoutPageTemplateCollectionKey(name));
                preparedStatement.setLong(2, layoutPageTemplateCollectionId);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }

    protected void upgradeSchema() throws Exception {
        this.alter(LayoutPageTemplateCollectionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "lptCollectionKey", "VARCHAR(75)")});
    }

    private String _generateLayoutPageTemplateCollectionKey(String name) {
        return StringUtil.replace((String)StringUtil.toLowerCase((String)name.trim()), (char[])new char[]{'/', ' '}, (char[])new char[]{'-', '-'});
    }
}

