/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.service.impl;

import com.liferay.asset.kernel.NoSuchClassTypeException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.info.item.InfoItemFormVariation;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFormProvider;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.layout.page.template.exception.LayoutPageTemplateEntryNameException;
import com.liferay.layout.page.template.exception.NoSuchPageTemplateEntryException;
import com.liferay.layout.page.template.internal.validator.LayoutPageTemplateEntryValidator;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.base.LayoutPageTemplateEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.NoSuchClassNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.staging.StagingGroupHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry"}, service={AopService.class})
public class LayoutPageTemplateEntryLocalServiceImpl
extends LayoutPageTemplateEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutPageTemplateEntryLocalServiceImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;
    @Reference
    private ThemeLocalService _themeLocalService;

    public LayoutPageTemplateEntry addGlobalLayoutPageTemplateEntry(LayoutPrototype layoutPrototype) throws PortalException {
        Company company = this._companyLocalService.getCompany(layoutPrototype.getCompanyId());
        return this.addLayoutPageTemplateEntry(company.getGroupId(), layoutPrototype);
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(LayoutPrototype layoutPrototype) throws PortalException {
        Company company = this._companyLocalService.getCompany(layoutPrototype.getCompanyId());
        return this.addLayoutPageTemplateEntry(company.getGroupId(), layoutPrototype);
    }

    @Deprecated
    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, long classNameId, long classTypeId, String name, int type, boolean defaultTemplate, long layoutPrototypeId, long previewFileEntryId, long plid, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, classNameId, classTypeId, name, type, previewFileEntryId, defaultTemplate, layoutPrototypeId, plid, 0L, status, serviceContext);
    }

    @Deprecated
    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, long classNameId, long classTypeId, String name, int type, int status, ServiceContext serviceContext) throws PortalException {
        this.validate(classNameId, classTypeId, groupId, serviceContext.getLocale());
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, classNameId, classTypeId, name, type, false, 0L, 0L, 0L, status, serviceContext);
        this._ddmStructureLinkLocalService.addStructureLink(this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), classTypeId);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, long classNameId, long classTypeId, String name, int type, long previewFileEntryId, boolean defaultTemplate, long layoutPrototypeId, long plid, long masterLayoutPlid, int status, ServiceContext serviceContext) throws PortalException {
        Layout layout;
        User user = this.userLocalService.getUser(userId);
        this.validate(groupId, name, type);
        long layoutPageTemplateEntryId = this.counterLocalService.increment();
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.create(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setUuid(serviceContext.getUuid());
        layoutPageTemplateEntry.setGroupId(groupId);
        layoutPageTemplateEntry.setCompanyId(user.getCompanyId());
        layoutPageTemplateEntry.setUserId(user.getUserId());
        layoutPageTemplateEntry.setUserName(user.getFullName());
        layoutPageTemplateEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        layoutPageTemplateEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPageTemplateEntry.setLayoutPageTemplateCollectionId(layoutPageTemplateCollectionId);
        layoutPageTemplateEntry.setLayoutPageTemplateEntryKey(this._generateLayoutPageTemplateEntryKey(groupId, name));
        layoutPageTemplateEntry.setClassNameId(classNameId);
        layoutPageTemplateEntry.setClassTypeId(classTypeId);
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry.setType(type);
        layoutPageTemplateEntry.setPreviewFileEntryId(previewFileEntryId);
        layoutPageTemplateEntry.setDefaultTemplate(defaultTemplate);
        layoutPageTemplateEntry = (LayoutPageTemplateEntry)this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        if (type == 2 && layoutPrototypeId == 0L) {
            serviceContext.setAttribute("layoutPageTemplateEntryId", (Serializable)Long.valueOf(layoutPageTemplateEntryId));
            LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.addLayoutPrototype(userId, user.getCompanyId(), Collections.singletonMap(LocaleUtil.getMostRelevantLocale(), name), Collections.emptyMap(), true, serviceContext);
            layoutPrototypeId = layoutPrototype.getLayoutPrototypeId();
            Layout layout2 = layoutPrototype.getLayout();
            plid = layout2.getPlid();
        }
        layoutPageTemplateEntry.setLayoutPrototypeId(layoutPrototypeId);
        if (plid == 0L && (layout = this._addLayout(userId, groupId, name, type, masterLayoutPlid, status, serviceContext)) != null) {
            plid = layout.getPlid();
        }
        layoutPageTemplateEntry.setPlid(plid);
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getScreenName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        layoutPageTemplateEntry = (LayoutPageTemplateEntry)this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        this.resourceLocalService.addResources(layoutPageTemplateEntry.getCompanyId(), layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getUserId(), LayoutPageTemplateEntry.class.getName(), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), false, true, true);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, long classNameId, long classTypeId, String name, int type, long masterLayoutPlid, int status, ServiceContext serviceContext) throws PortalException {
        this.validate(classNameId, classTypeId, groupId, serviceContext.getLocale());
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, classNameId, classTypeId, name, type, 0L, false, 0L, 0L, masterLayoutPlid, status, serviceContext);
        this._ddmStructureLinkLocalService.addStructureLink(this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), classTypeId);
        return layoutPageTemplateEntry;
    }

    @Deprecated
    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, int type, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, 0L, 0L, name, type, false, 0L, 0L, 0L, status, serviceContext);
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, int type, long masterLayoutPlid, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, 0L, 0L, name, type, 0L, false, 0L, 0L, masterLayoutPlid, status, serviceContext);
    }

    public LayoutPageTemplateEntry copyLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, long layoutPageTemplateEntryId, ServiceContext serviceContext) throws PortalException {
        LayoutPageTemplateEntry sourceLayoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        String name = this._getUniqueCopyName(groupId, sourceLayoutPageTemplateEntry.getName(), sourceLayoutPageTemplateEntry.getType(), serviceContext.getLocale());
        long previewFileEntryId = this._copyPreviewFileEntryId(userId, sourceLayoutPageTemplateEntry.getPreviewFileEntryId(), name, serviceContext);
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, sourceLayoutPageTemplateEntry.getClassNameId(), sourceLayoutPageTemplateEntry.getClassTypeId(), name, sourceLayoutPageTemplateEntry.getType(), false, 0L, previewFileEntryId, 0L, sourceLayoutPageTemplateEntry.getStatus(), serviceContext);
    }

    @Override
    public LayoutPageTemplateEntry deleteLayoutPageTemplateEntry(LayoutPageTemplateEntry layoutPageTemplateEntry) throws PortalException {
        LayoutPrototype layoutPrototype;
        long layoutPrototypeId;
        this.layoutPageTemplateEntryPersistence.remove((BaseModel)layoutPageTemplateEntry);
        this.resourceLocalService.deleteResource(layoutPageTemplateEntry.getCompanyId(), LayoutPageTemplateEntry.class.getName(), 4, layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        Layout layout = this.layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        LayoutSet layoutSet = this.layoutSetLocalService.fetchLayoutSet(layoutPageTemplateEntry.getGroupId(), false);
        if (layout != null && layoutSet != null) {
            this.layoutLocalService.deleteLayout(layout);
        }
        if (!this._stagingGroupHelper.isLocalStagingGroup(layoutPageTemplateEntry.getGroupId()) && (layoutPrototypeId = layoutPageTemplateEntry.getLayoutPrototypeId()) > 0L && (layoutPrototype = this._layoutPrototypeLocalService.fetchLayoutPrototype(layoutPrototypeId)) != null) {
            this._layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototypeId);
        }
        if (layoutPageTemplateEntry.getPreviewFileEntryId() > 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)layoutPageTemplateEntry.getPreviewFileEntryId());
        }
        if (Objects.equals(layoutPageTemplateEntry.getType(), 1) && layoutPageTemplateEntry.getClassTypeId() > 0L) {
            this._ddmStructureLinkLocalService.deleteStructureLinks(this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        }
        return layoutPageTemplateEntry;
    }

    @Override
    public LayoutPageTemplateEntry deleteLayoutPageTemplateEntry(long layoutPageTemplateEntryId) throws PortalException {
        return this.deleteLayoutPageTemplateEntry(this.getLayoutPageTemplateEntry(layoutPageTemplateEntryId));
    }

    public LayoutPageTemplateEntry fetchDefaultLayoutPageTemplateEntry(long groupId, long classNameId, long classTypeId) {
        return this.layoutPageTemplateEntryPersistence.fetchByG_C_C_D_First(groupId, classNameId, classTypeId, true, null);
    }

    public LayoutPageTemplateEntry fetchFirstLayoutPageTemplateEntry(long layoutPrototypeId) {
        return this.layoutPageTemplateEntryPersistence.fetchByLayoutPrototypeId_First(layoutPrototypeId, null);
    }

    @Override
    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntry(long layoutPageTemplateEntryId) {
        return this.layoutPageTemplateEntryPersistence.fetchByPrimaryKey(layoutPageTemplateEntryId);
    }

    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntry(long groupId, String layoutPageTemplateEntryKey) {
        return this.layoutPageTemplateEntryPersistence.fetchByG_LPTEK(groupId, layoutPageTemplateEntryKey);
    }

    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntry(long groupId, String name, int type) {
        return this.layoutPageTemplateEntryPersistence.fetchByG_N_T(groupId, name, type);
    }

    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntryByPlid(long plid) {
        return this.layoutPageTemplateEntryPersistence.fetchByPlid(plid);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId) {
        return this.layoutPageTemplateEntryPersistence.findByGroupId(groupId);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int start, int end) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1, start, end);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status, int start, int end) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end, orderByComparator);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, String name, int status, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        if (status == -1) {
            if (Validator.isNull((String)name)) {
                return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end, orderByComparator);
            }
            return this.layoutPageTemplateEntryPersistence.findByG_L_LikeN(groupId, layoutPageTemplateCollectionId, name, start, end, orderByComparator);
        }
        if (Validator.isNull((String)name)) {
            return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end, orderByComparator);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_LikeN_S(groupId, layoutPageTemplateCollectionId, name, status, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, String name, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, name, -1, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntriesByLayoutPrototypeId(long layoutPrototypeId) {
        return this.layoutPageTemplateEntryPersistence.findByLayoutPrototypeId(layoutPrototypeId);
    }

    public LayoutPageTemplateEntry getLayoutPageTemplateEntry(long groupId, String layoutPageTemplateEntryKey) throws NoSuchPageTemplateEntryException {
        return this.layoutPageTemplateEntryPersistence.findByG_LPTEK(groupId, layoutPageTemplateEntryKey);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, boolean defaultTemplate) {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId);
        if (layoutPageTemplateEntry == null) {
            return null;
        }
        LayoutPageTemplateEntry defaultLayoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_C_C_D_First(layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getClassNameId(), layoutPageTemplateEntry.getClassTypeId(), true, null);
        if (defaultTemplate && defaultLayoutPageTemplateEntry != null && defaultLayoutPageTemplateEntry.getLayoutPageTemplateEntryId() != layoutPageTemplateEntryId) {
            layoutPageTemplateEntry.setModifiedDate(new Date());
            defaultLayoutPageTemplateEntry.setDefaultTemplate(false);
            this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(defaultLayoutPageTemplateEntry);
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setDefaultTemplate(defaultTemplate);
        this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, long previewFileEntryId) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setPreviewFileEntryId(previewFileEntryId);
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long userId, long layoutPageTemplateEntryId, String name, int status) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (!Objects.equals(layoutPageTemplateEntry.getName(), name)) {
            this.validate(layoutPageTemplateEntry.getGroupId(), name, layoutPageTemplateEntry.getType());
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getScreenName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, String name) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (Objects.equals(layoutPageTemplateEntry.getName(), name)) {
            return layoutPageTemplateEntry;
        }
        this.validate(layoutPageTemplateEntry.getGroupId(), name, layoutPageTemplateEntry.getType());
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry = this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), name);
        Layout draftLayout = this.layoutLocalService.fetchDraftLayout(layoutPageTemplateEntry.getPlid());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        this.layoutLocalService.updateLayout(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), draftLayout.getParentLayoutId(), titleMap, titleMap, draftLayout.getDescriptionMap(), draftLayout.getKeywordsMap(), draftLayout.getRobotsMap(), draftLayout.getType(), draftLayout.isHidden(), draftLayout.getFriendlyURLMap(), draftLayout.getIconImage(), null, draftLayout.getMasterLayoutPlid(), draftLayout.getStyleBookEntryId(), serviceContext);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, String name, long[] fragmentEntryIds, String editableValues, ServiceContext serviceContext) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (!Objects.equals(layoutPageTemplateEntry.getName(), name)) {
            this.validate(layoutPageTemplateEntry.getGroupId(), name, layoutPageTemplateEntry.getType());
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry = (LayoutPageTemplateEntry)this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        this._fragmentEntryLinkLocalService.updateFragmentEntryLinks(serviceContext.getUserId(), layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getPlid(), fragmentEntryIds, editableValues, serviceContext);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry updateStatus(long userId, long layoutPageTemplateEntryId, int status) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getScreenName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    protected LayoutPageTemplateEntry addLayoutPageTemplateEntry(long groupId, LayoutPrototype layoutPrototype) throws PortalException {
        String nameXML = layoutPrototype.getName();
        Map nameMap = LocalizationUtil.getLocalizationMap((String)nameXML);
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)nameXML));
        Layout layout = layoutPrototype.getLayout();
        int status = 0;
        if (!layoutPrototype.isActive()) {
            status = 5;
        }
        return this.addLayoutPageTemplateEntry(layoutPrototype.getUserId(), groupId, 0L, 0L, 0L, (String)nameMap.get(defaultLocale), 2, false, layoutPrototype.getLayoutPrototypeId(), 0L, layout.getPlid(), status, new ServiceContext());
    }

    protected void validate(long classNameId, long classTypeId, long groupId, Locale locale) throws PortalException {
        String className = "";
        try {
            className = this._portal.getClassName(classNameId);
        }
        catch (RuntimeException runtimeException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)runtimeException, (Throwable)runtimeException);
            }
            throw new NoSuchClassNameException("Class name does not exist for class name ID " + classNameId);
        }
        InfoItemFormProvider infoItemFormProvider = (InfoItemFormProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFormProvider.class, className);
        if (infoItemFormProvider == null) {
            throw new PortalException("No item form provider is registered for class name ID " + classNameId);
        }
        InfoItemFormVariationsProvider infoItemFormVariationsProvider = (InfoItemFormVariationsProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFormVariationsProvider.class, className);
        if (infoItemFormVariationsProvider == null) {
            return;
        }
        InfoItemFormVariation infoItemFormVariation = infoItemFormVariationsProvider.getInfoItemFormVariation(groupId, String.valueOf(classTypeId));
        if (infoItemFormVariation == null) {
            throw new NoSuchClassTypeException("Class type does not exist for class name ID " + classNameId);
        }
    }

    protected void validate(long groupId, String name, int type) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutPageTemplateEntryNameException.MustNotBeNull(groupId);
        }
        LayoutPageTemplateEntryValidator.validateNameCharacters(name);
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new LayoutPageTemplateEntryNameException.MustNotExceedMaximumSize(nameMaxLength);
        }
        if (Objects.equals(name, "Blank") && type == 3) {
            throw new LayoutPageTemplateEntryNameException.MustNotBeDuplicate(groupId, name);
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_N_T(groupId, name, type);
        if (layoutPageTemplateEntry != null) {
            throw new LayoutPageTemplateEntryNameException.MustNotBeDuplicate(groupId, name);
        }
    }

    private Layout _addLayout(long userId, long groupId, String name, int type, long masterLayoutPlid, int status, ServiceContext serviceContext) throws PortalException {
        boolean privateLayout = false;
        String layoutType = "asset_display";
        if (type == 0 || type == 3) {
            privateLayout = true;
            layoutType = "content";
        }
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), name);
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties();
        if (status == 0) {
            typeSettingsUnicodeProperties.put("published", "true");
        }
        if (type == 3 || masterLayoutPlid > 0L) {
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-footer", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header-search", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:wrap-widget-page-content", Boolean.FALSE.toString());
        }
        String typeSettings = typeSettingsUnicodeProperties.toString();
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        Layout layout = this.layoutLocalService.addLayout(userId, groupId, privateLayout, 0L, 0L, 0L, titleMap, titleMap, null, null, null, layoutType, typeSettings, true, true, new HashMap(), masterLayoutPlid, serviceContext);
        serviceContext.setModifiedDate(layout.getModifiedDate());
        Layout draftLayout = this.layoutLocalService.addLayout(userId, groupId, privateLayout, layout.getParentLayoutId(), this.classNameLocalService.getClassNameId(Layout.class), layout.getPlid(), layout.getNameMap(), titleMap, layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layoutType, layout.getTypeSettings(), true, true, Collections.emptyMap(), masterLayoutPlid, serviceContext);
        if (type == 3 || masterLayoutPlid > 0L) {
            String defaultRegularThemeId = ThemeFactoryUtil.getDefaultRegularThemeId((long)layout.getCompanyId());
            String colorSchemeId = this._getColorSchemeId(layout.getCompanyId(), defaultRegularThemeId, "");
            draftLayout = this.layoutLocalService.updateLookAndFeel(groupId, privateLayout, draftLayout.getLayoutId(), defaultRegularThemeId, colorSchemeId, "");
            layout = this.layoutLocalService.updateLookAndFeel(groupId, privateLayout, layout.getLayoutId(), defaultRegularThemeId, colorSchemeId, "");
        }
        if (status == 2) {
            this.layoutLocalService.updateStatus(userId, draftLayout.getPlid(), status, serviceContext);
            layout = this.layoutLocalService.updateStatus(userId, layout.getPlid(), status, serviceContext);
        }
        return layout;
    }

    private long _copyPreviewFileEntryId(long userId, long previewFileEntryId, String name, ServiceContext serviceContext) throws PortalException {
        if (previewFileEntryId == 0L) {
            return previewFileEntryId;
        }
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.getFileEntry(previewFileEntryId);
        Folder folder = this._portletFileRepository.addPortletFolder(userId, dlFileEntry.getRepositoryId(), 0L, name, serviceContext);
        DLFileEntry copyDLFileEntry = this._dlFileEntryLocalService.copyFileEntry(userId, dlFileEntry.getGroupId(), dlFileEntry.getRepositoryId(), previewFileEntryId, folder.getFolderId(), serviceContext);
        return copyDLFileEntry.getFileEntryId();
    }

    private String _generateLayoutPageTemplateEntryKey(long groupId, String name) {
        String layoutPageTemplateEntryKey = StringUtil.toLowerCase((String)name.trim());
        String curLayoutPageTemplateEntryKey = layoutPageTemplateEntryKey = StringUtil.replace((String)layoutPageTemplateEntryKey, (char)' ', (char)'-');
        int count = 0;
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        while ((layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_LPTEK(groupId, curLayoutPageTemplateEntryKey)) != null) {
            curLayoutPageTemplateEntryKey = curLayoutPageTemplateEntryKey + '-' + count++;
        }
        return curLayoutPageTemplateEntryKey;
    }

    private String _getColorSchemeId(long companyId, String themeId, String colorSchemeId) {
        Theme theme = this._themeLocalService.getTheme(companyId, themeId);
        if (!theme.hasColorSchemes()) {
            colorSchemeId = "";
        }
        if (Validator.isNull((String)colorSchemeId)) {
            ColorScheme colorScheme = this._themeLocalService.getColorScheme(companyId, themeId, colorSchemeId);
            colorSchemeId = colorScheme.getColorSchemeId();
        }
        return colorSchemeId;
    }

    private String _getUniqueCopyName(long groupId, String sourceName, int type, Locale locale) {
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        String copy = LanguageUtil.get((Locale)locale, (String)"copy");
        String name = StringUtil.appendParentheticalSuffix((String)sourceName, (String)copy);
        int i = 1;
        while ((layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_N_T(groupId, name, type)) != null) {
            name = StringUtil.appendParentheticalSuffix((String)sourceName, (String)(copy + " " + i));
            ++i;
        }
        return name;
    }
}

