/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_2_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class LayoutPageTemplateCollectionUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this._upgradeLayoutPageTemplateCollectionKey();
    }

    protected void upgradeSchema() throws Exception {
        this.alterTableAddColumn("LayoutPageTemplateCollection", "lptCollectionKey", "VARCHAR(75)");
    }

    private String _generateLayoutPageTemplateCollectionKey(String name) {
        return StringUtil.replace((String)StringUtil.toLowerCase((String)name.trim()), (char[])new char[]{'/', ' '}, (char[])new char[]{'-', '-'});
    }

    private void _upgradeLayoutPageTemplateCollectionKey() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select layoutPageTemplateCollectionId, name from LayoutPageTemplateCollection");
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update LayoutPageTemplateCollection set lptCollectionKey = ? where layoutPageTemplateCollectionId = ?");){
            while (resultSet.next()) {
                long layoutPageTemplateCollectionId = resultSet.getLong("layoutPageTemplateCollectionId");
                String name = resultSet.getString("name");
                preparedStatement.setString(1, this._generateLayoutPageTemplateCollectionKey(name));
                preparedStatement.setLong(2, layoutPageTemplateCollectionId);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }
}

