/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v1_2_0;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class LayoutPageTemplateStructureUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(LayoutPageTemplateStructureUpgradeProcess.class);
    private final FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    private final LayoutLocalService _layoutLocalService;

    public LayoutPageTemplateStructureUpgradeProcess(FragmentEntryLinkLocalService fragmentEntryLinkLocalService, LayoutLocalService layoutLocalService) {
        this._fragmentEntryLinkLocalService = fragmentEntryLinkLocalService;
        this._layoutLocalService = layoutLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeSchema();
        this._upgradeLayoutPageTemplates();
        this._upgradeLayouts();
    }

    private String _generateLayoutPageTemplateStructureData(long groupId, long classNameId, long classPK) {
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(groupId, classNameId, classPK);
        if (fragmentEntryLinks.isEmpty()) {
            LayoutStructure layoutStructure = new LayoutStructure();
            layoutStructure.addRootLayoutStructureItem();
            return layoutStructure.toString();
        }
        LayoutStructure layoutStructure = new LayoutStructure();
        LayoutStructureItem rootLayoutStructureItem = layoutStructure.addRootLayoutStructureItem();
        LayoutStructureItem containerStyledLayoutStructureItem = layoutStructure.addContainerStyledLayoutStructureItem(rootLayoutStructureItem.getItemId(), 0);
        for (int i = 0; i < fragmentEntryLinks.size(); ++i) {
            FragmentEntryLink fragmentEntryLink = (FragmentEntryLink)fragmentEntryLinks.get(i);
            layoutStructure.addFragmentStyledLayoutStructureItem(fragmentEntryLink.getFragmentEntryLinkId(), containerStyledLayoutStructureItem.getItemId(), i);
        }
        return layoutStructure.toString();
    }

    private void _updateLayoutPageTemplateStructure(long groupId, long companyId, long userId, String userName, Timestamp createDate, long classNameId, long classPK) {
        block14: {
            String sql = StringBundler.concat((String[])new String[]{"insert into LayoutPageTemplateStructure (uuid_, ", "layoutPageTemplateStructureId, groupId, companyId, userId, ", "userName, createDate, modifiedDate, classNameId, classPK, data_) ", "values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"});
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
                preparedStatement.setString(1, PortalUUIDUtil.generate());
                preparedStatement.setLong(2, this.increment());
                preparedStatement.setLong(3, groupId);
                preparedStatement.setLong(4, companyId);
                preparedStatement.setLong(5, userId);
                preparedStatement.setString(6, userName);
                preparedStatement.setTimestamp(7, createDate);
                preparedStatement.setTimestamp(8, createDate);
                preparedStatement.setLong(9, classNameId);
                preparedStatement.setLong(10, classPK);
                preparedStatement.setString(11, this._generateLayoutPageTemplateStructureData(groupId, classNameId, classPK));
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block14;
                _log.debug((Throwable)exception);
            }
        }
    }

    private void _upgradeLayoutPageTemplates() throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)LayoutPageTemplateEntry.class.getName());
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select layoutPageTemplateEntryId, groupId, companyId, ", "userId, userName, createDate from ", "LayoutPageTemplateEntry where type_ in (", 0, ", ", 1, ")"}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long layoutPageTemplateEntryId = resultSet.getLong("layoutPageTemplateEntryId");
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                Timestamp createDate = resultSet.getTimestamp("createDate");
                this._updateLayoutPageTemplateStructure(groupId, companyId, userId, userName, createDate, classNameId, layoutPageTemplateEntryId);
            }
        }
    }

    private void _upgradeLayouts() throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)Layout.class.getName());
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"type", (Object)"content")));
        actionableDynamicQuery.setPerformActionMethod(layout -> {
            Date createDate = layout.getCreateDate();
            this._updateLayoutPageTemplateStructure(layout.getGroupId(), layout.getCompanyId(), layout.getUserId(), layout.getUserName(), new Timestamp(createDate.getTime()), classNameId, layout.getPlid());
        });
        actionableDynamicQuery.performActions();
    }

    private void _upgradeSchema() throws Exception {
        String template = StringUtil.read((InputStream)LayoutPageTemplateStructureUpgradeProcess.class.getResourceAsStream("dependencies/update.sql"));
        this.runSQLTemplateString(template, false);
    }
}

