/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v2_1_0;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutUpgradeProcess
extends UpgradeProcess {
    private final FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    private final LayoutLocalService _layoutLocalService;
    private final LayoutPrototypeLocalService _layoutPrototypeLocalService;

    public LayoutUpgradeProcess(FragmentEntryLinkLocalService fragmentEntryLinkLocalService, LayoutLocalService layoutLocalService, LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._fragmentEntryLinkLocalService = fragmentEntryLinkLocalService;
        this._layoutLocalService = layoutLocalService;
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeSchema();
        this._upgradeLayout();
    }

    private long _getPlid(long companyId, long userId, long groupId, String name, int type, long layoutPrototypeId, ServiceContext serviceContext) throws Exception {
        if (type == 2 && layoutPrototypeId > 0L) {
            LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototype(layoutPrototypeId);
            Layout layout = layoutPrototype.getLayout();
            return layout.getPlid();
        }
        boolean privateLayout = false;
        String layoutType = "asset_display";
        if (type == 0) {
            layoutType = "content";
            privateLayout = true;
        }
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), name);
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        Layout layout = this._layoutLocalService.addLayout(PortalUtil.getValidUserId((long)companyId, (long)userId), groupId, privateLayout, 0L, titleMap, titleMap, null, null, null, layoutType, UnicodePropertiesBuilder.put((String)"published", (String)"true").buildString(), true, true, new HashMap(), serviceContext);
        return layout.getPlid();
    }

    private void _upgradeLayout() throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery(StringBundler.concat((String[])new String[]{"select layoutPageTemplateEntryId, groupId, companyId, ", "userId, name, type_, layoutPrototypeId, companyId from ", "LayoutPageTemplateEntry where plid is null or plid = 0"}));
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update LayoutPageTemplateEntry set plid = ? where layoutPageTemplateEntryId = ?");){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                long groupId = resultSet.getLong("groupId");
                String name = resultSet.getString("name");
                int type = resultSet.getInt("type_");
                long layoutPrototypeId = resultSet.getLong("layoutPrototypeId");
                long plid = this._getPlid(companyId, userId, groupId, name, type, layoutPrototypeId, serviceContext);
                preparedStatement.setLong(1, plid);
                long layoutPageTemplateEntryId = resultSet.getLong("layoutPageTemplateEntryId");
                preparedStatement.setLong(2, layoutPageTemplateEntryId);
                preparedStatement.addBatch();
                List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(groupId, PortalUtil.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntryId);
                Layout draftLayout = this._layoutLocalService.fetchDraftLayout(plid);
                for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
                    fragmentEntryLink.setClassNameId(PortalUtil.getClassNameId(Layout.class));
                    fragmentEntryLink.setClassPK(plid);
                    fragmentEntryLink.setPlid(plid);
                    this._fragmentEntryLinkLocalService.updateFragmentEntryLink(fragmentEntryLink);
                    this._fragmentEntryLinkLocalService.addFragmentEntryLink(draftLayout.getUserId(), draftLayout.getGroupId(), 0L, fragmentEntryLink.getFragmentEntryId(), 0L, draftLayout.getPlid(), fragmentEntryLink.getCss(), fragmentEntryLink.getHtml(), fragmentEntryLink.getJs(), fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues(), "", fragmentEntryLink.getPosition(), null, fragmentEntryLink.getType(), serviceContext);
                }
            }
            preparedStatement.executeBatch();
        }
    }

    private void _upgradeSchema() throws Exception {
        this.alterTableAddColumn("LayoutPageTemplateEntry", "plid", "LONG");
    }
}

