/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.service.impl;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.layout.page.template.service.base.LayoutPageTemplateStructureLocalServiceBaseImpl;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateStructure"}, service={AopService.class})
public class LayoutPageTemplateStructureLocalServiceImpl
extends LayoutPageTemplateStructureLocalServiceBaseImpl {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public LayoutPageTemplateStructure addLayoutPageTemplateStructure(long userId, long groupId, long plid, long segmentsExperienceId, String data, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long layoutPageTemplateStructureId = this.counterLocalService.increment();
        LayoutPageTemplateStructure layoutPageTemplateStructure = this.layoutPageTemplateStructurePersistence.create(layoutPageTemplateStructureId);
        layoutPageTemplateStructure.setUuid(serviceContext.getUuid());
        layoutPageTemplateStructure.setGroupId(groupId);
        layoutPageTemplateStructure.setCompanyId(user.getCompanyId());
        layoutPageTemplateStructure.setUserId(user.getUserId());
        layoutPageTemplateStructure.setUserName(user.getFullName());
        layoutPageTemplateStructure.setCreateDate(serviceContext.getCreateDate(new Date()));
        layoutPageTemplateStructure.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPageTemplateStructure.setClassNameId(this._portal.getClassNameId(Layout.class));
        layoutPageTemplateStructure.setClassPK(plid);
        layoutPageTemplateStructure = (LayoutPageTemplateStructure)this.layoutPageTemplateStructurePersistence.update((BaseModel)layoutPageTemplateStructure);
        int count = this._fragmentEntryLinkLocalService.getFragmentEntryLinksCountByPlid(groupId, plid);
        if (count > 0) {
            this._updateLayoutStatus(userId, plid);
        }
        if (!ExportImportThreadLocal.isImportInProcess()) {
            this._layoutPageTemplateStructureRelLocalService.addLayoutPageTemplateStructureRel(userId, groupId, layoutPageTemplateStructureId, segmentsExperienceId, data, serviceContext);
        }
        return layoutPageTemplateStructure;
    }

    @Override
    @SystemEvent(type=1)
    public LayoutPageTemplateStructure deleteLayoutPageTemplateStructure(LayoutPageTemplateStructure layoutPageTemplateStructure) {
        this.layoutPageTemplateStructurePersistence.remove((BaseModel)layoutPageTemplateStructure);
        List layoutPageTemplateStructureRels = this._layoutPageTemplateStructureRelLocalService.getLayoutPageTemplateStructureRels(layoutPageTemplateStructure.getLayoutPageTemplateStructureId());
        for (LayoutPageTemplateStructureRel layoutPageTemplateStructureRel : layoutPageTemplateStructureRels) {
            this._layoutPageTemplateStructureRelLocalService.deleteLayoutPageTemplateStructureRel(layoutPageTemplateStructureRel);
        }
        return layoutPageTemplateStructure;
    }

    public LayoutPageTemplateStructure deleteLayoutPageTemplateStructure(long groupId, long plid) throws PortalException {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this.layoutPageTemplateStructurePersistence.findByG_C_C(groupId, this._portal.getClassNameId(Layout.class), plid);
        this.layoutPageTemplateStructureLocalService.deleteLayoutPageTemplateStructure(layoutPageTemplateStructure);
        return layoutPageTemplateStructure;
    }

    public LayoutPageTemplateStructure fetchLayoutPageTemplateStructure(long groupId, long plid) {
        return this.layoutPageTemplateStructurePersistence.fetchByG_C_C(groupId, this._portal.getClassNameId(Layout.class), plid);
    }

    public LayoutPageTemplateStructure fetchLayoutPageTemplateStructure(long groupId, long plid, boolean rebuildStructure) throws PortalException {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this.fetchLayoutPageTemplateStructure(groupId, plid);
        if (layoutPageTemplateStructure != null || !rebuildStructure) {
            return layoutPageTemplateStructure;
        }
        return this.layoutPageTemplateStructureLocalService.rebuildLayoutPageTemplateStructure(groupId, plid);
    }

    public LayoutPageTemplateStructure rebuildLayoutPageTemplateStructure(long groupId, long plid) throws PortalException {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this.fetchLayoutPageTemplateStructure(groupId, plid);
        if (layoutPageTemplateStructure != null) {
            return this.updateLayoutPageTemplateStructureData(groupId, plid, this._generateContentLayoutStructureData(groupId, plid));
        }
        long defaultSegmentsExperienceId = this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(plid);
        if (defaultSegmentsExperienceId <= 0L) {
            SegmentsExperience defaultSegmentsExperience = this._segmentsExperienceLocalService.addDefaultSegmentsExperience(PrincipalThreadLocal.getUserId(), plid, ServiceContextThreadLocal.getServiceContext());
            defaultSegmentsExperienceId = defaultSegmentsExperience.getSegmentsExperienceId();
        }
        return this.addLayoutPageTemplateStructure(PrincipalThreadLocal.getUserId(), groupId, plid, defaultSegmentsExperienceId, this._generateContentLayoutStructureData(groupId, plid), ServiceContextThreadLocal.getServiceContext());
    }

    public LayoutPageTemplateStructure updateLayoutPageTemplateStructureData(long groupId, long plid, long segmentsExperienceId, String data) throws PortalException {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this.layoutPageTemplateStructurePersistence.findByG_C_C(groupId, this._portal.getClassNameId(Layout.class), plid);
        layoutPageTemplateStructure.setModifiedDate(new Date());
        layoutPageTemplateStructure = (LayoutPageTemplateStructure)this.layoutPageTemplateStructurePersistence.update((BaseModel)layoutPageTemplateStructure);
        LayoutPageTemplateStructureRel layoutPageTemplateStructureRel = this._layoutPageTemplateStructureRelLocalService.fetchLayoutPageTemplateStructureRel(layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperienceId);
        if (layoutPageTemplateStructureRel == null) {
            this._layoutPageTemplateStructureRelLocalService.addLayoutPageTemplateStructureRel(PrincipalThreadLocal.getUserId(), groupId, layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperienceId, data, ServiceContextThreadLocal.getServiceContext());
        } else {
            this._layoutPageTemplateStructureRelLocalService.updateLayoutPageTemplateStructureRel(layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperienceId, data);
        }
        this._updateLayoutStatus(PrincipalThreadLocal.getUserId(), plid);
        return layoutPageTemplateStructure;
    }

    public LayoutPageTemplateStructure updateLayoutPageTemplateStructureData(long groupId, long plid, String data) throws PortalException {
        long defaultSegmentsExperienceId = this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(plid);
        return this.layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(groupId, plid, defaultSegmentsExperienceId, data);
    }

    private String _generateContentLayoutStructureData(long groupId, long plid) throws PortalException {
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinksByPlid(groupId, plid);
        int type = this._getLayoutPageTemplateEntryType(this._layoutLocalService.getLayout(plid));
        if (fragmentEntryLinks.isEmpty() && type == 3) {
            LayoutStructure layoutStructure = new LayoutStructure();
            LayoutStructureItem rootLayoutStructureItem = layoutStructure.addRootLayoutStructureItem();
            layoutStructure.addDropZoneLayoutStructureItem(rootLayoutStructureItem.getItemId(), 0);
            return layoutStructure.toString();
        }
        if (fragmentEntryLinks.isEmpty()) {
            LayoutStructure layoutStructure = new LayoutStructure();
            layoutStructure.addRootLayoutStructureItem();
            return layoutStructure.toString();
        }
        LayoutStructure layoutStructure = new LayoutStructure();
        LayoutStructureItem rootLayoutStructureItem = layoutStructure.addRootLayoutStructureItem();
        LayoutStructureItem containerStyledLayoutStructureItem = layoutStructure.addContainerStyledLayoutStructureItem(rootLayoutStructureItem.getItemId(), 0);
        for (int i = 0; i < fragmentEntryLinks.size(); ++i) {
            FragmentEntryLink fragmentEntryLink = (FragmentEntryLink)fragmentEntryLinks.get(i);
            layoutStructure.addFragmentStyledLayoutStructureItem(fragmentEntryLink.getFragmentEntryLinkId(), containerStyledLayoutStructureItem.getItemId(), i);
        }
        return layoutStructure.toString();
    }

    private int _getLayoutPageTemplateEntryType(Layout layout) {
        LayoutPageTemplateEntry draftLayoutPageTemplateEntry;
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getClassPK());
        if (layoutPageTemplateEntry != null) {
            return layoutPageTemplateEntry.getType();
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout != null && (draftLayoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(draftLayout.getClassPK())) != null) {
            return draftLayoutPageTemplateEntry.getType();
        }
        return 0;
    }

    private void _updateLayoutStatus(long userId, long plid) throws PortalException {
        this._layoutLocalService.updateStatus(userId, plid, 2, ServiceContextThreadLocal.getServiceContext());
    }
}

