/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.exportimport.content.processor;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.info.search.InfoSearchClassMapperRegistry;
import com.liferay.item.selector.criteria.InfoListItemSelectorReturnType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.processor.type=LayoutPageTemplateStructureRelReferences"}, service={ExportImportContentProcessor.class})
public class DataValuesMappingExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final String _DDM_TEMPLATE = "ddmTemplate_";
    private static final Log _log = LogFactoryUtil.getLog(DataValuesMappingExportImportContentProcessor.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetListEntryLocalService _assetListEntryLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private InfoSearchClassMapperRegistry _infoSearchClassMapperRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String data, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        if (!JSONUtil.isJSONObject((String)data)) {
            return data;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(data);
        this._exportContentReferences(exportReferencedContent, jsonObject, portletDataContext, stagedModel);
        return jsonObject.toString();
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String data) throws Exception {
        if (!JSONUtil.isJSONObject((String)data)) {
            return data;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(data);
        this._replaceImportContentReferences(jsonObject, portletDataContext);
        return jsonObject.toString();
    }

    public void validateContentReferences(long groupId, String data) {
    }

    private void _exportCollectionContentReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) {
        block6: {
            if (!itemJSONObject.has("config")) {
                return;
            }
            JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
            if (!configJSONObject.has("collection")) {
                return;
            }
            JSONObject collectionJSONObject = configJSONObject.getJSONObject("collection");
            String type = collectionJSONObject.getString("type");
            if (!Objects.equals(type, InfoListItemSelectorReturnType.class.getName())) {
                return;
            }
            long classPK = collectionJSONObject.getLong("classPK");
            AssetListEntry assetListEntry = this._assetListEntryLocalService.fetchAssetListEntry(classPK);
            if (assetListEntry != null) {
                try {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)assetListEntry, (StagedModel)stagedModel, (String)"dependency");
                }
                catch (PortletDataException portletDataException) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Throwable)portletDataException);
                }
            }
        }
    }

    private void _exportContainerContentReferences(boolean exportReferencedContent, JSONObject itemJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (configJSONObject.has("link")) {
            JSONObject linkJSONObject = configJSONObject.getJSONObject("link");
            this._exportMappedFieldContentReference(exportReferencedContent, linkJSONObject, portletDataContext, stagedModel);
            if (linkJSONObject.has("layout")) {
                this._exportLayoutContentReference(exportReferencedContent, linkJSONObject.getJSONObject("layout"), portletDataContext, stagedModel);
            }
        }
        if (!configJSONObject.has("styles")) {
            return;
        }
        JSONObject stylesJSONObject = configJSONObject.getJSONObject("styles");
        if (stylesJSONObject.has("backgroundImage")) {
            this._exportMappedFieldContentReference(exportReferencedContent, stylesJSONObject.getJSONObject("backgroundImage"), portletDataContext, stagedModel);
        }
    }

    private void _exportContentReferences(boolean exportReferencedContent, JSONObject jsonObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (!jsonObject.has("items")) {
            return;
        }
        JSONObject itemsJSONObject = jsonObject.getJSONObject("items");
        if (itemsJSONObject == null) {
            return;
        }
        for (String key : itemsJSONObject.keySet()) {
            JSONObject itemJSONObject = itemsJSONObject.getJSONObject(key);
            if (Objects.equals(itemJSONObject.get("type"), "container")) {
                this._exportContainerContentReferences(exportReferencedContent, itemJSONObject, portletDataContext, stagedModel);
                continue;
            }
            if (Objects.equals(itemJSONObject.get("type"), "collection")) {
                this._exportCollectionContentReferences(itemJSONObject, portletDataContext, stagedModel);
                continue;
            }
            if (!Objects.equals(itemJSONObject.get("type"), "form") && !Objects.equals(itemJSONObject.get("type"), "row")) continue;
            this._exportFormOrRowContentReferences(exportReferencedContent, itemJSONObject, portletDataContext, stagedModel);
        }
    }

    private void _exportDDMTemplateReference(JSONObject editableJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        String mappedField = editableJSONObject.getString("mappedField", editableJSONObject.getString("fieldId"));
        if (!mappedField.startsWith(_DDM_TEMPLATE)) {
            return;
        }
        String ddmTemplateKey = mappedField.substring(_DDM_TEMPLATE.length());
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(DDMStructure.class), ddmTemplateKey);
        if (ddmTemplate != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)ddmTemplate, (String)"dependency");
        }
    }

    private void _exportFormOrRowContentReferences(boolean exportReferencedContent, JSONObject itemJSONObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (!configJSONObject.has("styles")) {
            return;
        }
        JSONObject stylesJSONObject = configJSONObject.getJSONObject("styles");
        if (stylesJSONObject.has("backgroundImage")) {
            this._exportMappedFieldContentReference(exportReferencedContent, stylesJSONObject.getJSONObject("backgroundImage"), portletDataContext, stagedModel);
        }
    }

    private void _exportLayoutContentReference(boolean exportReferencedContent, JSONObject layoutJSONObject, PortletDataContext portletDataContext, StagedModel referrerStagedModel) throws Exception {
        if (layoutJSONObject.length() == 0) {
            return;
        }
        Layout layout = this._layoutLocalService.fetchLayout(layoutJSONObject.getLong("groupId"), layoutJSONObject.getBoolean("privateLayout"), layoutJSONObject.getLong("layoutId"));
        if (layout == null) {
            return;
        }
        layoutJSONObject.put("plid", layout.getPlid());
        if (exportReferencedContent) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)referrerStagedModel, (StagedModel)layout, (String)"dependency");
        } else {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)referrerStagedModel);
            portletDataContext.addReferenceElement((ClassedModel)referrerStagedModel, entityElement, (ClassedModel)layout, "dependency", true);
        }
    }

    private void _exportMappedFieldContentReference(boolean exportReferencedContent, JSONObject jsonObject, PortletDataContext portletDataContext, StagedModel stagedModel) throws Exception {
        long classNameId = jsonObject.getLong("classNameId");
        long classPK = jsonObject.getLong("classPK");
        if (classNameId == 0L || classPK == 0L) {
            return;
        }
        this._exportDDMTemplateReference(jsonObject, portletDataContext, stagedModel);
        String className = this._portal.getClassName(classNameId);
        jsonObject.put("className", className);
        className = this._infoSearchClassMapperRegistry.getSearchClassName(className);
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(className, classPK);
        if (assetEntry == null) {
            return;
        }
        AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
        if (assetRenderer == null) {
            return;
        }
        AssetRendererFactory assetRendererFactory = assetRenderer.getAssetRendererFactory();
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        if (ExportImportThreadLocal.isStagingInProcess() && !stagingGroupHelper.isStagedPortlet(portletDataContext.getScopeGroupId(), assetRendererFactory.getPortletId())) {
            return;
        }
        if (exportReferencedContent) {
            try {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)((StagedModel)assetRenderer.getAssetObject()), (String)"dependency");
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    String errorMessage = StringBundler.concat((Object[])new Object[]{"Staged model with class name ", stagedModel.getModelClassName(), " and primary key ", stagedModel.getPrimaryKeyObj(), " references asset entry with class primary key ", classPK, " and class name ", this._portal.getClassName(classNameId), " that could not be exported due to ", exception});
                    if (Validator.isNotNull((String)exception.getMessage())) {
                        errorMessage = StringBundler.concat((String[])new String[]{errorMessage, ": ", exception.getMessage()});
                    }
                    _log.debug((Object)errorMessage, (Throwable)exception);
                }
            }
        } else {
            Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
            portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)assetRenderer.getAssetObject(), "dependency", true);
        }
    }

    private void _replaceCollectionImportContentReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext) {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (!configJSONObject.has("collection")) {
            return;
        }
        JSONObject collectionJSONObject = configJSONObject.getJSONObject("collection");
        String type = collectionJSONObject.getString("type");
        if (!Objects.equals(type, InfoListItemSelectorReturnType.class.getName())) {
            return;
        }
        long classPK = collectionJSONObject.getLong("classPK");
        Map assetListEntryNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(AssetListEntry.class.getName());
        long newClassPK = MapUtil.getLong((Map)assetListEntryNewPrimaryKeys, (long)classPK, (long)classPK);
        AssetListEntry assetListEntry = this._assetListEntryLocalService.fetchAssetListEntry(newClassPK);
        if (assetListEntry != null) {
            collectionJSONObject.put("classNameId", this._portal.getClassNameId(assetListEntry.getAssetEntryType())).put("classPK", String.valueOf(newClassPK)).put("itemSubtype", assetListEntry.getAssetEntrySubtype()).put("itemType", assetListEntry.getAssetEntryType()).put("title", assetListEntry.getTitle());
        }
    }

    private void _replaceContainerImportContentReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext) {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (configJSONObject.has("link")) {
            JSONObject linkJSONObject = configJSONObject.getJSONObject("link");
            this._replaceMappedFieldImportContentReferences(linkJSONObject, portletDataContext);
            if (linkJSONObject.has("layout")) {
                this._replaceImportLayoutReferences(linkJSONObject.getJSONObject("layout"), portletDataContext);
            }
        }
        if (!configJSONObject.has("styles")) {
            return;
        }
        JSONObject stylesJSONObject = configJSONObject.getJSONObject("styles");
        if (stylesJSONObject.has("backgroundImage")) {
            this._replaceMappedFieldImportContentReferences(stylesJSONObject.getJSONObject("backgroundImage"), portletDataContext);
        }
    }

    private void _replaceFormOrRowImportContentReferences(JSONObject itemJSONObject, PortletDataContext portletDataContext) {
        if (!itemJSONObject.has("config")) {
            return;
        }
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        if (!configJSONObject.has("styles")) {
            return;
        }
        JSONObject stylesJSONObject = configJSONObject.getJSONObject("styles");
        if (stylesJSONObject.has("backgroundImage")) {
            this._replaceMappedFieldImportContentReferences(stylesJSONObject.getJSONObject("backgroundImage"), portletDataContext);
        }
    }

    private void _replaceImportContentReferences(JSONObject jsonObject, PortletDataContext portletDataContext) {
        if (!jsonObject.has("items")) {
            return;
        }
        JSONObject itemsJSONObject = jsonObject.getJSONObject("items");
        if (itemsJSONObject == null) {
            return;
        }
        for (String key : itemsJSONObject.keySet()) {
            JSONObject itemJSONObject = itemsJSONObject.getJSONObject(key);
            if (Objects.equals(itemJSONObject.get("type"), "container")) {
                this._replaceContainerImportContentReferences(itemJSONObject, portletDataContext);
                continue;
            }
            if (Objects.equals(itemJSONObject.get("type"), "collection")) {
                this._replaceCollectionImportContentReferences(itemJSONObject, portletDataContext);
                continue;
            }
            if (!Objects.equals(itemJSONObject.get("type"), "form") && !Objects.equals(itemJSONObject.get("type"), "row")) continue;
            this._replaceFormOrRowImportContentReferences(itemJSONObject, portletDataContext);
        }
    }

    private void _replaceImportLayoutReferences(JSONObject layoutJSONObject, PortletDataContext portletDataContext) {
        if (layoutJSONObject.length() == 0) {
            return;
        }
        long plid = GetterUtil.getLong((Object)layoutJSONObject.remove("plid"));
        Map layoutNewPrimaryKeys = portletDataContext.getNewPrimaryKeysMap(Layout.class.getName());
        Layout layout = this._layoutLocalService.fetchLayout(layoutNewPrimaryKeys.getOrDefault(plid, 0L).longValue());
        if (layout == null) {
            return;
        }
        layoutJSONObject.put("groupId", layout.getGroupId()).put("layoutId", layout.getLayoutId()).put("layoutUuid", layout.getUuid()).put("privateLayout", layout.isPrivateLayout());
    }

    private void _replaceMappedFieldImportContentReferences(JSONObject jsonObject, PortletDataContext portletDataContext) {
        String className = jsonObject.getString("className");
        if (Validator.isNull((String)className)) {
            return;
        }
        String mappedField = jsonObject.getString("mappedField", jsonObject.getString("fieldId"));
        if (mappedField.startsWith(_DDM_TEMPLATE)) {
            String ddmTemplateKey = mappedField.substring(_DDM_TEMPLATE.length());
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
            String importedDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)ddmTemplateKey, (String)ddmTemplateKey);
            if (jsonObject.has("mappedField")) {
                jsonObject.put("mappedField", _DDM_TEMPLATE + importedDDMTemplateKey);
            } else {
                jsonObject.put("fieldId", _DDM_TEMPLATE + importedDDMTemplateKey);
            }
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this._infoSearchClassMapperRegistry.getSearchClassName(className));
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        if (ExportImportThreadLocal.isStagingInProcess() && !stagingGroupHelper.isStagedPortlet(portletDataContext.getScopeGroupId(), assetRendererFactory.getPortletId())) {
            return;
        }
        long classPK = jsonObject.getLong("classPK");
        if (classPK == 0L) {
            return;
        }
        jsonObject.put("classNameId", this._portal.getClassNameId(className));
        Map primaryKeys = portletDataContext.getNewPrimaryKeysMap(className);
        classPK = MapUtil.getLong((Map)primaryKeys, (long)classPK, (long)classPK);
        jsonObject.put("classPK", classPK);
        if (jsonObject.has("fileEntryId")) {
            jsonObject.put("fileEntryId", classPK);
        }
    }
}

