/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.info.item.provider;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSet;
import com.liferay.info.field.InfoFieldSetEntry;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.DisplayPageInfoFieldType;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.URLInfoFieldType;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.layout.page.template.info.item.provider.DisplayPageInfoItemFieldSetProvider;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DisplayPageInfoItemFieldSetProvider.class})
public class DisplayPageInfoItemFieldSetProviderImpl
implements DisplayPageInfoItemFieldSetProvider {
    private static final Log _log = LogFactoryUtil.getLog(DisplayPageInfoItemFieldSetProviderImpl.class);
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;

    public InfoFieldSet getInfoFieldSet(String itemClassName, String infoItemFormVariationKey, long scopeGroupId) {
        return InfoFieldSet.builder().infoFieldSetEntries(this._getInfoFieldSetEntries(itemClassName, infoItemFormVariationKey, scopeGroupId)).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"display-page")).name("display-page").build();
    }

    public List<InfoFieldValue<Object>> getInfoFieldValues(InfoItemReference infoItemReference, String infoItemFormVariationKey, ThemeDisplay themeDisplay) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-183727") || themeDisplay == null) {
            return Collections.emptyList();
        }
        ArrayList<InfoFieldValue<Object>> infoFieldValues = new ArrayList<InfoFieldValue<Object>>();
        infoFieldValues.add(new InfoFieldValue(InfoField.builder((String)infoItemReference.getClassName()).infoFieldType((InfoFieldType)URLInfoFieldType.INSTANCE).name("displayPageURL").labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"default")).build(), (Object)this._getDefaultDisplayPageURL(infoItemReference, themeDisplay)));
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(themeDisplay.getScopeGroupId(), this._portal.getClassNameId(infoItemReference.getClassName()), GetterUtil.getLong((String)infoItemFormVariationKey), 1);
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)URLInfoFieldType.INSTANCE).uniqueId(this._getUniqueId(layoutPageTemplateEntry.getLayoutPageTemplateEntryKey())).name(layoutPageTemplateEntry.getName()).labelInfoLocalizedValue(InfoLocalizedValue.singleValue((String)layoutPageTemplateEntry.getName())).build(), (Object)HttpComponentsUtil.addParameters((String)(themeDisplay.getPortalURL() + "/display-page/custom/"), (Object[])new Object[]{"className", infoItemReference.getClassName(), "classPK", this._getClassPK(infoItemReference), "selPlid", layoutPageTemplateEntry.getPlid()})));
        }
        return infoFieldValues;
    }

    private long _getClassPK(InfoItemReference infoItemReference) {
        if (infoItemReference.getInfoItemIdentifier() instanceof ClassPKInfoItemIdentifier) {
            ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
            return classPKInfoItemIdentifier.getClassPK();
        }
        return 0L;
    }

    private String _getDefaultDisplayPageURL(InfoItemReference infoItemReference, ThemeDisplay themeDisplay) throws Exception {
        block5: {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)infoItemReference.getClassName());
            if (assetRendererFactory == null) {
                return this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(infoItemReference, themeDisplay);
            }
            try {
                AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(this._getClassPK(infoItemReference));
                if (assetRenderer == null) {
                    return this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(infoItemReference, themeDisplay);
                }
                String viewInContextURL = assetRenderer.getURLViewInContext(themeDisplay, "");
                if (Validator.isNotNull((String)viewInContextURL)) {
                    return viewInContextURL;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        return this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(infoItemReference, themeDisplay);
    }

    private InfoField<InfoFieldType> _getDefaultDisplayPageURLInfoField(String className) {
        return InfoField.builder((String)className).infoFieldType(this._getDisplayPageInfoFieldType()).name("displayPageURL").labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"default")).build();
    }

    private InfoFieldType _getDisplayPageInfoFieldType() {
        if (FeatureFlagManagerUtil.isEnabled((String)"LPS-183498")) {
            return DisplayPageInfoFieldType.INSTANCE;
        }
        return URLInfoFieldType.INSTANCE;
    }

    private List<InfoFieldSetEntry> _getInfoFieldSetEntries(String itemClassName, String infoItemFormVariationKey, long scopeGroupId) {
        ArrayList<InfoFieldSetEntry> infoFieldSetEntries = new ArrayList<InfoFieldSetEntry>();
        infoFieldSetEntries.add((InfoFieldSetEntry)this._getDefaultDisplayPageURLInfoField(itemClassName));
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(scopeGroupId, this._portal.getClassNameId(itemClassName), GetterUtil.getLong((String)infoItemFormVariationKey), 1);
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            infoFieldSetEntries.add((InfoFieldSetEntry)InfoField.builder().infoFieldType(this._getDisplayPageInfoFieldType()).uniqueId(this._getUniqueId(layoutPageTemplateEntry.getLayoutPageTemplateEntryKey())).name(layoutPageTemplateEntry.getName()).labelInfoLocalizedValue(InfoLocalizedValue.singleValue((String)layoutPageTemplateEntry.getName())).build());
        }
        return infoFieldSetEntries;
    }

    private String _getUniqueId(String layoutPageTemplateEntryKey) {
        return LayoutPageTemplateEntry.class.getSimpleName() + "_" + layoutPageTemplateEntryKey;
    }
}

