/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_3_0;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.internal.upgrade.v3_3_0.util.EditableValuesTransformerUtil;
import com.liferay.layout.page.template.internal.upgrade.v3_3_0.util.LayoutDataConverter;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayoutPageTemplateStructureRelUpgradeProcess
extends UpgradeProcess {
    private static final String _INSTANCE_SEPARATOR = "_INSTANCE_";
    private static final long _SEGMENTS_EXPERIENCE_ID_DEFAULT = 0L;
    private static final String _SEGMENTS_EXPERIENCE_SEPARATOR_1 = "_SEGMENTS_EXPERIENCE_";
    private static final String _SEGMENTS_EXPERIENCE_SEPARATOR_2 = "SEGMENTSEXPERIENCE";
    private final FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    private final PortletPreferencesLocalService _portletPreferencesLocalService;
    private final Map<Long, List<PortletPreferences>> _portletPreferencesMap = new HashMap<Long, List<PortletPreferences>>();

    public LayoutPageTemplateStructureRelUpgradeProcess(FragmentEntryLinkLocalService fragmentEntryLinkLocalService, PortletPreferencesLocalService portletPreferencesLocalService) {
        this._fragmentEntryLinkLocalService = fragmentEntryLinkLocalService;
        this._portletPreferencesLocalService = portletPreferencesLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeLayoutPageTemplateStructureRel();
    }

    private List<PortletPreferences> _getPortletPreferencesByPlid(long plid) {
        if (this._portletPreferencesMap.containsKey(plid)) {
            return this._portletPreferencesMap.get(plid);
        }
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferencesByPlid(plid);
        this._portletPreferencesMap.put(plid, ListUtil.filter((List)portletPreferencesList, portletPreferences -> {
            String portletId = portletPreferences.getPortletId();
            return portletId.contains(_INSTANCE_SEPARATOR) && (portletId.contains(_SEGMENTS_EXPERIENCE_SEPARATOR_1) || portletId.contains(_SEGMENTS_EXPERIENCE_SEPARATOR_2));
        }));
        return this._portletPreferencesMap.get(plid);
    }

    private void _updatePortletPreferences(String newNamespace, String oldNamespace, long plid, long segmentsExperienceId) {
        for (PortletPreferences portletPreferences : this._getPortletPreferencesByPlid(plid)) {
            String portletId = portletPreferences.getPortletId();
            if (!portletId.contains(oldNamespace) || !portletId.contains(_SEGMENTS_EXPERIENCE_SEPARATOR_1 + segmentsExperienceId) && !portletId.contains(_SEGMENTS_EXPERIENCE_SEPARATOR_2 + segmentsExperienceId)) continue;
            portletPreferences.setPortletId(StringUtil.replace((String)portletId, (String[])new String[]{oldNamespace, _SEGMENTS_EXPERIENCE_SEPARATOR_1 + segmentsExperienceId, _SEGMENTS_EXPERIENCE_SEPARATOR_2 + segmentsExperienceId}, (String[])new String[]{newNamespace, "", ""}));
            this._portletPreferencesLocalService.updatePortletPreferences(portletPreferences);
        }
    }

    private String _upgradeLayoutData(String data, long segmentsExperienceId) throws PortalException {
        data = LayoutDataConverter.convert(data);
        LayoutStructure layoutStructure = LayoutStructure.of((String)data);
        for (LayoutStructureItem layoutStructureItem : layoutStructure.getLayoutStructureItems()) {
            FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem;
            FragmentEntryLink fragmentEntryLink;
            if (!(layoutStructureItem instanceof FragmentStyledLayoutStructureItem) || (fragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink((fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem).getFragmentEntryLinkId())) == null) continue;
            if (segmentsExperienceId == 0L) {
                fragmentEntryLink.setEditableValues(EditableValuesTransformerUtil.getEditableValues(fragmentEntryLink.getEditableValues(), segmentsExperienceId));
                fragmentEntryLink = this._fragmentEntryLinkLocalService.updateFragmentEntryLink(fragmentEntryLink);
                continue;
            }
            String newNamespace = StringUtil.randomId();
            String oldNamespace = fragmentEntryLink.getNamespace();
            JSONObject editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
            String instanceId = editableValuesJSONObject.getString("instanceId");
            String portletId = editableValuesJSONObject.getString("portletId");
            if (Validator.isNotNull((String)instanceId) && Validator.isNotNull((String)portletId)) {
                editableValuesJSONObject.remove("instanceId");
                editableValuesJSONObject.put("instanceId", newNamespace);
                oldNamespace = instanceId;
            }
            this._updatePortletPreferences(newNamespace, oldNamespace, fragmentEntryLink.getPlid(), segmentsExperienceId);
            FragmentEntryLink newFragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(fragmentEntryLink.getUserId(), fragmentEntryLink.getGroupId(), fragmentEntryLink.getOriginalFragmentEntryLinkId(), fragmentEntryLink.getFragmentEntryId(), segmentsExperienceId, fragmentEntryLink.getPlid(), fragmentEntryLink.getCss(), fragmentEntryLink.getHtml(), fragmentEntryLink.getJs(), fragmentEntryLink.getConfiguration(), EditableValuesTransformerUtil.getEditableValues(editableValuesJSONObject.toString(), segmentsExperienceId), newNamespace, fragmentEntryLink.getPosition(), fragmentEntryLink.getRendererKey(), fragmentEntryLink.getType(), new ServiceContext());
            fragmentStyledLayoutStructureItem.setFragmentEntryLinkId(newFragmentEntryLink.getFragmentEntryLinkId());
        }
        JSONObject layoutDataJSONObject = layoutStructure.toJSONObject();
        return layoutDataJSONObject.toString();
    }

    private void _upgradeLayoutPageTemplateStructureRel() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select lPageTemplateStructureRelId, segmentsExperienceId, data_ from LayoutPageTemplateStructureRel order by segmentsExperienceId desc");
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update LayoutPageTemplateStructureRel set data_ = ? where lPageTemplateStructureRelId = ?");){
            while (resultSet.next()) {
                long layoutPageTemplateStructureRelId = resultSet.getLong("lPageTemplateStructureRelId");
                long segmentsExperienceId = resultSet.getLong("segmentsExperienceId");
                String data = resultSet.getString("data_");
                preparedStatement.setString(1, this._upgradeLayoutData(data, segmentsExperienceId));
                preparedStatement.setLong(2, layoutPageTemplateStructureRelId);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }
}

