/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v4_0_0;

import com.liferay.layout.util.CollectionPaginationUtil;
import com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

public class LayoutPageTemplateStructureRelUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(LayoutPageTemplateStructureRelUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this._upgradeLayoutPageTemplateStructureRel();
    }

    private JSONObject _getItemsJSONObject(String data) {
        try {
            JSONObject layoutStructureJSONObject = JSONFactoryUtil.createJSONObject((String)data);
            return layoutStructureJSONObject.getJSONObject("items");
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return JSONFactoryUtil.createJSONObject();
        }
    }

    private String _getPaginatiopnType(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem, JSONObject itemsJSONObject) {
        JSONObject itemJSONObject = itemsJSONObject.getJSONObject(collectionStyledLayoutStructureItem.getItemId());
        JSONObject configJSONObject = itemJSONObject.getJSONObject("config");
        return configJSONObject.getString("paginationType");
    }

    private String _upgradeLayoutData(String data) {
        JSONObject itemsJSONObject = this._getItemsJSONObject(data);
        LayoutStructure layoutStructure = LayoutStructure.of((String)data);
        List layoutStructureItems = layoutStructure.getLayoutStructureItems();
        for (LayoutStructureItem layoutStructureItem : layoutStructureItems) {
            if (!(layoutStructureItem instanceof CollectionStyledLayoutStructureItem)) continue;
            CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem = (CollectionStyledLayoutStructureItem)layoutStructureItem;
            collectionStyledLayoutStructureItem.setDisplayAllItems(Boolean.valueOf(false));
            String paginationType = this._getPaginatiopnType(collectionStyledLayoutStructureItem, itemsJSONObject);
            if (CollectionPaginationUtil.isPaginationEnabled((String)paginationType)) {
                collectionStyledLayoutStructureItem.setDisplayAllPages(Boolean.valueOf(collectionStyledLayoutStructureItem.isShowAllItems()));
                int numberOfItemsPerPage = collectionStyledLayoutStructureItem.getNumberOfItemsPerPage();
                if (numberOfItemsPerPage > 0) {
                    int numberOfItems = collectionStyledLayoutStructureItem.getNumberOfItems();
                    collectionStyledLayoutStructureItem.setNumberOfPages((int)Math.ceil((double)numberOfItems / (double)numberOfItemsPerPage));
                }
            } else {
                paginationType = "none";
            }
            collectionStyledLayoutStructureItem.setPaginationType(paginationType);
        }
        JSONObject jsonObject = layoutStructure.toJSONObject();
        return jsonObject.toString();
    }

    private void _upgradeLayoutPageTemplateStructureRel() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select lPageTemplateStructureRelId, data_ from LayoutPageTemplateStructureRel");
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update LayoutPageTemplateStructureRel set data_ = ? where lPageTemplateStructureRelId = ?");){
            while (resultSet.next()) {
                long layoutPageTemplateStructureRelId = resultSet.getLong("lPageTemplateStructureRelId");
                String data = resultSet.getString("data_");
                preparedStatement.setString(1, this._upgradeLayoutData(data));
                preparedStatement.setLong(2, layoutPageTemplateStructureRelId);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }
}

