/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v5_1_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class LayoutPageTemplateStructureUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(LayoutPageTemplateStructureUpgradeProcess.class);
    private final LayoutLocalService _layoutLocalService;
    private final SegmentsExperienceLocalService _segmentsExperienceLocalService;
    private final UserLocalService _userLocalService;

    public LayoutPageTemplateStructureUpgradeProcess(LayoutLocalService layoutLocalService, SegmentsExperienceLocalService segmentsExperienceLocalService, UserLocalService userLocalService) {
        this._layoutLocalService = layoutLocalService;
        this._segmentsExperienceLocalService = segmentsExperienceLocalService;
        this._userLocalService = userLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select layoutPageTemplateStructureId, companyId, userId,classPK from LayoutPageTemplateStructure");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long layoutPageTemplateStructureId = resultSet.getLong("layoutPageTemplateStructureId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                long classPK = resultSet.getLong("classPK");
                this._addDefaultSegmentsExperience(classPK, companyId, layoutPageTemplateStructureId, userId);
            }
        }
    }

    private void _addDefaultSegmentsExperience(long classPK, long companyId, long layoutPageTemplateStructureId, long userId) throws Exception {
        Layout layout = this._layoutLocalService.fetchLayout(classPK);
        if (layout == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No layout found with PLID " + classPK));
            }
            return;
        }
        long defaultSegmentsExperienceId = this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(classPK);
        if (defaultSegmentsExperienceId <= 0L) {
            User user = this._userLocalService.fetchUser(userId);
            if (user == null) {
                userId = this._userLocalService.getGuestUserId(companyId);
            }
            SegmentsExperience defaultSegmentsExperience = this._segmentsExperienceLocalService.addDefaultSegmentsExperience(userId, classPK, new ServiceContext());
            defaultSegmentsExperienceId = defaultSegmentsExperience.getSegmentsExperienceId();
        }
        long draftClassPK = 0L;
        long publishedClassPK = 0L;
        if (layout.isDraftLayout()) {
            draftClassPK = layout.getPlid();
            publishedClassPK = layout.getClassPK();
        } else {
            Layout draftLayout = this._layoutLocalService.fetchDraftLayout(layout.getPlid());
            if (draftLayout != null) {
                draftClassPK = draftLayout.getPlid();
            }
            publishedClassPK = layout.getPlid();
        }
        this._updateFragmentEntryLinks(defaultSegmentsExperienceId, draftClassPK, publishedClassPK);
        this._updateLayoutPageTemplateStructureRels(defaultSegmentsExperienceId, layoutPageTemplateStructureId);
        this._updateSegmentsExperiments(defaultSegmentsExperienceId, draftClassPK, publishedClassPK);
        this._updateSegmentsExperimentRels(defaultSegmentsExperienceId, draftClassPK, publishedClassPK);
    }

    private void _updateFragmentEntryLinks(long defaultSegmentsExperienceId, long draftPlid, long publishedPlid) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update FragmentEntryLink set segmentsExperienceId = ? where segmentsExperienceId = 0 and (plid = ? or plid = ?)");){
            preparedStatement.setLong(1, defaultSegmentsExperienceId);
            preparedStatement.setLong(2, draftPlid);
            preparedStatement.setLong(3, publishedPlid);
            preparedStatement.executeUpdate();
        }
    }

    private void _updateLayoutPageTemplateStructureRels(long defaultSegmentsExperienceId, long layoutPageTemplateStructureId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update LayoutPageTemplateStructureRel set segmentsExperienceId = ? where segmentsExperienceId = 0 and layoutPageTemplateStructureId = ?");){
            preparedStatement.setLong(1, defaultSegmentsExperienceId);
            preparedStatement.setLong(2, layoutPageTemplateStructureId);
            preparedStatement.executeUpdate();
        }
    }

    private void _updateSegmentsExperimentRels(long defaultSegmentsExperienceId, long draftPlid, long publishedPlid) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update SegmentsExperimentRel set segmentsExperienceId = ", "? where segmentsExperienceId = 0 and ", "segmentsExperimentId in (select ", "SegmentsExperiment.segmentsExperimentId from ", "SegmentsExperiment where plid = ? or plid = ?)"}));){
            preparedStatement.setLong(1, defaultSegmentsExperienceId);
            preparedStatement.setLong(2, draftPlid);
            preparedStatement.setLong(3, publishedPlid);
            preparedStatement.executeUpdate();
        }
    }

    private void _updateSegmentsExperiments(long defaultSegmentsExperienceId, long draftPlid, long publishedPlid) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update SegmentsExperiment set segmentsExperienceId = ? where segmentsExperienceId = 0 and (plid = ? or plid = ?)");){
            preparedStatement.setLong(1, defaultSegmentsExperienceId);
            preparedStatement.setLong(2, draftPlid);
            preparedStatement.setLong(3, publishedPlid);
            preparedStatement.executeUpdate();
        }
    }
}

