/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.layout.page.template.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntryModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the LayoutPageTemplateEntry service. Represents a row in the &quot;LayoutPageTemplateEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>LayoutPageTemplateEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutPageTemplateEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutPageTemplateEntryImpl
 * @generated
 */
@JSON(strict = true)
public class LayoutPageTemplateEntryModelImpl
	extends BaseModelImpl<LayoutPageTemplateEntry>
	implements LayoutPageTemplateEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout page template entry model instance should use the <code>LayoutPageTemplateEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "LayoutPageTemplateEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"layoutPageTemplateEntryId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"layoutPageTemplateCollectionId", Types.BIGINT},
		{"layoutPageTemplateEntryKey", Types.VARCHAR},
		{"classNameId", Types.BIGINT}, {"classTypeId", Types.BIGINT},
		{"name", Types.VARCHAR}, {"type_", Types.INTEGER},
		{"previewFileEntryId", Types.BIGINT},
		{"defaultTemplate", Types.BOOLEAN}, {"layoutPrototypeId", Types.BIGINT},
		{"plid", Types.BIGINT}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("layoutPageTemplateEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("layoutPageTemplateCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("layoutPageTemplateEntryKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("previewFileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("defaultTemplate", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("layoutPrototypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("plid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table LayoutPageTemplateEntry (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,layoutPageTemplateEntryId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,layoutPageTemplateCollectionId LONG,layoutPageTemplateEntryKey VARCHAR(75) null,classNameId LONG,classTypeId LONG,name VARCHAR(75) null,type_ INTEGER,previewFileEntryId LONG,defaultTemplate BOOLEAN,layoutPrototypeId LONG,plid LONG,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (layoutPageTemplateEntryId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table LayoutPageTemplateEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY layoutPageTemplateEntry.name ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY LayoutPageTemplateEntry.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSTYPEID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DEFAULTTEMPLATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTPAGETEMPLATECOLLECTIONID_COLUMN_BITMASK =
		32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTPAGETEMPLATEENTRYKEY_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTPROTOTYPEID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PLID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4096L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public LayoutPageTemplateEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _layoutPageTemplateEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setLayoutPageTemplateEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _layoutPageTemplateEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return LayoutPageTemplateEntry.class;
	}

	@Override
	public String getModelClassName() {
		return LayoutPageTemplateEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<LayoutPageTemplateEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<LayoutPageTemplateEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutPageTemplateEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((LayoutPageTemplateEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<LayoutPageTemplateEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<LayoutPageTemplateEntry, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(LayoutPageTemplateEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<LayoutPageTemplateEntry, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<LayoutPageTemplateEntry, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<LayoutPageTemplateEntry, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<LayoutPageTemplateEntry, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<LayoutPageTemplateEntry, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", LayoutPageTemplateEntry::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", LayoutPageTemplateEntry::getCtCollectionId);
			attributeGetterFunctions.put(
				"uuid", LayoutPageTemplateEntry::getUuid);
			attributeGetterFunctions.put(
				"layoutPageTemplateEntryId",
				LayoutPageTemplateEntry::getLayoutPageTemplateEntryId);
			attributeGetterFunctions.put(
				"groupId", LayoutPageTemplateEntry::getGroupId);
			attributeGetterFunctions.put(
				"companyId", LayoutPageTemplateEntry::getCompanyId);
			attributeGetterFunctions.put(
				"userId", LayoutPageTemplateEntry::getUserId);
			attributeGetterFunctions.put(
				"userName", LayoutPageTemplateEntry::getUserName);
			attributeGetterFunctions.put(
				"createDate", LayoutPageTemplateEntry::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", LayoutPageTemplateEntry::getModifiedDate);
			attributeGetterFunctions.put(
				"layoutPageTemplateCollectionId",
				LayoutPageTemplateEntry::getLayoutPageTemplateCollectionId);
			attributeGetterFunctions.put(
				"layoutPageTemplateEntryKey",
				LayoutPageTemplateEntry::getLayoutPageTemplateEntryKey);
			attributeGetterFunctions.put(
				"classNameId", LayoutPageTemplateEntry::getClassNameId);
			attributeGetterFunctions.put(
				"classTypeId", LayoutPageTemplateEntry::getClassTypeId);
			attributeGetterFunctions.put(
				"name", LayoutPageTemplateEntry::getName);
			attributeGetterFunctions.put(
				"type", LayoutPageTemplateEntry::getType);
			attributeGetterFunctions.put(
				"previewFileEntryId",
				LayoutPageTemplateEntry::getPreviewFileEntryId);
			attributeGetterFunctions.put(
				"defaultTemplate", LayoutPageTemplateEntry::getDefaultTemplate);
			attributeGetterFunctions.put(
				"layoutPrototypeId",
				LayoutPageTemplateEntry::getLayoutPrototypeId);
			attributeGetterFunctions.put(
				"plid", LayoutPageTemplateEntry::getPlid);
			attributeGetterFunctions.put(
				"lastPublishDate", LayoutPageTemplateEntry::getLastPublishDate);
			attributeGetterFunctions.put(
				"status", LayoutPageTemplateEntry::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId", LayoutPageTemplateEntry::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusByUserName",
				LayoutPageTemplateEntry::getStatusByUserName);
			attributeGetterFunctions.put(
				"statusDate", LayoutPageTemplateEntry::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<LayoutPageTemplateEntry, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<LayoutPageTemplateEntry, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<LayoutPageTemplateEntry, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<LayoutPageTemplateEntry, String>)
					LayoutPageTemplateEntry::setUuid);
			attributeSetterBiConsumers.put(
				"layoutPageTemplateEntryId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setLayoutPageTemplateEntryId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<LayoutPageTemplateEntry, String>)
					LayoutPageTemplateEntry::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<LayoutPageTemplateEntry, Date>)
					LayoutPageTemplateEntry::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<LayoutPageTemplateEntry, Date>)
					LayoutPageTemplateEntry::setModifiedDate);
			attributeSetterBiConsumers.put(
				"layoutPageTemplateCollectionId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setLayoutPageTemplateCollectionId);
			attributeSetterBiConsumers.put(
				"layoutPageTemplateEntryKey",
				(BiConsumer<LayoutPageTemplateEntry, String>)
					LayoutPageTemplateEntry::setLayoutPageTemplateEntryKey);
			attributeSetterBiConsumers.put(
				"classNameId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setClassNameId);
			attributeSetterBiConsumers.put(
				"classTypeId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setClassTypeId);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<LayoutPageTemplateEntry, String>)
					LayoutPageTemplateEntry::setName);
			attributeSetterBiConsumers.put(
				"type",
				(BiConsumer<LayoutPageTemplateEntry, Integer>)
					LayoutPageTemplateEntry::setType);
			attributeSetterBiConsumers.put(
				"previewFileEntryId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setPreviewFileEntryId);
			attributeSetterBiConsumers.put(
				"defaultTemplate",
				(BiConsumer<LayoutPageTemplateEntry, Boolean>)
					LayoutPageTemplateEntry::setDefaultTemplate);
			attributeSetterBiConsumers.put(
				"layoutPrototypeId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setLayoutPrototypeId);
			attributeSetterBiConsumers.put(
				"plid",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setPlid);
			attributeSetterBiConsumers.put(
				"lastPublishDate",
				(BiConsumer<LayoutPageTemplateEntry, Date>)
					LayoutPageTemplateEntry::setLastPublishDate);
			attributeSetterBiConsumers.put(
				"status",
				(BiConsumer<LayoutPageTemplateEntry, Integer>)
					LayoutPageTemplateEntry::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<LayoutPageTemplateEntry, Long>)
					LayoutPageTemplateEntry::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusByUserName",
				(BiConsumer<LayoutPageTemplateEntry, String>)
					LayoutPageTemplateEntry::setStatusByUserName);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<LayoutPageTemplateEntry, Date>)
					LayoutPageTemplateEntry::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getLayoutPageTemplateEntryId() {
		return _layoutPageTemplateEntryId;
	}

	@Override
	public void setLayoutPageTemplateEntryId(long layoutPageTemplateEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutPageTemplateEntryId = layoutPageTemplateEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getLayoutPageTemplateCollectionId() {
		return _layoutPageTemplateCollectionId;
	}

	@Override
	public void setLayoutPageTemplateCollectionId(
		long layoutPageTemplateCollectionId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutPageTemplateCollectionId = layoutPageTemplateCollectionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLayoutPageTemplateCollectionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue(
				"layoutPageTemplateCollectionId"));
	}

	@JSON
	@Override
	public String getLayoutPageTemplateEntryKey() {
		if (_layoutPageTemplateEntryKey == null) {
			return "";
		}
		else {
			return _layoutPageTemplateEntryKey;
		}
	}

	@Override
	public void setLayoutPageTemplateEntryKey(
		String layoutPageTemplateEntryKey) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutPageTemplateEntryKey = layoutPageTemplateEntryKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalLayoutPageTemplateEntryKey() {
		return getColumnOriginalValue("layoutPageTemplateEntryKey");
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassTypeId() {
		return _classTypeId;
	}

	@Override
	public void setClassTypeId(long classTypeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classTypeId = classTypeId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassTypeId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classTypeId"));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalType() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("type_"));
	}

	@JSON
	@Override
	public long getPreviewFileEntryId() {
		return _previewFileEntryId;
	}

	@Override
	public void setPreviewFileEntryId(long previewFileEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_previewFileEntryId = previewFileEntryId;
	}

	@JSON
	@Override
	public boolean getDefaultTemplate() {
		return _defaultTemplate;
	}

	@JSON
	@Override
	public boolean isDefaultTemplate() {
		return _defaultTemplate;
	}

	@Override
	public void setDefaultTemplate(boolean defaultTemplate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultTemplate = defaultTemplate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalDefaultTemplate() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("defaultTemplate"));
	}

	@JSON
	@Override
	public long getLayoutPrototypeId() {
		return _layoutPrototypeId;
	}

	@Override
	public void setLayoutPrototypeId(long layoutPrototypeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutPrototypeId = layoutPrototypeId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLayoutPrototypeId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("layoutPrototypeId"));
	}

	@JSON
	@Override
	public long getPlid() {
		return _plid;
	}

	@Override
	public void setPlid(long plid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_plid = plid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalPlid() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("plid"));
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(LayoutPageTemplateEntry.class.getName()),
			getClassNameId());
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), LayoutPageTemplateEntry.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public LayoutPageTemplateEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, LayoutPageTemplateEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		LayoutPageTemplateEntryImpl layoutPageTemplateEntryImpl =
			new LayoutPageTemplateEntryImpl();

		layoutPageTemplateEntryImpl.setMvccVersion(getMvccVersion());
		layoutPageTemplateEntryImpl.setCtCollectionId(getCtCollectionId());
		layoutPageTemplateEntryImpl.setUuid(getUuid());
		layoutPageTemplateEntryImpl.setLayoutPageTemplateEntryId(
			getLayoutPageTemplateEntryId());
		layoutPageTemplateEntryImpl.setGroupId(getGroupId());
		layoutPageTemplateEntryImpl.setCompanyId(getCompanyId());
		layoutPageTemplateEntryImpl.setUserId(getUserId());
		layoutPageTemplateEntryImpl.setUserName(getUserName());
		layoutPageTemplateEntryImpl.setCreateDate(getCreateDate());
		layoutPageTemplateEntryImpl.setModifiedDate(getModifiedDate());
		layoutPageTemplateEntryImpl.setLayoutPageTemplateCollectionId(
			getLayoutPageTemplateCollectionId());
		layoutPageTemplateEntryImpl.setLayoutPageTemplateEntryKey(
			getLayoutPageTemplateEntryKey());
		layoutPageTemplateEntryImpl.setClassNameId(getClassNameId());
		layoutPageTemplateEntryImpl.setClassTypeId(getClassTypeId());
		layoutPageTemplateEntryImpl.setName(getName());
		layoutPageTemplateEntryImpl.setType(getType());
		layoutPageTemplateEntryImpl.setPreviewFileEntryId(
			getPreviewFileEntryId());
		layoutPageTemplateEntryImpl.setDefaultTemplate(isDefaultTemplate());
		layoutPageTemplateEntryImpl.setLayoutPrototypeId(
			getLayoutPrototypeId());
		layoutPageTemplateEntryImpl.setPlid(getPlid());
		layoutPageTemplateEntryImpl.setLastPublishDate(getLastPublishDate());
		layoutPageTemplateEntryImpl.setStatus(getStatus());
		layoutPageTemplateEntryImpl.setStatusByUserId(getStatusByUserId());
		layoutPageTemplateEntryImpl.setStatusByUserName(getStatusByUserName());
		layoutPageTemplateEntryImpl.setStatusDate(getStatusDate());

		layoutPageTemplateEntryImpl.resetOriginalValues();

		return layoutPageTemplateEntryImpl;
	}

	@Override
	public LayoutPageTemplateEntry cloneWithOriginalValues() {
		LayoutPageTemplateEntryImpl layoutPageTemplateEntryImpl =
			new LayoutPageTemplateEntryImpl();

		layoutPageTemplateEntryImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		layoutPageTemplateEntryImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		layoutPageTemplateEntryImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		layoutPageTemplateEntryImpl.setLayoutPageTemplateEntryId(
			this.<Long>getColumnOriginalValue("layoutPageTemplateEntryId"));
		layoutPageTemplateEntryImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		layoutPageTemplateEntryImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		layoutPageTemplateEntryImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		layoutPageTemplateEntryImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		layoutPageTemplateEntryImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		layoutPageTemplateEntryImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		layoutPageTemplateEntryImpl.setLayoutPageTemplateCollectionId(
			this.<Long>getColumnOriginalValue(
				"layoutPageTemplateCollectionId"));
		layoutPageTemplateEntryImpl.setLayoutPageTemplateEntryKey(
			this.<String>getColumnOriginalValue("layoutPageTemplateEntryKey"));
		layoutPageTemplateEntryImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		layoutPageTemplateEntryImpl.setClassTypeId(
			this.<Long>getColumnOriginalValue("classTypeId"));
		layoutPageTemplateEntryImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		layoutPageTemplateEntryImpl.setType(
			this.<Integer>getColumnOriginalValue("type_"));
		layoutPageTemplateEntryImpl.setPreviewFileEntryId(
			this.<Long>getColumnOriginalValue("previewFileEntryId"));
		layoutPageTemplateEntryImpl.setDefaultTemplate(
			this.<Boolean>getColumnOriginalValue("defaultTemplate"));
		layoutPageTemplateEntryImpl.setLayoutPrototypeId(
			this.<Long>getColumnOriginalValue("layoutPrototypeId"));
		layoutPageTemplateEntryImpl.setPlid(
			this.<Long>getColumnOriginalValue("plid"));
		layoutPageTemplateEntryImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		layoutPageTemplateEntryImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		layoutPageTemplateEntryImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		layoutPageTemplateEntryImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		layoutPageTemplateEntryImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return layoutPageTemplateEntryImpl;
	}

	@Override
	public int compareTo(LayoutPageTemplateEntry layoutPageTemplateEntry) {
		int value = 0;

		value = getName().compareTo(layoutPageTemplateEntry.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof LayoutPageTemplateEntry)) {
			return false;
		}

		LayoutPageTemplateEntry layoutPageTemplateEntry =
			(LayoutPageTemplateEntry)object;

		long primaryKey = layoutPageTemplateEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<LayoutPageTemplateEntry> toCacheModel() {
		LayoutPageTemplateEntryCacheModel layoutPageTemplateEntryCacheModel =
			new LayoutPageTemplateEntryCacheModel();

		layoutPageTemplateEntryCacheModel.mvccVersion = getMvccVersion();

		layoutPageTemplateEntryCacheModel.ctCollectionId = getCtCollectionId();

		layoutPageTemplateEntryCacheModel.uuid = getUuid();

		String uuid = layoutPageTemplateEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			layoutPageTemplateEntryCacheModel.uuid = null;
		}

		layoutPageTemplateEntryCacheModel.layoutPageTemplateEntryId =
			getLayoutPageTemplateEntryId();

		layoutPageTemplateEntryCacheModel.groupId = getGroupId();

		layoutPageTemplateEntryCacheModel.companyId = getCompanyId();

		layoutPageTemplateEntryCacheModel.userId = getUserId();

		layoutPageTemplateEntryCacheModel.userName = getUserName();

		String userName = layoutPageTemplateEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			layoutPageTemplateEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			layoutPageTemplateEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			layoutPageTemplateEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			layoutPageTemplateEntryCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			layoutPageTemplateEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		layoutPageTemplateEntryCacheModel.layoutPageTemplateCollectionId =
			getLayoutPageTemplateCollectionId();

		layoutPageTemplateEntryCacheModel.layoutPageTemplateEntryKey =
			getLayoutPageTemplateEntryKey();

		String layoutPageTemplateEntryKey =
			layoutPageTemplateEntryCacheModel.layoutPageTemplateEntryKey;

		if ((layoutPageTemplateEntryKey != null) &&
			(layoutPageTemplateEntryKey.length() == 0)) {

			layoutPageTemplateEntryCacheModel.layoutPageTemplateEntryKey = null;
		}

		layoutPageTemplateEntryCacheModel.classNameId = getClassNameId();

		layoutPageTemplateEntryCacheModel.classTypeId = getClassTypeId();

		layoutPageTemplateEntryCacheModel.name = getName();

		String name = layoutPageTemplateEntryCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			layoutPageTemplateEntryCacheModel.name = null;
		}

		layoutPageTemplateEntryCacheModel.type = getType();

		layoutPageTemplateEntryCacheModel.previewFileEntryId =
			getPreviewFileEntryId();

		layoutPageTemplateEntryCacheModel.defaultTemplate = isDefaultTemplate();

		layoutPageTemplateEntryCacheModel.layoutPrototypeId =
			getLayoutPrototypeId();

		layoutPageTemplateEntryCacheModel.plid = getPlid();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			layoutPageTemplateEntryCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			layoutPageTemplateEntryCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		layoutPageTemplateEntryCacheModel.status = getStatus();

		layoutPageTemplateEntryCacheModel.statusByUserId = getStatusByUserId();

		layoutPageTemplateEntryCacheModel.statusByUserName =
			getStatusByUserName();

		String statusByUserName =
			layoutPageTemplateEntryCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			layoutPageTemplateEntryCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			layoutPageTemplateEntryCacheModel.statusDate = statusDate.getTime();
		}
		else {
			layoutPageTemplateEntryCacheModel.statusDate = Long.MIN_VALUE;
		}

		return layoutPageTemplateEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<LayoutPageTemplateEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<LayoutPageTemplateEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutPageTemplateEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(LayoutPageTemplateEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, LayoutPageTemplateEntry>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						LayoutPageTemplateEntry.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _layoutPageTemplateEntryId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _layoutPageTemplateCollectionId;
	private String _layoutPageTemplateEntryKey;
	private long _classNameId;
	private long _classTypeId;
	private String _name;
	private int _type;
	private long _previewFileEntryId;
	private boolean _defaultTemplate;
	private long _layoutPrototypeId;
	private long _plid;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<LayoutPageTemplateEntry, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((LayoutPageTemplateEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"layoutPageTemplateEntryId", _layoutPageTemplateEntryId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"layoutPageTemplateCollectionId", _layoutPageTemplateCollectionId);
		_columnOriginalValues.put(
			"layoutPageTemplateEntryKey", _layoutPageTemplateEntryKey);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classTypeId", _classTypeId);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("previewFileEntryId", _previewFileEntryId);
		_columnOriginalValues.put("defaultTemplate", _defaultTemplate);
		_columnOriginalValues.put("layoutPrototypeId", _layoutPrototypeId);
		_columnOriginalValues.put("plid", _plid);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("layoutPageTemplateEntryId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("layoutPageTemplateCollectionId", 1024L);

		columnBitmasks.put("layoutPageTemplateEntryKey", 2048L);

		columnBitmasks.put("classNameId", 4096L);

		columnBitmasks.put("classTypeId", 8192L);

		columnBitmasks.put("name", 16384L);

		columnBitmasks.put("type_", 32768L);

		columnBitmasks.put("previewFileEntryId", 65536L);

		columnBitmasks.put("defaultTemplate", 131072L);

		columnBitmasks.put("layoutPrototypeId", 262144L);

		columnBitmasks.put("plid", 524288L);

		columnBitmasks.put("lastPublishDate", 1048576L);

		columnBitmasks.put("status", 2097152L);

		columnBitmasks.put("statusByUserId", 4194304L);

		columnBitmasks.put("statusByUserName", 8388608L);

		columnBitmasks.put("statusDate", 16777216L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private LayoutPageTemplateEntry _escapedModel;

}