/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.model.listener;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.layout.helper.LayoutCopyHelper;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class LayoutModelListener
extends BaseModelListener<Layout> {
    private static final Log _log = LogFactoryUtil.getLog(LayoutModelListener.class);
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public void onAfterCreate(Layout layout) throws ModelListenerException {
        if (!layout.isTypeContent() && !layout.isTypeAssetDisplay()) {
            return;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        try {
            SegmentsExperience segmentsExperience = this._addDefaultSegmentsExperience(layout, serviceContext);
            this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(layout.getUserId(), layout.getGroupId(), layout.getPlid(), segmentsExperience.getSegmentsExperienceId(), this._generateContentLayoutStructure(), serviceContext);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
        if (!layout.isTypeContent()) {
            return;
        }
        this._reindexLayout(layout);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._getLayoutPageTemplateEntry(layout);
        if (ExportImportThreadLocal.isImportInProcess() || ExportImportThreadLocal.isStagingInProcess() || layoutPageTemplateEntry == null) {
            return;
        }
        TransactionCommitCallbackUtil.registerCallback(() -> this._copyStructure(layoutPageTemplateEntry, layout));
    }

    public void onAfterUpdate(Layout originalLayout, Layout layout) throws ModelListenerException {
        if (!layout.isTypeContent()) {
            return;
        }
        this._reindexLayout(layout);
    }

    public void onBeforeRemove(Layout layout) throws ModelListenerException {
        if (!layout.isTypeAssetDisplay() && !layout.isTypeContent()) {
            return;
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        if (layoutPageTemplateStructure != null) {
            this._layoutPageTemplateStructureLocalService.deleteLayoutPageTemplateStructure(layoutPageTemplateStructure);
        }
        try {
            this._segmentsExperienceLocalService.deleteSegmentsExperiences(layout.getGroupId(), layout.getPlid());
            if (!layout.isTypeContent()) {
                return;
            }
            Indexer indexer = IndexerRegistryUtil.getIndexer(Layout.class);
            indexer.delete((Object)layout);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private SegmentsExperience _addDefaultSegmentsExperience(Layout layout, ServiceContext serviceContext) throws PortalException {
        SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(layout.getGroupId(), "DEFAULT", layout.getPlid());
        if (segmentsExperience != null) {
            return segmentsExperience;
        }
        return this._segmentsExperienceLocalService.addDefaultSegmentsExperience(layout.getUserId(), layout.getPlid(), serviceContext);
    }

    private void _copySiteNavigationMenuId(Layout layout, UnicodeProperties unicodeProperties) {
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        if (typeSettingsUnicodeProperties.containsKey((Object)"siteNavigationMenuId")) {
            String siteNavigationMenuId = typeSettingsUnicodeProperties.getProperty("siteNavigationMenuId");
            unicodeProperties.put("siteNavigationMenuId", siteNavigationMenuId);
        }
        if (typeSettingsUnicodeProperties.containsKey((Object)"siteNavigationMenuName")) {
            String siteNavigationMenuName = typeSettingsUnicodeProperties.getProperty("siteNavigationMenuName");
            unicodeProperties.put("siteNavigationMenuName", siteNavigationMenuName);
        }
    }

    private Void _copyStructure(LayoutPageTemplateEntry layoutPageTemplateEntry, Layout layout) throws Exception {
        Layout draftLayout = layout.fetchDraftLayout();
        Layout layoutPageTemplateEntryLayout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layoutPageTemplateEntryLayout.getGroupId(), layoutPageTemplateEntryLayout.getPlid());
        draftLayout = this._layoutCopyHelper.copyLayoutContent(layoutPageTemplateEntryLayout, draftLayout);
        draftLayout.setStatus(0);
        UnicodeProperties unicodeProperties = draftLayout.getTypeSettingsProperties();
        unicodeProperties.put("published", Boolean.FALSE.toString());
        this._copySiteNavigationMenuId(layout, unicodeProperties);
        this._layoutLocalService.updateLayout(draftLayout);
        this._layoutCopyHelper.copyLayoutContent(layoutPageTemplateEntryLayout, layout);
        return null;
    }

    private String _generateContentLayoutStructure() {
        LayoutStructure layoutStructure = new LayoutStructure();
        LayoutStructureItem rootLayoutStructureItem = layoutStructure.addRootLayoutStructureItem();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        int layoutPageTemplateEntryType = GetterUtil.getInteger((Object)serviceContext.getAttribute("layout.page.template.entry.type"), (int)0);
        if (!Objects.equals(layoutPageTemplateEntryType, 3)) {
            return layoutStructure.toString();
        }
        layoutStructure.addDropZoneLayoutStructureItem(rootLayoutStructureItem.getItemId(), 0);
        return layoutStructure.toString();
    }

    private LayoutPageTemplateEntry _getLayoutPageTemplateEntry(Layout layout) {
        long classNameId = this._portal.getClassNameId(LayoutPageTemplateEntry.class);
        if (layout.getClassNameId() != classNameId) {
            return null;
        }
        return this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layout.getClassPK());
    }

    private void _reindexLayout(Layout layout) {
        Indexer indexer = IndexerRegistryUtil.getIndexer(Layout.class);
        if (indexer == null || !layout.isApproved() || layout.isSystem()) {
            return;
        }
        try {
            indexer.reindex((Object)layout);
        }
        catch (SearchException searchException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to reindex layout " + layout.getPlid()), (Throwable)searchException);
            }
            throw new ModelListenerException((Throwable)searchException);
        }
    }
}

