/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.service;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceWrapper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class LayoutPageTemplateLayoutPrototypeLocalServiceWrapper
extends LayoutPrototypeLocalServiceWrapper {
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private Localization _localization;

    public LayoutPrototype addLayoutPrototype(long userId, long companyId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, ServiceContext serviceContext) throws PortalException {
        LayoutPrototype layoutPrototype = super.addLayoutPrototype(userId, companyId, nameMap, descriptionMap, active, serviceContext);
        if (ExportImportThreadLocal.isStagingInProcess() || ExportImportThreadLocal.isImportInProcess()) {
            return layoutPrototype;
        }
        long layoutPageTemplateEntryId = GetterUtil.getLong((Object)serviceContext.getAttribute("layoutPageTemplateEntryId"));
        LayoutPageTemplateEntry layoutPageTemplateEntry = null;
        layoutPageTemplateEntry = layoutPageTemplateEntryId != 0L ? this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId) : this._layoutPageTemplateEntryLocalService.fetchFirstLayoutPageTemplateEntry(layoutPrototype.getLayoutPrototypeId());
        if (layoutPageTemplateEntry != null) {
            return layoutPrototype;
        }
        this._layoutPageTemplateEntryLocalService.addLayoutPageTemplateEntry(layoutPrototype);
        return layoutPrototype;
    }

    public LayoutPrototype deleteLayoutPrototype(long layoutPrototypeId) throws PortalException {
        LayoutPrototype layoutPrototype = super.deleteLayoutPrototype(layoutPrototypeId);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchFirstLayoutPageTemplateEntry(layoutPrototype.getLayoutPrototypeId());
        if (layoutPageTemplateEntry != null) {
            this._layoutPageTemplateEntryLocalService.deleteLayoutPageTemplateEntry(layoutPageTemplateEntry);
        }
        return layoutPrototype;
    }

    public LayoutPrototype updateLayoutPrototype(long layoutPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, ServiceContext serviceContext) throws PortalException {
        LayoutPrototype layoutPrototype = super.updateLayoutPrototype(layoutPrototypeId, nameMap, descriptionMap, active, serviceContext);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchFirstLayoutPageTemplateEntry(layoutPrototype.getLayoutPrototypeId());
        if (layoutPageTemplateEntry == null) {
            return layoutPrototype;
        }
        long userId = serviceContext.getUserId();
        if (userId == 0L) {
            userId = layoutPageTemplateEntry.getUserId();
        }
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)this._localization.getDefaultLanguageId(layoutPrototype.getName()));
        int status = 5;
        if (layoutPrototype.isActive()) {
            status = 0;
        }
        this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(userId, layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), nameMap.get(defaultLocale), status);
        return layoutPrototype;
    }
}

