/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.instance.lifecycle;

import com.liferay.fragment.contributor.FragmentCollectionContributorRegistration;
import com.liferay.layout.internal.importer.DefaultLayoutDefinitionImporter;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class AddDefaultLayoutPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private DefaultLayoutDefinitionImporter _defaultLayoutDefinitionImporter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        Group group = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
        String friendlyURL = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_FRIENDLY_URL);
        Layout defaultLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), false, friendlyURL);
        if (defaultLayout == null && (defaultLayout = this._layoutLocalService.fetchFirstLayout(group.getGroupId(), false, 0L, false)) == null) {
            this.addDefaultGuestPublicLayoutByProperties(group);
        }
    }

    protected void addDefaultGuestPublicLayoutByProperties(Group group) throws PortalException {
        User user = this._getUser(group.getCompanyId());
        String friendlyURL = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = this._layoutLocalService.addLayout(user.getUserId(), group.getGroupId(), false, 0L, PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_NAME, "", "", "content", false, friendlyURL, serviceContext);
        Layout draftLayout = layout.fetchDraftLayout();
        String currentName = PrincipalThreadLocal.getName();
        ServiceContext currentServiceContext = ServiceContextThreadLocal.popServiceContext();
        PrincipalThreadLocal.setName((String)String.valueOf(layout.getUserId()));
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            this._defaultLayoutDefinitionImporter.importDefaultLayoutDefinition(draftLayout, serviceContext);
            layout = this._layoutCopyHelper.copyLayout(draftLayout, layout);
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_TEMPLATE_ID, false);
            LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
            for (String columnId : layoutTemplate.getColumns()) {
                String keyPrefix = "default.guest.public.layout.";
                String portletIds = PropsUtil.get((String)keyPrefix.concat(columnId));
                layoutTypePortlet.addPortletIds(0L, StringUtil.split((String)portletIds), columnId, false);
            }
            this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
            this._layoutLocalService.updatePriority(layout.getPlid(), 0);
            this._layoutLocalService.updateStatus(layout.getUserId(), layout.getPlid(), 0, serviceContext);
            this._layoutLocalService.updateStatus(layout.getUserId(), draftLayout.getPlid(), 0, serviceContext);
            boolean updateLayoutSet = false;
            LayoutSet layoutSet = layout.getLayoutSet();
            if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_THEME_ID)) {
                layoutSet.setThemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_THEME_ID);
                updateLayoutSet = true;
            }
            if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
                layoutSet.setColorSchemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID);
                updateLayoutSet = true;
            }
            if (updateLayoutSet) {
                this._layoutSetLocalService.updateLayoutSet(layoutSet);
            }
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        finally {
            PrincipalThreadLocal.setName((String)currentName);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)currentServiceContext);
        }
    }

    @Reference(target="(fragment.collection.key=BASIC_COMPONENT)", unbind="-")
    protected void setFragmentCollectionContributorRegistration(FragmentCollectionContributorRegistration fragmentCollectionContributorRegistration) {
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private User _getUser(long companyId) throws PortalException {
        Role role = this._roleLocalService.fetchRole(companyId, "Administrator");
        if (role == null) {
            return this._userLocalService.getDefaultUser(companyId);
        }
        List adminUsers = this._userLocalService.getRoleUsers(role.getRoleId(), 0, 1);
        if (adminUsers.isEmpty()) {
            return this._userLocalService.getDefaultUser(companyId);
        }
        return (User)adminUsers.get(0);
    }
}

