/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class LayoutUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select plid, typeSettings from Layout where classNameId = ? and classPK > 0 and type_ = ? and system_ = ?");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Layout set status = ? where plid = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId(Layout.class));
            preparedStatement1.setString(2, "content");
            preparedStatement1.setBoolean(3, true);
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long plid = resultSet.getLong("plid");
                    String typeSettings = resultSet.getString("typeSettings");
                    UnicodeProperties unicodeProperties = new UnicodeProperties();
                    unicodeProperties.load(typeSettings);
                    boolean published = GetterUtil.getBoolean((String)unicodeProperties.getProperty("published"));
                    if (published) {
                        preparedStatement2.setInt(1, 0);
                    } else {
                        preparedStatement2.setInt(1, 2);
                    }
                    preparedStatement2.setLong(2, plid);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }
}

