/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.utility.page.service.impl;

import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.layout.utility.page.exception.LayoutUtilityPageEntryNameException;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.base.LayoutUtilityPageEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.utility.page.model.LayoutUtilityPageEntry"}, service={AopService.class})
public class LayoutUtilityPageEntryLocalServiceImpl
extends LayoutUtilityPageEntryLocalServiceBaseImpl {
    private static final char[] _BLACKLIST_CHAR = new char[]{';', '/', '?', ':', '@', '=', '&', '\"', '<', '>', '#', '%', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private File _file;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public LayoutUtilityPageEntry addLayoutUtilityPageEntry(String externalReferenceCode, long userId, long groupId, long plid, long previewFileEntryId, boolean defaultLayoutUtilityPageEntry, String name, String type, long masterLayoutPlid, ServiceContext serviceContext) throws PortalException {
        Layout layout;
        this._validateName(groupId, 0L, name, type);
        LayoutUtilityPageEntry layoutUtilityPageEntry = this.layoutUtilityPageEntryPersistence.create(this.counterLocalService.increment());
        layoutUtilityPageEntry.setUuid(serviceContext.getUuid());
        if (Validator.isNotNull((String)externalReferenceCode)) {
            layoutUtilityPageEntry.setExternalReferenceCode(externalReferenceCode);
        } else {
            layoutUtilityPageEntry.setExternalReferenceCode(this._getExternalReferenceCode(groupId, name));
        }
        layoutUtilityPageEntry.setGroupId(groupId);
        User user = this._userLocalService.getUser(userId);
        layoutUtilityPageEntry.setCompanyId(user.getCompanyId());
        layoutUtilityPageEntry.setUserId(user.getUserId());
        layoutUtilityPageEntry.setUserName(user.getFullName());
        if (plid == 0L && (layout = this._addLayout(userId, groupId, name, masterLayoutPlid, serviceContext)) != null) {
            plid = layout.getPlid();
        }
        layoutUtilityPageEntry.setPlid(plid);
        layoutUtilityPageEntry.setPreviewFileEntryId(previewFileEntryId);
        layoutUtilityPageEntry.setName(name);
        layoutUtilityPageEntry.setType(type);
        layoutUtilityPageEntry = (LayoutUtilityPageEntry)this.layoutUtilityPageEntryPersistence.update((BaseModel)layoutUtilityPageEntry);
        if (defaultLayoutUtilityPageEntry) {
            layoutUtilityPageEntry = this.setDefaultLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId());
        }
        this._resourceLocalService.addResources(layoutUtilityPageEntry.getCompanyId(), layoutUtilityPageEntry.getGroupId(), layoutUtilityPageEntry.getUserId(), LayoutUtilityPageEntry.class.getName(), layoutUtilityPageEntry.getLayoutUtilityPageEntryId(), false, true, true);
        return layoutUtilityPageEntry;
    }

    public LayoutUtilityPageEntry copyLayoutUtilityPageEntry(long userId, long groupId, long sourceLayoutUtilityPageEntryId, ServiceContext serviceContext) throws Exception {
        LayoutUtilityPageEntry targetLayoutUtilityPageEntry;
        long previewFileEntryId;
        LayoutUtilityPageEntry sourceLayoutUtilityPageEntry = this.layoutUtilityPageEntryPersistence.findByPrimaryKey(sourceLayoutUtilityPageEntryId);
        String name = this._getUniqueCopyName(groupId, sourceLayoutUtilityPageEntry.getName(), sourceLayoutUtilityPageEntry.getType(), serviceContext.getLocale());
        long masterLayoutPlid = 0L;
        Layout layout = this._layoutLocalService.fetchLayout(sourceLayoutUtilityPageEntry.getPlid());
        if (layout != null) {
            masterLayoutPlid = layout.getMasterLayoutPlid();
        }
        if ((previewFileEntryId = this._copyPreviewFileEntryId((targetLayoutUtilityPageEntry = this.addLayoutUtilityPageEntry(null, userId, serviceContext.getScopeGroupId(), 0L, 0L, false, name, sourceLayoutUtilityPageEntry.getType(), masterLayoutPlid, serviceContext)).getLayoutUtilityPageEntryId(), sourceLayoutUtilityPageEntry.getPreviewFileEntryId(), serviceContext)) > 0L) {
            return this.layoutUtilityPageEntryLocalService.updateLayoutUtilityPageEntry(targetLayoutUtilityPageEntry.getLayoutUtilityPageEntryId(), previewFileEntryId);
        }
        return targetLayoutUtilityPageEntry;
    }

    @Override
    @SystemEvent(type=1)
    public LayoutUtilityPageEntry deleteLayoutUtilityPageEntry(LayoutUtilityPageEntry layoutUtilityPageEntry) throws PortalException {
        this.layoutUtilityPageEntryPersistence.remove((BaseModel)layoutUtilityPageEntry);
        this._resourceLocalService.deleteResource(layoutUtilityPageEntry.getCompanyId(), LayoutUtilityPageEntry.class.getName(), 4, layoutUtilityPageEntry.getLayoutUtilityPageEntryId());
        Layout layout = this._layoutLocalService.fetchLayout(layoutUtilityPageEntry.getPlid());
        LayoutSet layoutSet = this._layoutSetLocalService.fetchLayoutSet(layoutUtilityPageEntry.getGroupId(), false);
        if (layout != null && layoutSet != null) {
            this._layoutLocalService.deleteLayout(layout);
        }
        if (layoutUtilityPageEntry.getPreviewFileEntryId() > 0L) {
            this._portletFileRepository.deletePortletFileEntry(layoutUtilityPageEntry.getPreviewFileEntryId());
        }
        return layoutUtilityPageEntry;
    }

    @Override
    public LayoutUtilityPageEntry deleteLayoutUtilityPageEntry(long layoutUtilityPageEntryId) throws PortalException {
        LayoutUtilityPageEntry layoutUtilityPageEntry = this.layoutUtilityPageEntryLocalService.fetchLayoutUtilityPageEntry(layoutUtilityPageEntryId);
        return this.layoutUtilityPageEntryLocalService.deleteLayoutUtilityPageEntry(layoutUtilityPageEntry);
    }

    public LayoutUtilityPageEntry fetchDefaultLayoutUtilityPageEntry(long groupId, String type) {
        return this.layoutUtilityPageEntryPersistence.fetchByG_D_T_First(groupId, true, type, null);
    }

    public LayoutUtilityPageEntry fetchLayoutUtilityPageEntry(long groupId, String name, String type) {
        return this.layoutUtilityPageEntryPersistence.fetchByG_N_T(groupId, name, type);
    }

    public LayoutUtilityPageEntry fetchLayoutUtilityPageEntryByPlid(long plid) {
        return this.layoutUtilityPageEntryPersistence.fetchByPlid(plid);
    }

    public LayoutUtilityPageEntry getDefaultLayoutUtilityPageEntry(long groupId, String type) throws PortalException {
        return this.layoutUtilityPageEntryPersistence.findByG_D_T_First(groupId, true, type, null);
    }

    public List<LayoutUtilityPageEntry> getLayoutUtilityPageEntries(long groupId) {
        return this.layoutUtilityPageEntryPersistence.findByGroupId(groupId);
    }

    public List<LayoutUtilityPageEntry> getLayoutUtilityPageEntries(long groupId, int start, int end, OrderByComparator<LayoutUtilityPageEntry> orderByComparator) {
        return this.layoutUtilityPageEntryPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<LayoutUtilityPageEntry> getLayoutUtilityPageEntries(long groupId, String type, int start, int end, OrderByComparator<LayoutUtilityPageEntry> orderByComparator) {
        return this.layoutUtilityPageEntryPersistence.findByG_T(groupId, type, start, end, orderByComparator);
    }

    public int getLayoutUtilityPageEntriesCount(long groupId) {
        return this.layoutUtilityPageEntryPersistence.countByGroupId(groupId);
    }

    public LayoutUtilityPageEntry setDefaultLayoutUtilityPageEntry(long layoutUtilityPageEntryId) throws PortalException {
        LayoutUtilityPageEntry layoutUtilityPageEntry = this.layoutUtilityPageEntryPersistence.findByPrimaryKey(layoutUtilityPageEntryId);
        LayoutUtilityPageEntry defaultLayoutUtilityPageEntry = this.layoutUtilityPageEntryPersistence.fetchByG_D_T_First(layoutUtilityPageEntry.getGroupId(), true, layoutUtilityPageEntry.getType(), null);
        if (defaultLayoutUtilityPageEntry != null) {
            defaultLayoutUtilityPageEntry.setDefaultLayoutUtilityPageEntry(false);
            this.layoutUtilityPageEntryPersistence.update((BaseModel)defaultLayoutUtilityPageEntry);
        }
        layoutUtilityPageEntry.setDefaultLayoutUtilityPageEntry(true);
        return (LayoutUtilityPageEntry)this.layoutUtilityPageEntryPersistence.update((BaseModel)layoutUtilityPageEntry);
    }

    public LayoutUtilityPageEntry updateLayoutUtilityPageEntry(long layoutUtilityPageEntryId, long previewFileEntryId) {
        LayoutUtilityPageEntry layoutUtilityPageEntry = this.layoutUtilityPageEntryPersistence.fetchByPrimaryKey(layoutUtilityPageEntryId);
        layoutUtilityPageEntry.setModifiedDate(new Date());
        layoutUtilityPageEntry.setPreviewFileEntryId(previewFileEntryId);
        return (LayoutUtilityPageEntry)this.layoutUtilityPageEntryPersistence.update((BaseModel)layoutUtilityPageEntry);
    }

    public LayoutUtilityPageEntry updateLayoutUtilityPageEntry(long layoutUtilityPageEntryId, String name) throws PortalException {
        LayoutUtilityPageEntry layoutUtilityPageEntry = this.layoutUtilityPageEntryPersistence.fetchByPrimaryKey(layoutUtilityPageEntryId);
        this._validateName(layoutUtilityPageEntry.getGroupId(), layoutUtilityPageEntryId, name, layoutUtilityPageEntry.getType());
        layoutUtilityPageEntry.setName(name);
        layoutUtilityPageEntry = (LayoutUtilityPageEntry)this.layoutUtilityPageEntryPersistence.update((BaseModel)layoutUtilityPageEntry);
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), name);
        Layout draftLayout = this._layoutLocalService.fetchDraftLayout(layoutUtilityPageEntry.getPlid());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        this._layoutLocalService.updateLayout(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), draftLayout.getParentLayoutId(), titleMap, titleMap, draftLayout.getDescriptionMap(), draftLayout.getKeywordsMap(), draftLayout.getRobotsMap(), draftLayout.getType(), draftLayout.isHidden(), draftLayout.getFriendlyURLMap(), draftLayout.getIconImage(), null, draftLayout.getStyleBookEntryId(), draftLayout.getFaviconFileEntryId(), draftLayout.getMasterLayoutPlid(), serviceContext);
        Layout layout = this._layoutLocalService.getLayout(layoutUtilityPageEntry.getPlid());
        this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getParentLayoutId(), titleMap, titleMap, layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layout.getType(), layout.isHidden(), layout.getFriendlyURLMap(), layout.getIconImage(), null, layout.getStyleBookEntryId(), layout.getFaviconFileEntryId(), layout.getMasterLayoutPlid(), serviceContext);
        return layoutUtilityPageEntry;
    }

    private Layout _addLayout(long userId, long groupId, String name, long masterLayoutPlid, ServiceContext serviceContext) throws PortalException {
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), name);
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties();
        if (masterLayoutPlid > 0L) {
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-footer", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header-search", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:wrap-widget-page-content", Boolean.FALSE.toString());
        }
        String typeSettings = typeSettingsUnicodeProperties.toString();
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        Layout layout = this._layoutLocalService.addLayout(userId, groupId, true, 0L, 0L, 0L, titleMap, titleMap, null, null, null, "content", typeSettings, true, true, new HashMap(), masterLayoutPlid, serviceContext);
        Layout draftLayout = layout.fetchDraftLayout();
        if (masterLayoutPlid > 0L) {
            LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, false);
            String themeId = layoutSet.getThemeId();
            String colorSchemeId = this._getColorSchemeId(layout.getCompanyId(), themeId);
            this._layoutLocalService.updateLookAndFeel(groupId, true, draftLayout.getLayoutId(), themeId, colorSchemeId, "");
            layout = this._layoutLocalService.updateLookAndFeel(groupId, true, layout.getLayoutId(), themeId, colorSchemeId, "");
        }
        return this._layoutLocalService.updateStatus(userId, layout.getPlid(), 2, serviceContext);
    }

    private long _copyPreviewFileEntryId(long layoutUtilityPageEntryId, long previewFileEntryId, ServiceContext serviceContext) throws Exception {
        if (previewFileEntryId <= 0L) {
            return previewFileEntryId;
        }
        FileEntry portletFileEntry = this._portletFileRepository.getPortletFileEntry(previewFileEntryId);
        Folder folder = portletFileEntry.getFolder();
        String fileName = layoutUtilityPageEntryId + "_preview." + portletFileEntry.getExtension();
        FileEntry fileEntry = this._portletFileRepository.addPortletFileEntry(portletFileEntry.getGroupId(), serviceContext.getUserId(), LayoutUtilityPageEntry.class.getName(), layoutUtilityPageEntryId, "com_liferay_layout_admin_web_portlet_GroupPagesPortlet", folder.getFolderId(), this._file.getBytes(portletFileEntry.getContentStream()), fileName, portletFileEntry.getMimeType(), false);
        return fileEntry.getFileEntryId();
    }

    private String _getColorSchemeId(long companyId, String themeId) {
        ColorScheme colorScheme = this._themeLocalService.getColorScheme(companyId, themeId, "");
        return colorScheme.getColorSchemeId();
    }

    private String _getExternalReferenceCode(long groupId, String name) {
        String externalReferenceCode = StringUtil.toLowerCase((String)name.trim());
        externalReferenceCode = StringUtil.replace((String)externalReferenceCode, (char)' ', (char)'-');
        int count = 0;
        LayoutUtilityPageEntry layoutUtilityPageEntry;
        while ((layoutUtilityPageEntry = this.layoutUtilityPageEntryPersistence.fetchByERC_G(externalReferenceCode, groupId)) != null) {
            externalReferenceCode = externalReferenceCode + '-' + count++;
        }
        return externalReferenceCode;
    }

    private String _getUniqueCopyName(long groupId, String sourceName, String type, Locale locale) {
        LayoutUtilityPageEntry layoutUtilityPageEntry;
        String copy = this._language.get(locale, "copy");
        String name = StringUtil.appendParentheticalSuffix((String)sourceName, (String)copy);
        int i = 1;
        while ((layoutUtilityPageEntry = this.layoutUtilityPageEntryPersistence.fetchByG_N_T(groupId, name, type)) != null) {
            name = StringUtil.appendParentheticalSuffix((String)sourceName, (String)(copy + " " + i));
            ++i;
        }
        return name;
    }

    private void _validateName(long groupId, long layoutUtilityPageEntryId, String name, String type) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutUtilityPageEntryNameException.MustNotBeNull(groupId);
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)LayoutUtilityPageEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new LayoutUtilityPageEntryNameException.MustNotExceedMaximumSize(nameMaxLength);
        }
        for (char c : _BLACKLIST_CHAR) {
            if (name.indexOf(c) < 0) continue;
            throw new LayoutUtilityPageEntryNameException.MustNotContainInvalidCharacters(c);
        }
        LayoutUtilityPageEntry duplicatedLayoutUtilityPageEntry = this.layoutUtilityPageEntryPersistence.fetchByG_N_T(groupId, name, type);
        if (duplicatedLayoutUtilityPageEntry != null && duplicatedLayoutUtilityPageEntry.getLayoutUtilityPageEntryId() != layoutUtilityPageEntryId) {
            throw new LayoutUtilityPageEntryNameException.MustNotBeDuplicate(groupId, name);
        }
    }
}

