/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.authentication.internal.security.auth;

import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.AuthFailure;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=auth.max.failures"}, service={AuthFailure.class})
public class LoginMaxAuthFailure
implements AuthFailure {
    @Reference
    private UserLocalService _userLocalService;

    public void onFailureByEmailAddress(long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            this._userLocalService.updateLockoutByEmailAddress(companyId, emailAddress, true);
        }
        catch (Exception exception) {
            throw new AuthException((Throwable)exception);
        }
    }

    public void onFailureByScreenName(long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            this._userLocalService.updateLockoutByScreenName(companyId, screenName, true);
        }
        catch (Exception exception) {
            throw new AuthException((Throwable)exception);
        }
    }

    public void onFailureByUserId(long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            this._userLocalService.updateLockoutById(userId, true);
        }
        catch (Exception exception) {
            throw new AuthException((Throwable)exception);
        }
    }
}

