/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.outlook.auth.connector.provider.internal.token.provider;

import com.liferay.mail.kernel.auth.token.provider.MailAuthTokenProvider;
import com.liferay.mail.outlook.auth.connector.provider.internal.configuration.MailOutlookAuthConnectorCompanyConfiguration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"mail.server.name=outlook.office365.com", "mail.server.name=smtp.office365.com"}, service={MailAuthTokenProvider.class})
public class MailOutlookMailAuthTokenProvider
implements MailAuthTokenProvider {
    private static final Log _log = LogFactoryUtil.getLog(MailOutlookMailAuthTokenProvider.class);
    @Reference
    private ConfigurationProvider _configurationProvider;

    public String getAccessToken(long companyId) {
        try {
            MailOutlookAuthConnectorCompanyConfiguration mailOutlookAuthConnectorCompanyConfiguration = (MailOutlookAuthConnectorCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(MailOutlookAuthConnectorCompanyConfiguration.class, companyId);
            ConfidentialClientApplication confidentialClientApplication = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)mailOutlookAuthConnectorCompanyConfiguration.clientId(), (IClientCredential)ClientCredentialFactory.createFromSecret((String)mailOutlookAuthConnectorCompanyConfiguration.clientSecret())).authority(String.format("https://login.microsoftonline.com/%s/", mailOutlookAuthConnectorCompanyConfiguration.tenantId()))).build();
            ClientCredentialParameters clientCredentialParam = ClientCredentialParameters.builder(Collections.singleton("https://outlook.office365.com/.default")).build();
            CompletableFuture completableFuture = confidentialClientApplication.acquireToken(clientCredentialParam);
            IAuthenticationResult iAuthenticationResult = (IAuthenticationResult)completableFuture.get();
            return iAuthenticationResult.accessToken();
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to acquire access token", (Throwable)exception);
            return "";
        }
    }

    public boolean isProtocolSupported(long companyId, String protocol) {
        try {
            MailOutlookAuthConnectorCompanyConfiguration mailOutlookAuthConnectorCompanyConfiguration = (MailOutlookAuthConnectorCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(MailOutlookAuthConnectorCompanyConfiguration.class, companyId);
            if (Objects.equals("pop3s", protocol)) {
                return mailOutlookAuthConnectorCompanyConfiguration.pop3ConnectionEnabled();
            }
            if (Objects.equals("smtp", protocol)) {
                return mailOutlookAuthConnectorCompanyConfiguration.smtpConnectionEnabled();
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(protocol + " protocol is not supported for company ID " + companyId));
        }
        return false;
    }
}

