/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.template.internal;

import com.liferay.mail.kernel.template.MailTemplateContext;
import com.liferay.mail.kernel.template.MailTemplateContextBuilder;
import com.liferay.mail.template.internal.AggregateMailTemplateContext;
import com.liferay.portal.kernel.util.EscapableLocalizableFunction;
import com.liferay.portal.kernel.util.EscapableObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultMailTemplateContextBuilder
implements MailTemplateContextBuilder {
    private final Map<String, EscapableLocalizableFunction> _replacements = new HashMap<String, EscapableLocalizableFunction>();

    public MailTemplateContext build() {
        return new MailTemplateContextImpl(this._replacements);
    }

    public MailTemplateContextBuilder put(String placeholder, EscapableLocalizableFunction escapableLocalizableFunction) {
        this._replacements.put(placeholder, escapableLocalizableFunction);
        return this;
    }

    public MailTemplateContextBuilder put(String placeholder, EscapableObject<String> escapableObject) {
        this.put(placeholder, new EscapableLocalizableFunction(locale -> (String)escapableObject.getOriginalValue(), escapableObject.isEscape()));
        return this;
    }

    public MailTemplateContextBuilder put(String placeholder, String value) {
        this.put(placeholder, (EscapableObject<String>)new EscapableObject((Object)value, false));
        return this;
    }

    private static class MailTemplateContextImpl
    implements MailTemplateContext {
        private final Map<String, EscapableLocalizableFunction> _placeholders;

        public MailTemplateContextImpl(Map<String, EscapableLocalizableFunction> placeholders) {
            this._placeholders = new HashMap<String, EscapableLocalizableFunction>(placeholders);
        }

        public MailTemplateContext aggregateWith(MailTemplateContext mailTemplateContext) {
            return new AggregateMailTemplateContext(this, mailTemplateContext);
        }

        public Map<String, EscapableLocalizableFunction> getReplacements() {
            return Collections.unmodifiableMap(this._placeholders);
        }
    }
}

