/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.util.comparator;

import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.CollatorUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.servlet.ServletContext;

public class PluginComparator
implements Comparator<Object>,
Serializable {
    private final Collator _collator;
    private final Locale _locale;
    private final ServletContext _servletContext;

    public PluginComparator() {
        this._locale = LocaleUtil.getDefault();
        this._servletContext = ServletContextPool.get((String)PortalUtil.getPathContext());
        this._collator = CollatorUtil.getInstance((Locale)this._locale);
    }

    public PluginComparator(ServletContext servletContext, Locale locale) {
        this._servletContext = servletContext;
        this._locale = locale;
        this._collator = CollatorUtil.getInstance((Locale)this._locale);
    }

    @Override
    public int compare(Object plugin1, Object plugin2) {
        String name1 = this._getName(plugin1);
        String name2 = this._getName(plugin2);
        return this._collator.compare(name1, name2);
    }

    private String _getName(Object plugin) {
        String name = "";
        if (plugin instanceof LayoutTemplate) {
            LayoutTemplate layoutTemplate = (LayoutTemplate)plugin;
            name = layoutTemplate.getName();
        } else if (plugin instanceof Portlet) {
            Portlet portlet = (Portlet)plugin;
            name = PortalUtil.getPortletTitle((Portlet)portlet, (ServletContext)this._servletContext, (Locale)this._locale);
        } else if (plugin instanceof Theme) {
            Theme theme = (Theme)plugin;
            name = theme.getName();
        }
        return StringUtil.toLowerCase((String)name);
    }
}

