/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.bundle;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={BundleManager.class})
public class BundleManager {
    private static final int[] _INSTALLED_BUNDLE_STATES = new int[]{32, 2, 4};
    private static final Log _log = LogFactoryUtil.getLog(BundleManager.class);
    private BundleContext _bundleContext;

    public Bundle getBundle(String symbolicName, String versionString) {
        Version version = Version.parseVersion((String)versionString);
        for (Bundle bundle : this.getBundles()) {
            if (!symbolicName.equals(bundle.getSymbolicName()) || !version.equals((Object)bundle.getVersion())) continue;
            return bundle;
        }
        return null;
    }

    public List<Bundle> getBundles() {
        return ListUtil.fromArray((Object[])this._bundleContext.getBundles());
    }

    public List<Bundle> getInstalledBundles() {
        List<Bundle> bundles = this.getBundles();
        Iterator<Bundle> itr = bundles.iterator();
        while (itr.hasNext()) {
            Bundle bundle = itr.next();
            if (this.isInstalled(bundle)) continue;
            itr.remove();
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Manifest getManifest(File file) {
        block18: {
            Manifest manifest;
            ZipEntry zipEntry;
            ZipFile zipFile;
            InputStream inputStream;
            block17: {
                inputStream = null;
                zipFile = null;
                zipFile = new ZipFile(file);
                zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
                if (zipEntry != null) break block17;
                Manifest manifest2 = null;
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                return manifest2;
            }
            try {
                inputStream = zipFile.getInputStream(zipEntry);
                manifest = new Manifest(inputStream);
            }
            catch (Exception e) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ioe) {}
                }
                break block18;
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return manifest;
        }
        return null;
    }

    public boolean isInstalled(Bundle bundle) {
        return ArrayUtil.contains((int[])_INSTALLED_BUNDLE_STATES, (int)bundle.getState());
    }

    public boolean isInstalled(String symbolicName, String version) {
        Bundle bundle = this.getBundle(symbolicName, version);
        if (bundle == null) {
            return false;
        }
        return this.isInstalled(bundle);
    }

    public void uninstallBundle(Bundle bundle) {
        try {
            bundle.uninstall();
        }
        catch (BundleException be) {
            _log.error((Object)be, (Throwable)be);
        }
    }

    public void uninstallBundle(String symbolicName, String version) {
        Bundle bundle = this.getBundle(symbolicName, version);
        if (bundle == null) {
            return;
        }
        this.uninstallBundle(bundle);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }
}

