/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.service.impl;

import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.marketplace.bundle.BundleManagerUtil;
import com.liferay.marketplace.exception.AppPropertiesException;
import com.liferay.marketplace.exception.AppTitleException;
import com.liferay.marketplace.exception.AppVersionException;
import com.liferay.marketplace.model.App;
import com.liferay.marketplace.model.Module;
import com.liferay.marketplace.service.base.AppLocalServiceBaseImpl;
import com.liferay.marketplace.util.comparator.AppTitleComparator;
import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;

public class AppLocalServiceImpl
extends AppLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AppLocalServiceImpl.class);
    private List<App> _installedApps;
    private Map<String, String> _prepackagedApps;

    public void clearInstalledAppsCache() {
        this._installedApps = null;
        this._prepackagedApps = null;
    }

    @Override
    public App deleteApp(App app) {
        block3: {
            this.clearInstalledAppsCache();
            this.appPersistence.remove((BaseModel)app);
            List modules = this.modulePersistence.findByAppId(app.getAppId());
            for (Module module : modules) {
                this.moduleLocalService.deleteModule(module);
            }
            try {
                DLStoreUtil.deleteFile((long)app.getCompanyId(), (long)0L, (String)app.getFilePath());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return app;
    }

    @Override
    public App deleteApp(long appId) throws PortalException {
        App app = this.appPersistence.findByPrimaryKey(appId);
        return this.deleteApp(app);
    }

    public App fetchRemoteApp(long remoteAppId) {
        return this.appPersistence.fetchByRemoteAppId(remoteAppId);
    }

    public List<App> getApps(String category) {
        return this.appPersistence.findByCategory(category);
    }

    public List<App> getInstalledApps() {
        if (this._installedApps != null) {
            return this._installedApps;
        }
        List<App> installedApps = new ArrayList<App>();
        App coreApp = this.appPersistence.create(0L);
        coreApp.setTitle("Liferay Core");
        coreApp.setDescription("Plugins bundled with Liferay Portal.");
        coreApp.setVersion(ReleaseInfo.getVersion());
        coreApp.addContextName(PortalUtil.getServletContextName());
        installedApps.add(coreApp);
        List pluginPackages = DeployManagerUtil.getInstalledPluginPackages();
        for (PluginPackage pluginPackage : pluginPackages) {
            List modules = this.modulePersistence.findByContextName(pluginPackage.getContext());
            boolean installedApp = false;
            for (Module module : modules) {
                App app = this.appPersistence.fetchByPrimaryKey(module.getAppId());
                if (app == null || !app.isInstalled()) continue;
                installedApp = true;
                break;
            }
            if (installedApp) continue;
            App app = this.appPersistence.create(0L);
            app.setTitle(pluginPackage.getName());
            app.setDescription(pluginPackage.getLongDescription());
            app.setVersion(pluginPackage.getVersion());
            app.addContextName(pluginPackage.getContext());
            installedApps.add(app);
        }
        List apps = this.appPersistence.findAll();
        for (App app : apps) {
            if (!app.isInstalled()) continue;
            installedApps.add(app);
        }
        installedApps = ListUtil.sort(installedApps, (Comparator)((Object)new AppTitleComparator()));
        this._installedApps = installedApps;
        return this._installedApps;
    }

    public List<App> getInstalledApps(String category) {
        List apps = this.appPersistence.findByCategory(category);
        ArrayList<App> installedApps = new ArrayList<App>(apps.size());
        for (App app : apps) {
            if (!app.isInstalled()) continue;
            installedApps.add(app);
        }
        return installedApps;
    }

    public Map<String, String> getPrepackagedApps() {
        if (this._prepackagedApps != null) {
            return this._prepackagedApps;
        }
        HashMap<String, String> prepackagedApps = new HashMap<String, String>();
        List<Bundle> bundles = BundleManagerUtil.getInstalledBundles();
        for (Bundle bundle : bundles) {
            Dictionary headers = bundle.getHeaders();
            boolean liferayRelengBundle = GetterUtil.getBoolean((String)((String)headers.get("Liferay-Releng-Bundle")));
            if (!liferayRelengBundle) continue;
            prepackagedApps.put(bundle.getSymbolicName(), String.valueOf(bundle.getVersion()));
        }
        this._prepackagedApps = prepackagedApps;
        return this._prepackagedApps;
    }

    /*
     * Exception decompiling
     */
    public void installApp(long remoteAppId) throws PortalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processMarketplaceProperties(Properties properties) throws PortalException {
        long[] supersedesRemoteAppIds;
        for (long supersedesRemoteAppId : supersedesRemoteAppIds = StringUtil.split((String)properties.getProperty("supersedes-remote-app-ids"), (long)0L)) {
            App supersedesApp = this.appPersistence.fetchByRemoteAppId(supersedesRemoteAppId);
            if (supersedesApp == null || !supersedesApp.isInstalled()) continue;
            this.uninstallApp(supersedesRemoteAppId);
        }
    }

    public void uninstallApp(long remoteAppId) throws PortalException {
        this.clearInstalledAppsCache();
        App app = this.appPersistence.findByRemoteAppId(remoteAppId);
        List modules = this.modulePersistence.findByAppId(app.getAppId());
        for (Module module : modules) {
            this.moduleLocalService.deleteModule(module.getModuleId());
            if (module.isBundle()) {
                BundleManagerUtil.uninstallBundle(module.getBundleSymbolicName(), module.getBundleVersion());
                continue;
            }
            if (this.hasDependentApp(module)) continue;
            try {
                DeployManagerUtil.undeploy((String)module.getContextName());
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    public App updateApp(long userId, File file) throws PortalException {
        Properties properties = this.getMarketplaceProperties(file);
        if (properties == null) {
            throw new AppPropertiesException("Unable to read liferay-marketplace.properties");
        }
        long remoteAppId = GetterUtil.getLong((String)properties.getProperty("remote-app-id"));
        String title = properties.getProperty("title");
        String description = properties.getProperty("description");
        String category = properties.getProperty("category");
        String iconURL = properties.getProperty("icon-url");
        String version = properties.getProperty("version");
        return this.updateApp(userId, remoteAppId, title, description, category, iconURL, version, file);
    }

    public App updateApp(long userId, long remoteAppId, String title, String description, String category, String iconURL, String version, File file) throws PortalException {
        User user = this.userPersistence.fetchByPrimaryKey(userId);
        Date now = new Date();
        this.validate(title, version);
        App app = this.appPersistence.fetchByRemoteAppId(remoteAppId);
        if (app == null) {
            long appId = this.counterLocalService.increment();
            app = this.appPersistence.create(appId);
        }
        if (user != null) {
            app.setCompanyId(user.getCompanyId());
            app.setUserId(user.getUserId());
            app.setUserName(user.getFullName());
        }
        app.setCreateDate(now);
        app.setModifiedDate(now);
        app.setRemoteAppId(remoteAppId);
        app.setTitle(title);
        app.setDescription(description);
        app.setCategory(category);
        app.setIconURL(iconURL);
        app.setVersion(version);
        this.appPersistence.update((BaseModel)app);
        if (file != null) {
            try {
                DLStoreUtil.deleteFile((long)app.getCompanyId(), (long)0L, (String)app.getFilePath());
            }
            catch (Exception e) {
                // empty catch block
            }
            DLStoreUtil.addFile((long)app.getCompanyId(), (long)0L, (String)app.getFilePath(), (boolean)false, (File)file);
        }
        this.clearInstalledAppsCache();
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Properties getMarketplaceProperties(File liferayPackageFile) {
        Properties properties;
        ZipFile zipFile;
        InputStream inputStream;
        block11: {
            inputStream = null;
            zipFile = null;
            zipFile = new ZipFile(liferayPackageFile);
            ZipEntry zipEntry = zipFile.getEntry("liferay-marketplace.properties");
            inputStream = zipFile.getInputStream(zipEntry);
            String propertiesString = StringUtil.read((InputStream)inputStream);
            properties = PropertiesUtil.load((String)propertiesString);
            if (zipFile == null) break block11;
            try {
                zipFile.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        return properties;
        catch (IOException ioe) {
            Properties properties2;
            block12: {
                try {
                    properties2 = null;
                    if (zipFile == null) break block12;
                }
                catch (Throwable throwable) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
                try {
                    zipFile.close();
                }
                catch (IOException ioe3) {
                    // empty catch block
                }
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            return properties2;
        }
    }

    protected boolean hasDependentApp(Module module) throws PortalException {
        List modules = this.modulePersistence.findByContextName(module.getContextName());
        for (Module curModule : modules) {
            App app = this.appPersistence.findByPrimaryKey(curModule.getAppId());
            if (curModule.getAppId() == module.getAppId() || !app.isInstalled()) continue;
            return true;
        }
        return false;
    }

    protected void validate(String title, String version) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new AppTitleException();
        }
        if (Validator.isNull((String)version)) {
            throw new AppVersionException();
        }
    }
}

