/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.service.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.marketplace.exception.ModuleNamespaceException;
import com.liferay.marketplace.model.Module;
import com.liferay.marketplace.service.base.ModuleLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

@ProviderType
public class ModuleLocalServiceImpl
extends ModuleLocalServiceBaseImpl {
    public Module addModule(long userId, long appId, String bundleSymbolicName, String bundleVersion, String contextName) throws PortalException {
        Module module = this.fetchModule(appId, bundleSymbolicName, bundleVersion, contextName);
        if (module != null) {
            return module;
        }
        this.validate(bundleSymbolicName, contextName);
        long moduleId = this.counterLocalService.increment();
        module = this.modulePersistence.create(moduleId);
        module.setModuleId(moduleId);
        module.setAppId(appId);
        module.setBundleSymbolicName(bundleSymbolicName);
        module.setBundleVersion(bundleVersion);
        module.setContextName(contextName);
        this.modulePersistence.update((BaseModel)module);
        return module;
    }

    public Module fetchModule(long appId, String bundleSymbolicName, String bundleVersion, String contextName) {
        if (Validator.isNotNull((String)bundleSymbolicName)) {
            return this.modulePersistence.fetchByA_BSN_BV(appId, bundleSymbolicName, bundleVersion);
        }
        if (Validator.isNotNull((String)contextName)) {
            return this.modulePersistence.fetchByA_CN(appId, contextName);
        }
        return null;
    }

    public List<Module> getModules(long appId) {
        return this.modulePersistence.findByAppId(appId);
    }

    protected void validate(String bundleSymbolicName, String contextName) throws PortalException {
        if (Validator.isNull((String)bundleSymbolicName) && Validator.isNull((String)contextName)) {
            throw new ModuleNamespaceException();
        }
    }
}

