/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.marketplace.exception.NoSuchAppException;
import com.liferay.marketplace.model.App;
import com.liferay.marketplace.model.impl.AppImpl;
import com.liferay.marketplace.model.impl.AppModelImpl;
import com.liferay.marketplace.service.persistence.AppPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class AppPersistenceImpl
extends BasePersistenceImpl<App>
implements AppPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AppImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 8L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_UUID_UUID_1 = "app.uuid IS NULL";
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "app.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(app.uuid IS NULL OR app.uuid = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 10L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_C = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_C_UUID_1 = "app.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "app.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(app.uuid IS NULL OR app.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "app.companyId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_COMPANYID = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 2L);
    public static final FinderPath FINDER_PATH_COUNT_BY_COMPANYID = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "app.companyId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_REMOTEAPPID = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByRemoteAppId", new String[]{Long.class.getName()}, 4L);
    public static final FinderPath FINDER_PATH_COUNT_BY_REMOTEAPPID = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByRemoteAppId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_REMOTEAPPID_REMOTEAPPID_2 = "app.remoteAppId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_CATEGORY = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCategory", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CATEGORY = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCategory", new String[]{String.class.getName()}, 1L);
    public static final FinderPath FINDER_PATH_COUNT_BY_CATEGORY = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCategory", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_CATEGORY_CATEGORY_1 = "app.category IS NULL";
    private static final String _FINDER_COLUMN_CATEGORY_CATEGORY_2 = "app.category = ?";
    private static final String _FINDER_COLUMN_CATEGORY_CATEGORY_3 = "(app.category IS NULL OR app.category = '')";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_APP = "SELECT app FROM App app";
    private static final String _SQL_SELECT_APP_WHERE_PKS_IN = "SELECT app FROM App app WHERE appId IN (";
    private static final String _SQL_SELECT_APP_WHERE = "SELECT app FROM App app WHERE ";
    private static final String _SQL_COUNT_APP = "SELECT COUNT(app) FROM App app";
    private static final String _SQL_COUNT_APP_WHERE = "SELECT COUNT(app) FROM App app WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "app.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No App exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No App exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AppPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    private static final App _nullApp = new AppImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<App> toCacheModel() {
            return _nullAppCacheModel;
        }
    };
    private static final CacheModel<App> _nullAppCacheModel = new CacheModel<App>(){

        public App toEntityModel() {
            return _nullApp;
        }
    };

    public List<App> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<App> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<App> findByUuid(String uuid, int start, int end, OrderByComparator<App> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<App> findByUuid(String uuid, int start, int end, OrderByComparator<App> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<App> list = null;
        if (retrieveFromCache && (list = (List<App>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (App app : list) {
                if (Validator.equals((Object)uuid, (Object)app.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_APP_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY app.appId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public App findByUuid_First(String uuid, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByUuid_First(uuid, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchAppException(msg.toString());
    }

    public App fetchByUuid_First(String uuid, OrderByComparator<App> orderByComparator) {
        List<App> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App findByUuid_Last(String uuid, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByUuid_Last(uuid, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchAppException(msg.toString());
    }

    public App fetchByUuid_Last(String uuid, OrderByComparator<App> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<App> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App[] findByUuid_PrevAndNext(long appId, String uuid, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.findByPrimaryKey(appId);
        Session session = null;
        try {
            session = this.openSession();
            App[] array = new AppImpl[]{this.getByUuid_PrevAndNext(session, app, uuid, orderByComparator, true), app, this.getByUuid_PrevAndNext(session, app, uuid, orderByComparator, false)};
            App[] appArray = array;
            return appArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected App getByUuid_PrevAndNext(Session session, App app, String uuid, OrderByComparator<App> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_APP_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_UUID_1);
        } else if (uuid.equals("")) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY app.appId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)app)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (App)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (App app : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)app);
        }
    }

    public int countByUuid(String uuid) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_APP_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<App> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<App> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<App> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<App> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<App> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<App> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<App> list = null;
        if (retrieveFromCache && (list = (List<App>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (App app : list) {
                if (Validator.equals((Object)uuid, (Object)app.getUuid()) && companyId == app.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_APP_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            query.append("app.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY app.appId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public App findByUuid_C_First(String uuid, long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAppException(msg.toString());
    }

    public App fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<App> orderByComparator) {
        List<App> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App findByUuid_C_Last(String uuid, long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAppException(msg.toString());
    }

    public App fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<App> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<App> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App[] findByUuid_C_PrevAndNext(long appId, String uuid, long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.findByPrimaryKey(appId);
        Session session = null;
        try {
            session = this.openSession();
            App[] array = new AppImpl[]{this.getByUuid_C_PrevAndNext(session, app, uuid, companyId, orderByComparator, true), app, this.getByUuid_C_PrevAndNext(session, app, uuid, companyId, orderByComparator, false)};
            App[] appArray = array;
            return appArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected App getByUuid_C_PrevAndNext(Session session, App app, String uuid, long companyId, OrderByComparator<App> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_APP_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_C_UUID_1);
        } else if (uuid.equals("")) {
            query.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        query.append("app.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY app.appId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)app)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (App)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (App app : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)app);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_APP_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            query.append("app.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<App> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<App> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<App> findByCompanyId(long companyId, int start, int end, OrderByComparator<App> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<App> findByCompanyId(long companyId, int start, int end, OrderByComparator<App> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_COMPANYID;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<App> list = null;
        if (retrieveFromCache && (list = (List<App>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (App app : list) {
                if (companyId == app.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_APP_WHERE);
            query.append("app.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY app.appId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public App findByCompanyId_First(long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAppException(msg.toString());
    }

    public App fetchByCompanyId_First(long companyId, OrderByComparator<App> orderByComparator) {
        List<App> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App findByCompanyId_Last(long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAppException(msg.toString());
    }

    public App fetchByCompanyId_Last(long companyId, OrderByComparator<App> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<App> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App[] findByCompanyId_PrevAndNext(long appId, long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.findByPrimaryKey(appId);
        Session session = null;
        try {
            session = this.openSession();
            App[] array = new AppImpl[]{this.getByCompanyId_PrevAndNext(session, app, companyId, orderByComparator, true), app, this.getByCompanyId_PrevAndNext(session, app, companyId, orderByComparator, false)};
            App[] appArray = array;
            return appArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected App getByCompanyId_PrevAndNext(Session session, App app, long companyId, OrderByComparator<App> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_APP_WHERE);
        query.append("app.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY app.appId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)app)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (App)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (App app : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)app);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_COMPANYID;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_APP_WHERE);
            query.append("app.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public App findByRemoteAppId(long remoteAppId) throws NoSuchAppException {
        App app = this.fetchByRemoteAppId(remoteAppId);
        if (app == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("remoteAppId=");
            msg.append(remoteAppId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchAppException(msg.toString());
        }
        return app;
    }

    public App fetchByRemoteAppId(long remoteAppId) {
        return this.fetchByRemoteAppId(remoteAppId, true);
    }

    public App fetchByRemoteAppId(long remoteAppId, boolean retrieveFromCache) {
        App app;
        Object[] finderArgs = new Object[]{remoteAppId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_REMOTEAPPID, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof App && remoteAppId != (app = (App)result).getRemoteAppId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_APP_WHERE);
            query.append(_FINDER_COLUMN_REMOTEAPPID_REMOTEAPPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(remoteAppId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_REMOTEAPPID, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1 && _log.isWarnEnabled()) {
                        _log.warn((Object)("AppPersistenceImpl.fetchByRemoteAppId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                    }
                    App app2 = (App)list.get(0);
                    result = app2;
                    this.cacheResult(app2);
                    if (app2.getRemoteAppId() != remoteAppId) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_REMOTEAPPID, finderArgs, (Object)app2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_REMOTEAPPID, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (App)result;
    }

    public App removeByRemoteAppId(long remoteAppId) throws NoSuchAppException {
        App app = this.findByRemoteAppId(remoteAppId);
        return (App)this.remove((BaseModel)app);
    }

    public int countByRemoteAppId(long remoteAppId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_REMOTEAPPID;
        Object[] finderArgs = new Object[]{remoteAppId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_APP_WHERE);
            query.append(_FINDER_COLUMN_REMOTEAPPID_REMOTEAPPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(remoteAppId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<App> findByCategory(String category) {
        return this.findByCategory(category, -1, -1, null);
    }

    public List<App> findByCategory(String category, int start, int end) {
        return this.findByCategory(category, start, end, null);
    }

    public List<App> findByCategory(String category, int start, int end, OrderByComparator<App> orderByComparator) {
        return this.findByCategory(category, start, end, orderByComparator, true);
    }

    public List<App> findByCategory(String category, int start, int end, OrderByComparator<App> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CATEGORY;
            finderArgs = new Object[]{category};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_CATEGORY;
            finderArgs = new Object[]{category, start, end, orderByComparator};
        }
        List<App> list = null;
        if (retrieveFromCache && (list = (List<App>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (App app : list) {
                if (Validator.equals((Object)category, (Object)app.getCategory())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_APP_WHERE);
            boolean bindCategory = false;
            if (category == null) {
                query.append(_FINDER_COLUMN_CATEGORY_CATEGORY_1);
            } else if (category.equals("")) {
                query.append(_FINDER_COLUMN_CATEGORY_CATEGORY_3);
            } else {
                bindCategory = true;
                query.append(_FINDER_COLUMN_CATEGORY_CATEGORY_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY app.appId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindCategory) {
                    qPos.add(category);
                }
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public App findByCategory_First(String category, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByCategory_First(category, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("category=");
        msg.append(category);
        msg.append("}");
        throw new NoSuchAppException(msg.toString());
    }

    public App fetchByCategory_First(String category, OrderByComparator<App> orderByComparator) {
        List<App> list = this.findByCategory(category, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App findByCategory_Last(String category, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByCategory_Last(category, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("category=");
        msg.append(category);
        msg.append("}");
        throw new NoSuchAppException(msg.toString());
    }

    public App fetchByCategory_Last(String category, OrderByComparator<App> orderByComparator) {
        int count = this.countByCategory(category);
        if (count == 0) {
            return null;
        }
        List<App> list = this.findByCategory(category, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App[] findByCategory_PrevAndNext(long appId, String category, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.findByPrimaryKey(appId);
        Session session = null;
        try {
            session = this.openSession();
            App[] array = new AppImpl[]{this.getByCategory_PrevAndNext(session, app, category, orderByComparator, true), app, this.getByCategory_PrevAndNext(session, app, category, orderByComparator, false)};
            App[] appArray = array;
            return appArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected App getByCategory_PrevAndNext(Session session, App app, String category, OrderByComparator<App> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_APP_WHERE);
        boolean bindCategory = false;
        if (category == null) {
            query.append(_FINDER_COLUMN_CATEGORY_CATEGORY_1);
        } else if (category.equals("")) {
            query.append(_FINDER_COLUMN_CATEGORY_CATEGORY_3);
        } else {
            bindCategory = true;
            query.append(_FINDER_COLUMN_CATEGORY_CATEGORY_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY app.appId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindCategory) {
            qPos.add(category);
        }
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)app)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (App)list.get(1);
        }
        return null;
    }

    public void removeByCategory(String category) {
        for (App app : this.findByCategory(category, -1, -1, null)) {
            this.remove((BaseModel)app);
        }
    }

    public int countByCategory(String category) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CATEGORY;
        Object[] finderArgs = new Object[]{category};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_APP_WHERE);
            boolean bindCategory = false;
            if (category == null) {
                query.append(_FINDER_COLUMN_CATEGORY_CATEGORY_1);
            } else if (category.equals("")) {
                query.append(_FINDER_COLUMN_CATEGORY_CATEGORY_3);
            } else {
                bindCategory = true;
                query.append(_FINDER_COLUMN_CATEGORY_CATEGORY_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindCategory) {
                    qPos.add(category);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AppPersistenceImpl() {
        this.setModelClass(App.class);
    }

    public void cacheResult(App app) {
        this.entityCache.putResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, (Serializable)Long.valueOf(app.getPrimaryKey()), (Serializable)app);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_REMOTEAPPID, new Object[]{app.getRemoteAppId()}, (Object)app);
        app.resetOriginalValues();
    }

    public void cacheResult(List<App> apps) {
        for (App app : apps) {
            if (this.entityCache.getResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, (Serializable)Long.valueOf(app.getPrimaryKey())) == null) {
                this.cacheResult(app);
                continue;
            }
            app.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AppImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(App app) {
        this.entityCache.removeResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, (Serializable)Long.valueOf(app.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((AppModelImpl)app);
    }

    public void clearCache(List<App> apps) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (App app : apps) {
            this.entityCache.removeResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, (Serializable)Long.valueOf(app.getPrimaryKey()));
            this.clearUniqueFindersCache((AppModelImpl)app);
        }
    }

    protected void cacheUniqueFindersCache(AppModelImpl appModelImpl, boolean isNew) {
        if (isNew) {
            Object[] args = new Object[]{appModelImpl.getRemoteAppId()};
            this.finderCache.putResult(FINDER_PATH_COUNT_BY_REMOTEAPPID, args, (Object)1L);
            this.finderCache.putResult(FINDER_PATH_FETCH_BY_REMOTEAPPID, args, (Object)appModelImpl);
        } else if ((appModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_REMOTEAPPID.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{appModelImpl.getRemoteAppId()};
            this.finderCache.putResult(FINDER_PATH_COUNT_BY_REMOTEAPPID, args, (Object)1L);
            this.finderCache.putResult(FINDER_PATH_FETCH_BY_REMOTEAPPID, args, (Object)appModelImpl);
        }
    }

    protected void clearUniqueFindersCache(AppModelImpl appModelImpl) {
        Object[] args = new Object[]{appModelImpl.getRemoteAppId()};
        this.finderCache.removeResult(FINDER_PATH_COUNT_BY_REMOTEAPPID, args);
        this.finderCache.removeResult(FINDER_PATH_FETCH_BY_REMOTEAPPID, args);
        if ((appModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_REMOTEAPPID.getColumnBitmask()) != 0L) {
            args = new Object[]{appModelImpl.getOriginalRemoteAppId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_REMOTEAPPID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_REMOTEAPPID, args);
        }
    }

    public App create(long appId) {
        AppImpl app = new AppImpl();
        app.setNew(true);
        app.setPrimaryKey(appId);
        String uuid = PortalUUIDUtil.generate();
        app.setUuid(uuid);
        app.setCompanyId(this.companyProvider.getCompanyId());
        return app;
    }

    public App remove(long appId) throws NoSuchAppException {
        return this.remove(Long.valueOf(appId));
    }

    public App remove(Serializable primaryKey) throws NoSuchAppException {
        Session session = null;
        try {
            session = this.openSession();
            App app = (App)session.get(AppImpl.class, primaryKey);
            if (app == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchAppException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            App app2 = (App)this.remove((BaseModel)app);
            return app2;
        }
        catch (NoSuchAppException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected App removeImpl(App app) {
        app = this.toUnwrappedModel(app);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)app)) {
                app = (App)session.get(AppImpl.class, app.getPrimaryKeyObj());
            }
            if (app != null) {
                session.delete((Object)app);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (app != null) {
            this.clearCache(app);
        }
        return app;
    }

    public App updateImpl(App app) {
        app = this.toUnwrappedModel(app);
        boolean isNew = app.isNew();
        AppModelImpl appModelImpl = (AppModelImpl)app;
        if (Validator.isNull((String)app.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            app.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && app.getCreateDate() == null) {
            if (serviceContext == null) {
                app.setCreateDate(now);
            } else {
                app.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!appModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                app.setModifiedDate(now);
            } else {
                app.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (app.isNew()) {
                session.save((Object)app);
                app.setNew(false);
            } else {
                app = (App)session.merge((Object)app);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !AppModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else {
            Object[] args;
            if ((appModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID.getColumnBitmask()) != 0L) {
                args = new Object[]{appModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
                args = new Object[]{appModelImpl.getUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
            }
            if ((appModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C.getColumnBitmask()) != 0L) {
                args = new Object[]{appModelImpl.getOriginalUuid(), appModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
                args = new Object[]{appModelImpl.getUuid(), appModelImpl.getCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
            }
            if ((appModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID.getColumnBitmask()) != 0L) {
                args = new Object[]{appModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COMPANYID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID, args);
                args = new Object[]{appModelImpl.getCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COMPANYID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID, args);
            }
            if ((appModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CATEGORY.getColumnBitmask()) != 0L) {
                args = new Object[]{appModelImpl.getOriginalCategory()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_CATEGORY, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CATEGORY, args);
                args = new Object[]{appModelImpl.getCategory()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_CATEGORY, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CATEGORY, args);
            }
        }
        this.entityCache.putResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, (Serializable)Long.valueOf(app.getPrimaryKey()), (Serializable)app, false);
        this.clearUniqueFindersCache(appModelImpl);
        this.cacheUniqueFindersCache(appModelImpl, isNew);
        app.resetOriginalValues();
        return app;
    }

    protected App toUnwrappedModel(App app) {
        if (app instanceof AppImpl) {
            return app;
        }
        AppImpl appImpl = new AppImpl();
        appImpl.setNew(app.isNew());
        appImpl.setPrimaryKey(app.getPrimaryKey());
        appImpl.setUuid(app.getUuid());
        appImpl.setAppId(app.getAppId());
        appImpl.setCompanyId(app.getCompanyId());
        appImpl.setUserId(app.getUserId());
        appImpl.setUserName(app.getUserName());
        appImpl.setCreateDate(app.getCreateDate());
        appImpl.setModifiedDate(app.getModifiedDate());
        appImpl.setRemoteAppId(app.getRemoteAppId());
        appImpl.setTitle(app.getTitle());
        appImpl.setDescription(app.getDescription());
        appImpl.setCategory(app.getCategory());
        appImpl.setIconURL(app.getIconURL());
        appImpl.setVersion(app.getVersion());
        return appImpl;
    }

    public App findByPrimaryKey(Serializable primaryKey) throws NoSuchAppException {
        App app = this.fetchByPrimaryKey(primaryKey);
        if (app == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchAppException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return app;
    }

    public App findByPrimaryKey(long appId) throws NoSuchAppException {
        return this.findByPrimaryKey(Long.valueOf(appId));
    }

    public App fetchByPrimaryKey(Serializable primaryKey) {
        App app = (App)this.entityCache.getResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, primaryKey);
        if (app == _nullApp) {
            return null;
        }
        if (app == null) {
            Session session = null;
            try {
                session = this.openSession();
                app = (App)session.get(AppImpl.class, primaryKey);
                if (app != null) {
                    this.cacheResult(app);
                } else {
                    this.entityCache.putResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, primaryKey, (Serializable)_nullApp);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return app;
    }

    public App fetchByPrimaryKey(long appId) {
        return this.fetchByPrimaryKey(Long.valueOf(appId));
    }

    public Map<Serializable, App> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, App> map = new HashMap<Serializable, App>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            App app = this.fetchByPrimaryKey(primaryKey);
            if (app != null) {
                map.put(primaryKey, app);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            App app = (App)this.entityCache.getResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, primaryKey);
            if (app == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(primaryKey);
                continue;
            }
            map.put(primaryKey, app);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_APP_WHERE_PKS_IN);
        for (Serializable primaryKey : uncachedPrimaryKeys) {
            query.append(String.valueOf(primaryKey));
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String sql = query.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(sql);
            for (App app : q.list()) {
                map.put(app.getPrimaryKeyObj(), app);
                this.cacheResult(app);
                uncachedPrimaryKeys.remove(app.getPrimaryKeyObj());
            }
            for (Serializable primaryKey : uncachedPrimaryKeys) {
                this.entityCache.putResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, primaryKey, (Serializable)_nullApp);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<App> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<App> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<App> findAll(int start, int end, OrderByComparator<App> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<App> findAll(int start, int end, OrderByComparator<App> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_APP);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_APP;
                if (pagination) {
                    sql = sql.concat(" ORDER BY app.appId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (App app : this.findAll()) {
            this.remove((BaseModel)app);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_APP);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AppModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(AppImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

