/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.service.impl;

import com.liferay.marketplace.exception.ModuleNamespaceException;
import com.liferay.marketplace.model.App;
import com.liferay.marketplace.model.Module;
import com.liferay.marketplace.service.base.ModuleLocalServiceBaseImpl;
import com.liferay.marketplace.service.persistence.AppPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"module.class.name=com.liferay.marketplace.model.Module"}, service={AopService.class})
public class ModuleLocalServiceImpl
extends ModuleLocalServiceBaseImpl {
    @Reference
    private AppPersistence _appPersistence;

    public Module addModule(long appId, String bundleSymbolicName, String bundleVersion, String contextName) throws PortalException {
        Module module = this.fetchModule(appId, bundleSymbolicName, bundleVersion, contextName);
        if (module != null) {
            return module;
        }
        App app = this._appPersistence.findByPrimaryKey(appId);
        this.validate(bundleSymbolicName, contextName);
        long moduleId = this.counterLocalService.increment();
        module = this.modulePersistence.create(moduleId);
        module.setModuleId(moduleId);
        module.setCompanyId(app.getCompanyId());
        module.setAppId(appId);
        module.setBundleSymbolicName(bundleSymbolicName);
        module.setBundleVersion(bundleVersion);
        module.setContextName(contextName);
        return (Module)this.modulePersistence.update((BaseModel)module);
    }

    public void deleteModules(long appId) {
        this.modulePersistence.removeByAppId(appId);
    }

    public Module fetchModule(long appId, String bundleSymbolicName, String bundleVersion, String contextName) {
        if (Validator.isNotNull((String)bundleSymbolicName)) {
            return this.modulePersistence.fetchByA_BSN_BV(appId, bundleSymbolicName, bundleVersion);
        }
        if (Validator.isNotNull((String)contextName)) {
            return this.modulePersistence.fetchByA_CN(appId, contextName);
        }
        return null;
    }

    public List<Module> getModules(long appId) {
        return this.modulePersistence.findByAppId(appId);
    }

    protected void validate(String bundleSymbolicName, String contextName) throws PortalException {
        if (Validator.isNull((String)bundleSymbolicName) && Validator.isNull((String)contextName)) {
            throw new ModuleNamespaceException();
        }
    }
}

