/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.internal.lpkg.deployer;

import com.liferay.marketplace.model.App;
import com.liferay.marketplace.model.Module;
import com.liferay.marketplace.service.AppLocalService;
import com.liferay.marketplace.service.ModuleLocalService;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class LPKGDeployerRegistrar {
    private static final Log _log = LogFactoryUtil.getLog(LPKGDeployerRegistrar.class);
    @Reference
    private AppLocalService _appLocalService;
    private final BundleListener _bundleListener = new SynchronousBundleListener(){

        public void bundleChanged(BundleEvent bundleEvent) {
            if (bundleEvent.getType() == 2) {
                LPKGDeployerRegistrar.this._register(bundleEvent.getBundle(), null, null);
            }
        }
    };
    @Reference
    private LPKGDeployer _lpkgDeployer;
    @Reference
    private ModuleLocalService _moduleLocalService;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.marketplace.service)(release.schema.version=2.0.3))")
    private Release _release;

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        bundleContext.addBundleListener(this._bundleListener);
        Map deployedLPKGBundles = this._lpkgDeployer.getDeployedLPKGBundles();
        if (deployedLPKGBundles.isEmpty()) {
            return;
        }
        HashMap<Long, App> apps = new HashMap<Long, App>();
        for (App app : this._appLocalService.getApps(-1, -1)) {
            apps.put(app.getRemoteAppId(), app);
        }
        HashMap<Long, List<Module>> modules = new HashMap<Long, List<Module>>();
        for (Module module : this._moduleLocalService.getModules(-1, -1)) {
            List appModules = modules.computeIfAbsent(module.getAppId(), key -> new ArrayList());
            appModules.add(module);
        }
        for (Bundle bundle : deployedLPKGBundles.keySet()) {
            this._register(bundle, apps, modules);
        }
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        bundleContext.removeBundleListener(this._bundleListener);
    }

    private void _doRegister(Bundle lpkgBundle, Map<Long, App> apps, Map<Long, List<Module>> modules) throws Exception {
        Tuple tuple;
        String[] bundleStrings;
        URL url = lpkgBundle.getEntry("liferay-marketplace.properties");
        if (url == null) {
            return;
        }
        Properties properties = PropertiesUtil.load((InputStream)url.openStream(), (String)"ISO-8859-1");
        long remoteAppId = GetterUtil.getLong((String)properties.getProperty("remote-app-id"));
        String version = properties.getProperty("version");
        if (remoteAppId <= 0L || Validator.isNull((String)version)) {
            return;
        }
        String title = properties.getProperty("title");
        String description = properties.getProperty("description");
        String category = properties.getProperty("category");
        String iconURL = properties.getProperty("icon-url");
        boolean required = GetterUtil.getBoolean((String)properties.getProperty("required"));
        App app = null;
        app = apps == null ? this._appLocalService.fetchRemoteApp(remoteAppId) : apps.get(remoteAppId);
        if (!(app == null || Objects.equals(title, app.getTitle()) && Objects.equals(description, app.getDescription()) && Objects.equals(category, app.getCategory()) && Objects.equals(iconURL, app.getIconURL()) && required == app.isRequired())) {
            app = null;
        }
        if (app == null) {
            app = this._appLocalService.updateApp(0L, remoteAppId, title, description, category, iconURL, version, required, null);
        }
        HashSet<Tuple> oldTuples = new HashSet<Tuple>();
        List oldModules = null;
        oldModules = modules == null ? this._moduleLocalService.getModules(app.getAppId()) : modules.getOrDefault(app.getAppId(), Collections.emptyList());
        for (Module module : oldModules) {
            oldTuples.add(new Tuple(module.getModuleId(), module.getBundleSymbolicName(), module.getBundleVersion(), module.getContextName()));
        }
        ArrayList<Tuple> newTuples = new ArrayList<Tuple>();
        for (String bundleString : bundleStrings = StringUtil.split((String)properties.getProperty("bundles"))) {
            String[] bundleStringParts = StringUtil.split((String)bundleString, (char)'#');
            tuple = new Tuple(0L, bundleStringParts[0], bundleStringParts[1], bundleStringParts[2]);
            if (oldTuples.remove(tuple)) continue;
            newTuples.add(tuple);
        }
        String[] contextNames = StringUtil.split((String)properties.getProperty("context-names"));
        for (String contextName : contextNames) {
            tuple = new Tuple(0L, contextName, "", contextName);
            if (oldTuples.remove(tuple)) continue;
            newTuples.add(tuple);
        }
        for (Tuple tuple2 : oldTuples) {
            Module module = this._moduleLocalService.fetchModule(tuple2._moduleId);
            if (module == null) continue;
            this._moduleLocalService.deleteModule(tuple2._moduleId);
        }
        for (Tuple tuple3 : newTuples) {
            this._moduleLocalService.addModule(app.getAppId(), tuple3._symbolicName, tuple3._version, tuple3._contextName);
        }
    }

    private void _register(Bundle lpkgBundle, Map<Long, App> apps, Map<Long, List<Module>> modules) {
        try {
            this._doRegister(lpkgBundle, apps, modules);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to track installed app " + lpkgBundle.getSymbolicName() + " with Marketplace"), (Throwable)exception);
        }
    }

    private static class Tuple {
        private final String _contextName;
        private final long _moduleId;
        private final String _symbolicName;
        private final String _version;

        public boolean equals(Object object) {
            Tuple tuple = (Tuple)object;
            return Objects.equals(this._symbolicName, tuple._symbolicName) && Objects.equals(this._version, tuple._version) && Objects.equals(this._contextName, tuple._contextName);
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (Object)this._symbolicName);
            hash = HashUtil.hash((int)hash, (Object)this._version);
            return HashUtil.hash((int)hash, (Object)this._contextName);
        }

        private Tuple(long moduleId, String symbolicName, String version, String contextName) {
            this._moduleId = moduleId;
            this._symbolicName = symbolicName;
            this._version = version;
            this._contextName = contextName;
        }
    }
}

