/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.marketplace.model.Module;
import com.liferay.marketplace.service.ModuleLocalService;
import com.liferay.marketplace.service.ModuleLocalServiceUtil;
import com.liferay.marketplace.service.persistence.ModulePersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class ModuleLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
ModuleLocalService {
    protected ModuleLocalService moduleLocalService;
    @Reference
    protected ModulePersistence modulePersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(ModuleLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Module addModule(Module module) {
        module.setNew(true);
        return (Module)this.modulePersistence.update((BaseModel)module);
    }

    @Transactional(enabled=false)
    public Module createModule(long moduleId) {
        return this.modulePersistence.create(moduleId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Module deleteModule(long moduleId) throws PortalException {
        return this.modulePersistence.remove(moduleId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Module deleteModule(Module module) {
        return (Module)this.modulePersistence.remove((BaseModel)module);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.modulePersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Module.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.modulePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.modulePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.modulePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.modulePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.modulePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Module fetchModule(long moduleId) {
        return this.modulePersistence.fetchByPrimaryKey(moduleId);
    }

    public Module fetchModuleByUuidAndCompanyId(String uuid, long companyId) {
        return this.modulePersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public Module getModule(long moduleId) throws PortalException {
        return this.modulePersistence.findByPrimaryKey(moduleId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.moduleLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Module.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("moduleId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.moduleLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Module.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("moduleId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.moduleLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Module.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("moduleId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.modulePersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement ModuleLocalServiceImpl#deleteModule(Module) to avoid orphaned data");
        }
        return this.moduleLocalService.deleteModule((Module)persistedModel);
    }

    public BasePersistence<Module> getBasePersistence() {
        return this.modulePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.modulePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public Module getModuleByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.modulePersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<Module> getModules(int start, int end) {
        return this.modulePersistence.findAll(start, end);
    }

    public int getModulesCount() {
        return this.modulePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Module updateModule(Module module) {
        return (Module)this.modulePersistence.update((BaseModel)module);
    }

    @Deactivate
    protected void deactivate() {
        ModuleLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{ModuleLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.moduleLocalService = (ModuleLocalService)aopProxy;
        ModuleLocalServiceUtil.setService((ModuleLocalService)this.moduleLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return ModuleLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Module.class;
    }

    protected String getModelClassName() {
        return Module.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.modulePersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

