/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.service.impl;

import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.marketplace.exception.AppPropertiesException;
import com.liferay.marketplace.exception.AppTitleException;
import com.liferay.marketplace.exception.AppVersionException;
import com.liferay.marketplace.internal.bundle.BundleManagerUtil;
import com.liferay.marketplace.model.App;
import com.liferay.marketplace.model.Module;
import com.liferay.marketplace.service.ModuleLocalService;
import com.liferay.marketplace.service.base.AppLocalServiceBaseImpl;
import com.liferay.marketplace.service.persistence.ModulePersistence;
import com.liferay.marketplace.util.comparator.AppTitleComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.PluginPackageUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.marketplace.model.App"}, service={AopService.class})
public class AppLocalServiceImpl
extends AppLocalServiceBaseImpl {
    private static final String[] _SAFE_FILE_NAME_1 = new String[]{"\\", ":", ">", "<", "|", "?", "\"", "/", "*"};
    private static final String[] _SAFE_FILE_NAME_2 = new String[]{"_BSL_", "_COL_", "_GT_", "_LT_", "_PIP_", "_QUE_", "_QUO_", "_SL_", "_ST_"};
    private static final Log _log = LogFactoryUtil.getLog(AppLocalServiceImpl.class);
    private List<App> _installedApps;
    @Reference
    private ModuleLocalService _moduleLocalService;
    @Reference
    private ModulePersistence _modulePersistence;
    @Reference
    private Portal _portal;
    private Map<String, String> _prepackagedApps;
    @Reference(target="(default=true)")
    private Store _store;
    @Reference
    private UserLocalService _userLocalService;

    public void clearInstalledAppsCache() {
        this._installedApps = null;
        this._prepackagedApps = null;
    }

    @Override
    @SystemEvent(type=1)
    public App deleteApp(App app) {
        block3: {
            this.clearInstalledAppsCache();
            this.appPersistence.remove((BaseModel)app);
            List modules = this._modulePersistence.findByAppId(app.getAppId());
            for (Module module : modules) {
                this._moduleLocalService.deleteModule(module);
            }
            try {
                this._store.deleteDirectory(app.getCompanyId(), 0L, app.getFilePath());
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)exception);
            }
        }
        return app;
    }

    @Override
    public App deleteApp(long appId) throws PortalException {
        App app = this.appPersistence.findByPrimaryKey(appId);
        return this.deleteApp(app);
    }

    public App fetchRemoteApp(long remoteAppId) {
        return this.appPersistence.fetchByRemoteAppId(remoteAppId);
    }

    public List<App> getApps(String category) {
        return this.appPersistence.findByCategory(category);
    }

    public List<App> getInstalledApps() {
        if (this._installedApps != null) {
            return this._installedApps;
        }
        List<App> installedApps = new ArrayList<App>();
        App coreApp = this.appPersistence.create(0L);
        coreApp.setTitle("Liferay Core");
        coreApp.setDescription("Plugins bundled with Liferay Portal.");
        coreApp.setVersion(ReleaseInfo.getVersion());
        coreApp.addContextName(this._portal.getServletContextName());
        installedApps.add(coreApp);
        for (PluginPackage pluginPackage : PluginPackageUtil.getInstalledPluginPackages()) {
            List modules = this._modulePersistence.findByContextName(pluginPackage.getContext());
            boolean installedApp = false;
            for (Module module : modules) {
                App app = this.appPersistence.fetchByPrimaryKey(module.getAppId());
                if (app == null || !app.isInstalled()) continue;
                installedApp = true;
                break;
            }
            if (installedApp) continue;
            App app = this.appPersistence.create(0L);
            app.setTitle(pluginPackage.getName());
            app.setDescription(pluginPackage.getLongDescription());
            app.setVersion(pluginPackage.getVersion());
            app.setRequired(true);
            app.addContextName(pluginPackage.getContext());
            installedApps.add(app);
        }
        List apps = this.appPersistence.findAll();
        for (App app : apps) {
            if (!app.isInstalled()) continue;
            installedApps.add(app);
        }
        installedApps = ListUtil.sort(installedApps, (Comparator)new AppTitleComparator());
        this._installedApps = installedApps;
        return this._installedApps;
    }

    public List<App> getInstalledApps(String category) {
        List apps = this.appPersistence.findByCategory(category);
        ArrayList<App> installedApps = new ArrayList<App>(apps.size());
        for (App app : apps) {
            if (!app.isInstalled()) continue;
            installedApps.add(app);
        }
        return installedApps;
    }

    public Map<String, String> getPrepackagedApps() {
        if (this._prepackagedApps != null) {
            return this._prepackagedApps;
        }
        HashMap<String, String> prepackagedApps = new HashMap<String, String>();
        List<Bundle> bundles = BundleManagerUtil.getInstalledBundles();
        for (Bundle bundle : bundles) {
            Dictionary headers = bundle.getHeaders("");
            boolean liferayRelengBundle = GetterUtil.getBoolean((String)((String)headers.get("Liferay-Releng-Bundle")));
            if (!liferayRelengBundle) continue;
            prepackagedApps.put(bundle.getSymbolicName(), String.valueOf(bundle.getVersion()));
        }
        this._prepackagedApps = prepackagedApps;
        return this._prepackagedApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installApp(long remoteAppId) throws PortalException {
        App app = this.appPersistence.findByRemoteAppId(remoteAppId);
        if (!this._store.hasFile(app.getCompanyId(), 0L, app.getFilePath(), "1.0")) {
            throw new NoSuchFileException();
        }
        try (InputStream inputStream = this._store.getFileAsStream(app.getCompanyId(), 0L, app.getFilePath(), "");){
            if (inputStream == null) {
                throw new IOException("Unable to open file at " + app.getFilePath());
            }
            File file = new File(StringBundler.concat((String[])new String[]{SystemProperties.get((String)"java.io.tmpdir"), "/", this._encodeSafeFileName(app.getTitle()), ".", FileUtil.getExtension((String)app.getFileName())}));
            FileUtil.write((File)file, (InputStream)inputStream);
            BundleManagerUtil.installLPKG(file);
        }
        catch (IOException ioException) {
            throw new PortalException((Throwable)ioException);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        finally {
            this.clearInstalledAppsCache();
        }
    }

    public boolean isDownloaded(App app) {
        return this._store.hasFile(app.getCompanyId(), 0L, app.getFilePath(), "1.0");
    }

    public void uninstallApp(long remoteAppId) throws PortalException {
        this.clearInstalledAppsCache();
        App app = this.appPersistence.findByRemoteAppId(remoteAppId);
        List modules = this._modulePersistence.findByAppId(app.getAppId());
        for (Module module : modules) {
            this._moduleLocalService.deleteModule(module.getModuleId());
            if (!module.isBundle()) continue;
            BundleManagerUtil.uninstallBundle(module.getBundleSymbolicName(), module.getBundleVersion());
        }
    }

    public App updateApp(long userId, File file) throws PortalException {
        Properties properties = this._getMarketplaceProperties(file);
        if (properties == null) {
            throw new AppPropertiesException("Unable to read liferay-marketplace.properties");
        }
        long remoteAppId = GetterUtil.getLong((String)properties.getProperty("remote-app-id"));
        String title = properties.getProperty("title");
        String description = properties.getProperty("description");
        String category = properties.getProperty("category");
        String iconURL = properties.getProperty("icon-url");
        String version = properties.getProperty("version");
        boolean required = GetterUtil.getBoolean((String)properties.getProperty("required"));
        return this.updateApp(userId, remoteAppId, title, description, category, iconURL, version, required, file);
    }

    public App updateApp(long userId, long remoteAppId, String title, String description, String category, String iconURL, String version, boolean required, File file) throws PortalException {
        App app;
        block17: {
            User user = this._userLocalService.fetchUser(userId);
            Date date = new Date();
            this._validate(title, version);
            app = this.appPersistence.fetchByRemoteAppId(remoteAppId);
            if (app == null) {
                long appId = this.counterLocalService.increment();
                app = this.appPersistence.create(appId);
            }
            if (user != null) {
                app.setCompanyId(user.getCompanyId());
                app.setUserId(user.getUserId());
                app.setUserName(user.getFullName());
            }
            app.setCreateDate(date);
            app.setModifiedDate(date);
            app.setRemoteAppId(remoteAppId);
            app.setTitle(title);
            app.setDescription(description);
            app.setCategory(category);
            app.setIconURL(iconURL);
            app.setVersion(version);
            app.setRequired(required);
            app = (App)this.appPersistence.update((BaseModel)app);
            if (file != null) {
                try (FileInputStream inputStream = new FileInputStream(file);){
                    this._store.deleteDirectory(app.getCompanyId(), 0L, app.getFilePath());
                    this._store.addFile(app.getCompanyId(), 0L, app.getFilePath(), "1.0", (InputStream)inputStream);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block17;
                    _log.debug((Throwable)exception);
                }
            }
        }
        this.clearInstalledAppsCache();
        return app;
    }

    private String _encodeSafeFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        fileName = FileUtil.encodeSafeFileName((String)fileName);
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_1, (String[])_SAFE_FILE_NAME_2);
    }

    /*
     * Exception decompiling
     */
    private Properties _getMarketplaceProperties(File liferayPackageFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _validate(String title, String version) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new AppTitleException();
        }
        if (Validator.isNull((String)version)) {
            throw new AppVersionException();
        }
    }
}

