/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.internal.upgrade.v0_0_1;

import com.liferay.expando.kernel.exception.NoSuchTableException;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.util.List;

public class ExpandoUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ExpandoUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final ExpandoColumnLocalService _expandoColumnLocalService;
    private final ExpandoTableLocalService _expandoTableLocalService;
    private final ExpandoValueLocalService _expandoValueLocalService;

    public ExpandoUpgradeProcess(CompanyLocalService companyLocalService, ExpandoColumnLocalService expandoColumnLocalService, ExpandoTableLocalService expandoTableLocalService, ExpandoValueLocalService expandoValueLocalService) {
        this._companyLocalService = companyLocalService;
        this._expandoColumnLocalService = expandoColumnLocalService;
        this._expandoTableLocalService = expandoTableLocalService;
        this._expandoValueLocalService = expandoValueLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> this.updateMPExpandoColumns((long)companyId));
    }

    protected void updateMPExpandoColumns(long companyId) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(String.valueOf(companyId));){
            ExpandoTable expandoTable = null;
            try {
                expandoTable = this._expandoTableLocalService.getTable(companyId, User.class.getName(), "MP");
            }
            catch (NoSuchTableException noSuchTableException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)noSuchTableException, (Throwable)noSuchTableException);
                }
                if (loggingTimer != null) {
                    if (var4_3 != null) {
                        try {
                            loggingTimer.close();
                        }
                        catch (Throwable throwable) {
                            var4_3.addSuppressed(throwable);
                        }
                    } else {
                        loggingTimer.close();
                    }
                }
                return;
            }
            ExpandoColumn oldExpandoColumn = this._expandoColumnLocalService.getColumn(companyId, User.class.getName(), expandoTable.getName(), "client-id");
            if (oldExpandoColumn == null) {
                return;
            }
            ExpandoColumn newExpandoColumn = this._expandoColumnLocalService.getColumn(companyId, User.class.getName(), expandoTable.getName(), "clientID");
            if (newExpandoColumn == null) {
                newExpandoColumn = this._expandoColumnLocalService.updateColumn(oldExpandoColumn.getColumnId(), "clientID", 15);
            }
            List expandoValues = this._expandoValueLocalService.getColumnValues(oldExpandoColumn.getColumnId(), -1, -1);
            for (ExpandoValue expandoValue : expandoValues) {
                this._expandoValueLocalService.addValue(expandoValue.getCompanyId(), User.class.getName(), expandoTable.getName(), newExpandoColumn.getName(), expandoValue.getClassPK(), expandoValue.getString());
            }
            this._expandoColumnLocalService.deleteColumn(oldExpandoColumn.getColumnId());
        }
    }
}

