/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.message.boards.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the MBSuspiciousActivity service. Represents a row in the &quot;MBSuspiciousActivity&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.message.boards.model.impl.MBSuspiciousActivityModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.message.boards.model.impl.MBSuspiciousActivityImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see MBSuspiciousActivity
 * @generated
 */
@ProviderType
public interface MBSuspiciousActivityModel
	extends BaseModel<MBSuspiciousActivity>, ContainerModel,
			CTModel<MBSuspiciousActivity>, GroupedModel, MVCCModel,
			ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a message boards suspicious activity model instance should use the {@link MBSuspiciousActivity} interface instead.
	 */

	/**
	 * Returns the primary key of this message boards suspicious activity.
	 *
	 * @return the primary key of this message boards suspicious activity
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this message boards suspicious activity.
	 *
	 * @param primaryKey the primary key of this message boards suspicious activity
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this message boards suspicious activity.
	 *
	 * @return the mvcc version of this message boards suspicious activity
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this message boards suspicious activity.
	 *
	 * @param mvccVersion the mvcc version of this message boards suspicious activity
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this message boards suspicious activity.
	 *
	 * @return the ct collection ID of this message boards suspicious activity
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this message boards suspicious activity.
	 *
	 * @param ctCollectionId the ct collection ID of this message boards suspicious activity
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this message boards suspicious activity.
	 *
	 * @return the uuid of this message boards suspicious activity
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this message boards suspicious activity.
	 *
	 * @param uuid the uuid of this message boards suspicious activity
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the suspicious activity ID of this message boards suspicious activity.
	 *
	 * @return the suspicious activity ID of this message boards suspicious activity
	 */
	public long getSuspiciousActivityId();

	/**
	 * Sets the suspicious activity ID of this message boards suspicious activity.
	 *
	 * @param suspiciousActivityId the suspicious activity ID of this message boards suspicious activity
	 */
	public void setSuspiciousActivityId(long suspiciousActivityId);

	/**
	 * Returns the group ID of this message boards suspicious activity.
	 *
	 * @return the group ID of this message boards suspicious activity
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this message boards suspicious activity.
	 *
	 * @param groupId the group ID of this message boards suspicious activity
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this message boards suspicious activity.
	 *
	 * @return the company ID of this message boards suspicious activity
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this message boards suspicious activity.
	 *
	 * @param companyId the company ID of this message boards suspicious activity
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this message boards suspicious activity.
	 *
	 * @return the user ID of this message boards suspicious activity
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this message boards suspicious activity.
	 *
	 * @param userId the user ID of this message boards suspicious activity
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this message boards suspicious activity.
	 *
	 * @return the user uuid of this message boards suspicious activity
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this message boards suspicious activity.
	 *
	 * @param userUuid the user uuid of this message boards suspicious activity
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this message boards suspicious activity.
	 *
	 * @return the user name of this message boards suspicious activity
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this message boards suspicious activity.
	 *
	 * @param userName the user name of this message boards suspicious activity
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this message boards suspicious activity.
	 *
	 * @return the create date of this message boards suspicious activity
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this message boards suspicious activity.
	 *
	 * @param createDate the create date of this message boards suspicious activity
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this message boards suspicious activity.
	 *
	 * @return the modified date of this message boards suspicious activity
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this message boards suspicious activity.
	 *
	 * @param modifiedDate the modified date of this message boards suspicious activity
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the message ID of this message boards suspicious activity.
	 *
	 * @return the message ID of this message boards suspicious activity
	 */
	public long getMessageId();

	/**
	 * Sets the message ID of this message boards suspicious activity.
	 *
	 * @param messageId the message ID of this message boards suspicious activity
	 */
	public void setMessageId(long messageId);

	/**
	 * Returns the thread ID of this message boards suspicious activity.
	 *
	 * @return the thread ID of this message boards suspicious activity
	 */
	public long getThreadId();

	/**
	 * Sets the thread ID of this message boards suspicious activity.
	 *
	 * @param threadId the thread ID of this message boards suspicious activity
	 */
	public void setThreadId(long threadId);

	/**
	 * Returns the reason of this message boards suspicious activity.
	 *
	 * @return the reason of this message boards suspicious activity
	 */
	@AutoEscape
	public String getReason();

	/**
	 * Sets the reason of this message boards suspicious activity.
	 *
	 * @param reason the reason of this message boards suspicious activity
	 */
	public void setReason(String reason);

	/**
	 * Returns the validated of this message boards suspicious activity.
	 *
	 * @return the validated of this message boards suspicious activity
	 */
	public boolean getValidated();

	/**
	 * Returns <code>true</code> if this message boards suspicious activity is validated.
	 *
	 * @return <code>true</code> if this message boards suspicious activity is validated; <code>false</code> otherwise
	 */
	public boolean isValidated();

	/**
	 * Sets whether this message boards suspicious activity is validated.
	 *
	 * @param validated the validated of this message boards suspicious activity
	 */
	public void setValidated(boolean validated);

	/**
	 * Returns the container model ID of this message boards suspicious activity.
	 *
	 * @return the container model ID of this message boards suspicious activity
	 */
	@Override
	public long getContainerModelId();

	/**
	 * Sets the container model ID of this message boards suspicious activity.
	 *
	 * @param containerModelId the container model ID of this message boards suspicious activity
	 */
	@Override
	public void setContainerModelId(long containerModelId);

	/**
	 * Returns the container name of this message boards suspicious activity.
	 *
	 * @return the container name of this message boards suspicious activity
	 */
	@Override
	public String getContainerModelName();

	/**
	 * Returns the parent container model ID of this message boards suspicious activity.
	 *
	 * @return the parent container model ID of this message boards suspicious activity
	 */
	@Override
	public long getParentContainerModelId();

	/**
	 * Sets the parent container model ID of this message boards suspicious activity.
	 *
	 * @param parentContainerModelId the parent container model ID of this message boards suspicious activity
	 */
	@Override
	public void setParentContainerModelId(long parentContainerModelId);

	@Override
	public MBSuspiciousActivity cloneWithOriginalValues();

}