/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.util.comparator;

import com.liferay.message.boards.model.MBThread;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;

public class ThreadLastPostDateComparator
extends OrderByComparator<MBThread> {
    public static final String ORDER_BY_ASC = "MBThread.lastPostDate ASC, MBThread.threadId ASC";
    public static final String[] ORDER_BY_CONDITION_FIELDS = new String[]{"lastPostDate"};
    public static final String ORDER_BY_DESC = "MBThread.lastPostDate DESC, MBThread.threadId DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"lastPostDate", "threadId"};
    private final boolean _ascending;

    public ThreadLastPostDateComparator() {
        this(false);
    }

    public ThreadLastPostDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(MBThread thread1, MBThread thread2) {
        int value = DateUtil.compareTo((Date)thread1.getLastPostDate(), (Date)thread2.getLastPostDate());
        if (value == 0) {
            if (thread1.getThreadId() < thread2.getThreadId()) {
                value = -1;
            } else if (thread1.getThreadId() > thread2.getThreadId()) {
                value = 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByConditionFields() {
        return ORDER_BY_CONDITION_FIELDS;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

