/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.demo.data.creator.internal;

import com.liferay.message.boards.demo.data.creator.BaseMBCategoryDemoDataCreator;
import com.liferay.message.boards.exception.NoSuchMessageException;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseMBCategoryDemoDataCreatorImpl
implements BaseMBCategoryDemoDataCreator {
    protected final List<Long> categoryIds = new CopyOnWriteArrayList<Long>();
    @Reference
    protected MBCategoryLocalService mbCategoryLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseMBCategoryDemoDataCreatorImpl.class);

    public MBCategory createCategory(long userId, long groupId, long categoryId, String name, String description) throws IOException, PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        MBCategory category = this.mbCategoryLocalService.addCategory(userId, categoryId, name, description, serviceContext);
        this.categoryIds.add(category.getCategoryId());
        return category;
    }

    public void delete() throws PortalException {
        for (long categoryId : this.categoryIds) {
            block3: {
                try {
                    this.mbCategoryLocalService.deleteCategory(categoryId);
                }
                catch (NoSuchMessageException noSuchMessageException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)noSuchMessageException);
                }
            }
            this.categoryIds.remove(categoryId);
        }
    }
}

