/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.demo.data.creator.internal;

import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.demo.data.creator.MBMessageDemoDataCreator;
import com.liferay.message.boards.exception.NoSuchMessageException;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseMBMessageDemoDataCreator
implements MBMessageDemoDataCreator {
    @Reference
    protected MBMessageLocalService mbMessageLocalService;
    protected final List<Long> messageIds = new CopyOnWriteArrayList<Long>();
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseMBMessageDemoDataCreator.class);

    public MBMessage createMessage(long userId, long groupId, long categoryId, long parentMessageId, String title, String content) throws IOException, PortalException {
        long threadId = 0L;
        if (parentMessageId != 0L) {
            MBMessage parentMessage = this.mbMessageLocalService.getMessage(parentMessageId);
            threadId = parentMessage.getThreadId();
        }
        User user = this.userLocalService.getUser(userId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        MBMessage mbMessage = this.mbMessageLocalService.addMessage(user.getUserId(), user.getFullName(), groupId, categoryId, threadId, parentMessageId, title, content, MBMessageConstants.DEFAULT_FORMAT, Collections.emptyList(), false, 0.0, false, serviceContext);
        this.messageIds.add(mbMessage.getMessageId());
        return mbMessage;
    }

    public void delete() throws PortalException {
        for (long messageId : this.messageIds) {
            block3: {
                try {
                    this.mbMessageLocalService.deleteMessage(messageId);
                }
                catch (NoSuchMessageException noSuchMessageException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)noSuchMessageException);
                }
            }
            this.messageIds.remove(messageId);
        }
    }
}

