/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.demo.data.creator.internal;

import com.liferay.message.boards.demo.data.creator.MBMessageDemoDataCreator;
import com.liferay.message.boards.demo.data.creator.internal.BaseMBMessageDemoDataCreator;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"source=lorem-ipsum"}, service={MBMessageDemoDataCreator.class})
public class LoremIpsumMBMessageDemoDataCreatorImpl
extends BaseMBMessageDemoDataCreator {
    private static final List<String> _paragraphs = LoremIpsumMBMessageDemoDataCreatorImpl._read("paragraphs");
    private static final List<String> _titles = LoremIpsumMBMessageDemoDataCreatorImpl._read("titles");
    @Reference
    private MBCategoryLocalService _mbCategoryLocalService;

    public MBMessage create(long userId, long categoryId) throws IOException, PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(categoryId);
        String title = this._getRandomElement(_titles);
        String content = this._getRandomContent();
        return this.createMessage(userId, category.getGroupId(), categoryId, 0L, title, content);
    }

    public MBMessage create(long userId, long categoryId, long parentMessageId) throws IOException, PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(categoryId);
        String title = this._getRandomElement(_titles);
        String content = this._getRandomContent();
        return this.createMessage(userId, category.getGroupId(), categoryId, parentMessageId, title, content);
    }

    private static List<String> _read(String fileName) {
        return Arrays.asList(StringUtil.split((String)StringUtil.read(LoremIpsumMBMessageDemoDataCreatorImpl.class, (String)("dependencies/lorem/ipsum/" + fileName + ".txt")), (char)'\n'));
    }

    private String _getRandomContent() {
        int count = RandomUtil.nextInt((int)5) + 3;
        StringBundler sb = new StringBundler(count * 2);
        for (int i = 0; i < count; ++i) {
            sb.append(this._getRandomElement(_paragraphs));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String _getRandomElement(List<String> list) {
        return list.get(RandomUtil.nextInt((int)list.size()));
    }
}

