/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.demo.internal;

import com.liferay.message.boards.demo.data.creator.MBCategoryDemoDataCreator;
import com.liferay.message.boards.demo.data.creator.MBThreadDemoDataCreator;
import com.liferay.message.boards.demo.data.creator.RootMBCategoryDemoDataCreator;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.users.admin.demo.data.creator.OmniAdminUserDemoDataCreator;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class MBDemo
extends BasePortalInstanceLifecycleListener {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(source=liferay)")
    private MBCategoryDemoDataCreator _mbCategoryDemoDataCreator;
    @Reference(target="(source=lorem-ipsum)")
    private MBThreadDemoDataCreator _mbThreadDemoDataCreator;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private OmniAdminUserDemoDataCreator _omniAdminUserDemoDataCreator;
    @Reference(target="(source=liferay)")
    private RootMBCategoryDemoDataCreator _rootMBCategoryDemoDataCreator;

    public void portalInstanceRegistered(Company company) throws Exception {
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (int i = 0; i < 30; ++i) {
            User user = this._omniAdminUserDemoDataCreator.create(company.getCompanyId());
            userIds.add(user.getUserId());
        }
        Group group = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
        int rootCategoriesCount = 10;
        ArrayList<MBCategory> rootCategories = new ArrayList<MBCategory>();
        for (int i = 0; i < rootCategoriesCount; ++i) {
            long userId = (Long)this._getRandomElement(userIds);
            rootCategories.add(this._rootMBCategoryDemoDataCreator.create(userId, group.getGroupId()));
        }
        ArrayList<MBCategory> firstLevelCategories = new ArrayList<MBCategory>();
        for (MBCategory rootCategory : rootCategories) {
            int firstLevelCategoriesCount = 5;
            for (int i = 0; i < firstLevelCategoriesCount; ++i) {
                long userId = (Long)this._getRandomElement(userIds);
                firstLevelCategories.add(this._mbCategoryDemoDataCreator.create(userId, rootCategory.getCategoryId()));
            }
        }
        ArrayList<MBCategory> secondLevelCategories = new ArrayList<MBCategory>();
        for (MBCategory firstLevelCategory : firstLevelCategories) {
            int secondLevelCategoriesCount = 3;
            for (int i = 0; i < secondLevelCategoriesCount; ++i) {
                long userId = (Long)this._getRandomElement(userIds);
                secondLevelCategories.add(this._mbCategoryDemoDataCreator.create(userId, firstLevelCategory.getCategoryId()));
            }
        }
        for (MBCategory firstLevelCategory : firstLevelCategories) {
            int firstLevelThreadsCount = RandomUtil.nextInt((int)2);
            for (int i = 0; i < firstLevelThreadsCount; ++i) {
                this._mbThreadDemoDataCreator.create(userIds, firstLevelCategory.getCategoryId());
            }
        }
        for (MBCategory secondLevelCategory : secondLevelCategories) {
            int secondLevelThreadsCount = RandomUtil.nextInt((int)40);
            for (int i = 0; i < secondLevelThreadsCount; ++i) {
                this._mbThreadDemoDataCreator.create(userIds, secondLevelCategory.getCategoryId());
            }
        }
    }

    @Deactivate
    protected void deactivate() throws PortalException {
        this._mbCategoryDemoDataCreator.delete();
        this._omniAdminUserDemoDataCreator.delete();
        this._rootMBCategoryDemoDataCreator.delete();
    }

    private <T> T _getRandomElement(List<T> list) {
        return list.get(RandomUtil.nextInt((int)list.size()));
    }
}

