/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.moderation.internal.instance.lifecycle;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=100"}, service={PortalInstanceLifecycleListener.class})
public class AddMBModerationWorkflowDefinitionPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private Language _language;
    @Reference
    private UserLocalService _userLocalService;
    @Reference(target="(proxy.bean=false)")
    private WorkflowDefinitionManager _workflowDefinitionManager;

    public void portalInstanceRegistered(Company company) throws Exception {
        int workflowDefinitionsCount = this._workflowDefinitionManager.getWorkflowDefinitionsCount(company.getCompanyId(), "message-boards-user-stats-moderation");
        if (workflowDefinitionsCount > 0) {
            return;
        }
        long defaultUserId = this._userLocalService.getDefaultUserId(company.getCompanyId());
        String content = StringUtil.read(AddMBModerationWorkflowDefinitionPortalInstanceLifecycleListener.class, (String)"dependencies/message-boards-moderation-workflow-definition.xml");
        this._workflowDefinitionManager.deployWorkflowDefinition(company.getCompanyId(), defaultUserId, LocalizationUtil.getXml(this._getTitleMap(company.getCompanyId()), (String)this._language.getLanguageId(company.getLocale()), (String)"title"), "message-boards-user-stats-moderation", MBMessage.class.getName(), content.getBytes());
    }

    private Map<String, String> _getTitleMap(long companyId) {
        HashMap<String, String> titleMap = new HashMap<String, String>();
        for (Locale locale : this._language.getCompanyAvailableLocales(companyId)) {
            titleMap.put(this._language.getLanguageId(locale), this._language.get(locale, "message-boards-user-stats-moderation"));
        }
        return titleMap;
    }
}

