/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.moderation.internal.instance.lifecycle;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.manager.WorkflowDefinitionManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=100"}, service={PortalInstanceLifecycleListener.class})
public class AddMBModerationWorkflowDefinitionPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowDefinitionManager _workflowDefinitionManager;

    public void portalInstanceRegistered(Company company) throws Exception {
        int workflowDefinitionsCount = this._workflowDefinitionManager.getWorkflowDefinitionsCount(company.getCompanyId(), "message-boards-user-stats-moderation");
        if (workflowDefinitionsCount > 0) {
            return;
        }
        long guestUserId = this._userLocalService.getGuestUserId(company.getCompanyId());
        String content = StringUtil.read(AddMBModerationWorkflowDefinitionPortalInstanceLifecycleListener.class, (String)"dependencies/message-boards-moderation-workflow-definition.xml");
        this._workflowDefinitionManager.deployWorkflowDefinition(company.getCompanyId(), guestUserId, this._localization.getXml(this._getTitleMap(company.getCompanyId()), this._language.getLanguageId(company.getLocale()), "title"), "message-boards-user-stats-moderation", MBMessage.class.getName(), content.getBytes());
    }

    private Map<String, String> _getTitleMap(long companyId) {
        HashMap<String, String> titleMap = new HashMap<String, String>();
        for (Locale locale : this._language.getCompanyAvailableLocales(companyId)) {
            titleMap.put(this._language.getLanguageId(locale), this._language.get(locale, "message-boards-user-stats-moderation"));
        }
        return titleMap;
    }
}

