/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.exportimport.data.handler;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class MBDiscussionStagedModelDataHandler
extends BaseStagedModelDataHandler<MBDiscussion> {
    public static final String[] CLASS_NAMES = new String[]{MBDiscussion.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(MBDiscussionStagedModelDataHandler.class);
    private AssetEntryLocalService _assetEntryLocalService;
    private MBDiscussionLocalService _mbDiscussionLocalService;
    private MBMessageLocalService _mbMessageLocalService;

    public void deleteStagedModel(MBDiscussion discussion) {
        this._mbDiscussionLocalService.deleteMBDiscussion(discussion);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        MBDiscussion discussion = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (discussion != null) {
            this.deleteStagedModel(discussion);
        }
    }

    public MBDiscussion fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._mbDiscussionLocalService.fetchMBDiscussionByUuidAndGroupId(uuid, groupId);
    }

    public List<MBDiscussion> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._mbDiscussionLocalService.getMBDiscussionsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MBDiscussion discussion) {
        try {
            AssetEntry assetEntry = this._assetEntryLocalService.getEntry(discussion.getClassName(), discussion.getClassPK());
            return assetEntry.getTitleCurrentValue();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return discussion.getUuid();
        }
    }

    public void importStagedModel(PortletDataContext portletDataContext, MBDiscussion discussion) throws PortletDataException {
        Map relatedClassPKs = portletDataContext.getNewPrimaryKeysMap(discussion.getClassName());
        if (!relatedClassPKs.containsKey(discussion.getClassPK())) {
            return;
        }
        super.importStagedModel(portletDataContext, (StagedModel)discussion);
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBDiscussion discussion) throws Exception {
        Element discussionElement = portletDataContext.getExportDataElement((ClassedModel)discussion);
        portletDataContext.addClassedModel(discussionElement, ExportImportPathUtil.getModelPath((StagedModel)discussion), (ClassedModel)discussion);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MBDiscussion discussion) throws Exception {
        String className = discussion.getClassName();
        Map relatedClassPKs = portletDataContext.getNewPrimaryKeysMap(className);
        long newClassPK = MapUtil.getLong((Map)relatedClassPKs, (long)discussion.getClassPK(), (long)discussion.getClassPK());
        MBDiscussion existingDiscussion = this._mbDiscussionLocalService.fetchDiscussion(discussion.getClassName(), newClassPK);
        if (existingDiscussion == null) {
            long userId = portletDataContext.getUserId(discussion.getUserUuid());
            MBMessage rootMessage = this._mbMessageLocalService.addDiscussionMessage(userId, discussion.getUserName(), portletDataContext.getScopeGroupId(), className, newClassPK, 1);
            rootMessage.setCreateDate(discussion.getCreateDate());
            this._mbMessageLocalService.updateMBMessage(rootMessage);
            existingDiscussion = this._mbDiscussionLocalService.getThreadDiscussion(rootMessage.getThreadId());
        }
        Map discussionIds = portletDataContext.getNewPrimaryKeysMap(MBDiscussion.class);
        discussionIds.put(discussion.getDiscussionId(), existingDiscussion.getDiscussionId());
        Map threadIds = portletDataContext.getNewPrimaryKeysMap(MBThread.class);
        threadIds.put(discussion.getThreadId(), existingDiscussion.getThreadId());
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setMBDiscussionLocalService(MBDiscussionLocalService mbDiscussionLocalService) {
        this._mbDiscussionLocalService = mbDiscussionLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }
}

