/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class MBThreadStagedModelDataHandler
extends BaseStagedModelDataHandler<MBThread> {
    public static final String[] CLASS_NAMES = new String[]{MBThread.class.getName()};
    private MBThreadLocalService _mbThreadLocalService;

    public void deleteStagedModel(MBThread thread) throws PortalException {
        this._mbThreadLocalService.deleteThread(thread);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        MBThread thread = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (thread != null) {
            this.deleteStagedModel(thread);
        }
    }

    public MBThread fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._mbThreadLocalService.fetchMBThreadByUuidAndGroupId(uuid, groupId);
    }

    public List<MBThread> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._mbThreadLocalService.getMBThreadsByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBThread thread) throws Exception {
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long threadId) throws Exception {
        MBThread existingThread = (MBThread)this.fetchMissingReference(uuid, groupId);
        if (existingThread == null) {
            return;
        }
        Map threadIds = portletDataContext.getNewPrimaryKeysMap(MBThread.class);
        threadIds.put(threadId, existingThread.getThreadId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MBThread thread) throws Exception {
    }

    @Reference(unbind="-")
    protected void setMBThreadLocalService(MBThreadLocalService mbThreadLocalService) {
        this._mbThreadLocalService = mbThreadLocalService;
    }
}

