/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.upgrade.v5_2_0;

import com.liferay.message.boards.internal.upgrade.v5_2_0.util.MBMessageTable;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class MBMessageExternalReferenceCodeUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("MBMessage", "externalReferenceCode")) {
            this.alter(MBMessageTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "externalReferenceCode", "VARCHAR(75)")});
        }
        this._populateExternalReferenceCode();
    }

    private void _populateExternalReferenceCode() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select messageId from MBMessage where externalReferenceCode is null or externalReferenceCode = ''");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update MBMessage set externalReferenceCode = ? where messageId = ?"));){
            while (resultSet.next()) {
                long messageId = resultSet.getLong(1);
                preparedStatement2.setString(1, String.valueOf(messageId));
                preparedStatement2.setLong(2, messageId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

