/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.util;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.persistence.MBMessageFinder;
import com.liferay.message.boards.service.persistence.MBMessagePersistence;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Comparator;
import java.util.List;

public class MBMessageUtil {
    public static List<MBMessage> getThreadMessages(MBMessagePersistence mbMessagePersistence, MBMessageFinder mbMessageFinder, long userId, long threadId, int status, int start, int end, Comparator<MBMessage> comparator) {
        if (status == -1) {
            OrderByComparator orderByComparator = null;
            if (comparator instanceof OrderByComparator) {
                orderByComparator = (OrderByComparator)comparator;
            }
            List messages = mbMessagePersistence.findByT_notS(threadId, 8, start, end, orderByComparator);
            if (!(comparator instanceof OrderByComparator)) {
                messages = ListUtil.sort((List)messages, comparator);
            }
            return messages;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, true, start, end, null);
        if (comparator instanceof OrderByComparator) {
            queryDefinition.setOrderByComparator((OrderByComparator)comparator);
        }
        List messages = mbMessageFinder.findByThreadId(threadId, queryDefinition);
        if (!(comparator instanceof OrderByComparator)) {
            messages = ListUtil.sort((List)messages, comparator);
        }
        return messages;
    }

    public static void updateAnswer(MBMessagePersistence mbMessagePersistence, MBMessage message, boolean answer, boolean cascade) {
        if (message.isAnswer() != answer) {
            message.setAnswer(answer);
            message = (MBMessage)mbMessagePersistence.update((BaseModel)message);
        }
        if (cascade) {
            List messages = mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
            for (MBMessage curMessage : messages) {
                MBMessageUtil.updateAnswer(mbMessagePersistence, curMessage, answer, cascade);
            }
        }
    }

    private MBMessageUtil() {
    }
}

