/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.comment.configuration.CommentGroupServiceConfiguration;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.message.boards.constants.MBCategoryConstants;
import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.exception.DiscussionMaxCommentsException;
import com.liferay.message.boards.exception.DuplicateMessageExternalReferenceCodeException;
import com.liferay.message.boards.exception.MessageBodyException;
import com.liferay.message.boards.exception.MessageSubjectException;
import com.liferay.message.boards.exception.NoSuchThreadException;
import com.liferay.message.boards.exception.RequiredMessageException;
import com.liferay.message.boards.internal.util.MBDiscussionSubcriptionSender;
import com.liferay.message.boards.internal.util.MBMailUtil;
import com.liferay.message.boards.internal.util.MBMessageUtil;
import com.liferay.message.boards.internal.util.MBSubscriptionSender;
import com.liferay.message.boards.internal.util.MailingListThreadLocal;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.impl.MBCategoryImpl;
import com.liferay.message.boards.model.impl.MBMessageDisplayImpl;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.service.base.MBMessageLocalServiceBaseImpl;
import com.liferay.message.boards.service.persistence.MBCategoryPersistence;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.message.boards.util.MBUtil;
import com.liferay.message.boards.util.comparator.MessageCreateDateComparator;
import com.liferay.message.boards.util.comparator.MessageThreadComparator;
import com.liferay.petra.portlet.url.builder.PortletURLBuilder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.EscapableLocalizableFunction;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.linkback.LinkbackProducerUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBMessage"}, service={AopService.class})
public class MBMessageLocalServiceImpl
extends MBMessageLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(MBMessageLocalServiceImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private Http _http;
    @Reference
    private MBCategoryPersistence _mbCategoryPersistence;
    @Reference
    private MBDiscussionLocalService _mbDiscussionLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBMessage addDiscussionMessage(long userId, String userName, long groupId, String className, long classPK, int workflowAction) throws PortalException {
        String subject;
        long threadId = 0L;
        long parentMessageId = 0L;
        String body = subject = String.valueOf(classPK);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setWorkflowAction(workflowAction);
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        WorkflowThreadLocal.setEnabled((boolean)false);
        try {
            MBMessage mBMessage = this.addDiscussionMessage(userId, userName, groupId, className, classPK, threadId, parentMessageId, subject, body, serviceContext);
            return mBMessage;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public MBMessage addDiscussionMessage(long userId, String userName, long groupId, String className, long classPK, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        long classNameId;
        MBDiscussion discussion;
        this.validateDiscussionMaxComments(className, classPK);
        long categoryId = -1L;
        subject = this.getDiscussionMessageSubject(subject, body);
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = Collections.emptyList();
        boolean anonymous = false;
        double priority = 0.0;
        boolean allowPingbacks = false;
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAttribute("className", (Serializable)((Object)className));
        serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(classPK)));
        Date date = new Date();
        if (serviceContext.getCreateDate() == null) {
            serviceContext.setCreateDate(date);
        }
        if (serviceContext.getModifiedDate() == null) {
            serviceContext.setModifiedDate(date);
        }
        MBMessage message = this.addMessage(userId, userName, groupId, categoryId, threadId, parentMessageId, subject, body, PropsValues.DISCUSSION_COMMENTS_FORMAT, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
        if (parentMessageId == 0L && (discussion = this._mbDiscussionLocalService.fetchDiscussion(classNameId = this.classNameLocalService.getClassNameId(className), classPK)) == null) {
            this._mbDiscussionLocalService.addDiscussion(userId, groupId, classNameId, classPK, message.getThreadId(), serviceContext);
        }
        return message;
    }

    @Deprecated
    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, long threadId, long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        return this.addMessage(null, userId, userName, groupId, categoryId, threadId, parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    @Deprecated
    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = Collections.emptyList();
        return this.addMessage(userId, userName, groupId, categoryId, 0L, 0L, subject, body, MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, false, 0.0, false, serviceContext);
    }

    @Deprecated
    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        long threadId = 0L;
        long parentMessageId = 0L;
        return this.addMessage(userId, userName, groupId, categoryId, threadId, parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    @Deprecated
    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, String subject, String body, String format, String fileName, File file, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws FileNotFoundException, PortalException {
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>(1);
        FileInputStream inputStream = new FileInputStream(file);
        ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
        inputStreamOVPs.add(inputStreamOVP);
        return this.addMessage(userId, userName, groupId, categoryId, 0L, 0L, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public MBMessage addMessage(String externalReferenceCode, long userId, String userName, long groupId, long categoryId, long threadId, long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage parentMessage;
        MBGroupServiceSettings mbGroupServiceSettings;
        MBMessage parentMBMessage = this.fetchMBMessage(parentMessageId);
        if (parentMBMessage != null && !parentMBMessage.isApproved()) {
            throw new PortalException("Parent message is not approved");
        }
        Group group = this.groupLocalService.getGroup(groupId);
        User user = this.userLocalService.fetchUser(this._portal.getValidUserId(group.getCompanyId(), userId));
        userName = user.isDefaultUser() ? userName : user.getFullName();
        subject = ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"subject", (String)subject);
        if (!MBUtil.isValidMessageFormat((String)format)) {
            format = "html";
        }
        if ((mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)groupId)) != null && !mbGroupServiceSettings.isAllowAnonymousPosting() && (anonymous || user.isDefaultUser())) {
            throw new PrincipalException.MustHavePermission(userId, new String[]{"ADD_MESSAGE"});
        }
        if (user.isDefaultUser()) {
            anonymous = true;
        }
        Date date = new Date();
        Date modifiedDate = serviceContext.getModifiedDate(date);
        long messageId = this.counterLocalService.increment();
        if (Validator.isNull((String)externalReferenceCode)) {
            externalReferenceCode = String.valueOf(messageId);
        }
        this._validateExternalReferenceCode(externalReferenceCode, groupId);
        subject = this.getSubject(subject, body);
        body = this.getBody(subject, body, format);
        body = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)userId, (String)MBMessage.class.getName(), (long)messageId, (String)("text/" + format), (String)"ALL", (String)body, (Map)HashMapBuilder.put((Object)"discussion", () -> {
            if (categoryId == -1L) {
                return true;
            }
            return false;
        }).build());
        this.validate(subject, body);
        MBMessage message = this.mbMessagePersistence.create(messageId);
        message.setUuid(serviceContext.getUuid());
        message.setExternalReferenceCode(externalReferenceCode);
        message.setGroupId(groupId);
        message.setCompanyId(user.getCompanyId());
        message.setUserId(user.getUserId());
        message.setUserName(userName);
        message.setCreateDate(serviceContext.getCreateDate(date));
        message.setModifiedDate(modifiedDate);
        if (threadId > 0L) {
            message.setThreadId(threadId);
        }
        if (priority != -1.0) {
            message.setPriority(priority);
        }
        message.setSubject(subject);
        message.setUrlSubject(this.getUniqueUrlSubject(groupId, messageId, subject));
        message.setAllowPingbacks(allowPingbacks);
        message.setStatus(2);
        message.setStatusByUserId(user.getUserId());
        message.setStatusByUserName(userName);
        message.setStatusDate(modifiedDate);
        if (parentMessageId != 0L && (parentMessage = this.mbMessagePersistence.fetchByPrimaryKey(parentMessageId)) == null) {
            parentMessageId = 0L;
        }
        MBThread thread = null;
        if (threadId > 0L) {
            thread = this.mbThreadPersistence.fetchByPrimaryKey(threadId);
        }
        if (thread == null) {
            if (parentMessageId == 0L) {
                thread = this._mbThreadLocalService.addThread(categoryId, message, serviceContext);
            } else {
                throw new NoSuchThreadException("{threadId=" + threadId + "}");
            }
        }
        if (priority != -1.0 && thread.getPriority() != priority) {
            thread.setPriority(priority);
            this._mbThreadLocalService.updateMBThread(thread);
            this.updatePriorities(thread.getThreadId(), priority);
        }
        message.setCategoryId(categoryId);
        message.setThreadId(thread.getThreadId());
        message.setRootMessageId(thread.getRootMessageId());
        message.setParentMessageId(parentMessageId);
        message.setTreePath(message.buildTreePath());
        message.setBody(body);
        message.setFormat(format);
        message.setAnonymous(anonymous);
        if (message.isDiscussion()) {
            message.setClassNameId(this.classNameLocalService.getClassNameId((String)((Object)serviceContext.getAttribute("className"))));
            message.setClassPK(ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK"));
        }
        message.setExpandoBridgeAttributes(serviceContext);
        message = (MBMessage)this.mbMessagePersistence.update((BaseModel)message);
        if (parentMessageId != 0L && GetterUtil.getBoolean((Object)serviceContext.getAttribute("propagatePermissions"))) {
            com.liferay.message.boards.internal.util.MBUtil.propagatePermissions(message.getCompanyId(), groupId, parentMessageId, serviceContext);
        }
        if (!message.isDiscussion()) {
            if (user.isDefaultUser()) {
                this.addMessageResources(message, true, true);
            } else if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
                this.addMessageResources(message, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
            } else {
                this.addMessageResources(message, serviceContext.getModelPermissions());
            }
        }
        if (ListUtil.isNotEmpty(inputStreamOVPs)) {
            Folder folder = message.addAttachmentsFolder();
            this._portletFileRepository.addPortletFileEntries(message.getGroupId(), userId, MBMessage.class.getName(), message.getMessageId(), "com.liferay.message.boards", folder.getFolderId(), inputStreamOVPs);
        }
        this.updateAsset(userId, message, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.isAssetEntryVisible());
        return this.startWorkflowInstance(userId, message, serviceContext);
    }

    public void addMessageAttachment(long userId, long messageId, String fileName, File file, String mimeType) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        Folder folder = message.addAttachmentsFolder();
        this._portletFileRepository.addPortletFileEntry(message.getGroupId(), userId, MBMessage.class.getName(), message.getMessageId(), "com.liferay.message.boards", folder.getFolderId(), file, fileName, mimeType, true);
    }

    public void addMessageResources(long messageId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.addMessageResources(message, addGroupPermissions, addGuestPermissions);
    }

    public void addMessageResources(long messageId, ModelPermissions modelPermissions) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.addMessageResources(message, modelPermissions);
    }

    public void addMessageResources(MBMessage message, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(message.getCompanyId(), message.getGroupId(), message.getUserId(), MBMessage.class.getName(), message.getMessageId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addMessageResources(MBMessage message, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(message.getCompanyId(), message.getGroupId(), message.getUserId(), MBMessage.class.getName(), message.getMessageId(), modelPermissions);
    }

    public FileEntry addTempAttachment(long groupId, long userId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)userId, (String)folderName, (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    @Indexable(type=IndexableType.DELETE)
    public MBMessage deleteDiscussionMessage(long messageId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        SocialActivityManagerUtil.deleteActivities((ClassedModel)message);
        return this.mbMessageLocalService.deleteMessage(messageId);
    }

    public void deleteDiscussionMessages(String className, long classPK) throws PortalException {
        MBDiscussion discussion = this._mbDiscussionLocalService.fetchDiscussion(this.classNameLocalService.getClassNameId(className), classPK);
        if (discussion == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Unable to delete discussion message for class name ", className, " and class PK ", classPK, " because it does not exist"}));
            }
            return;
        }
        List messages = this.mbMessagePersistence.findByT_P(discussion.getThreadId(), 0L, 0, 1);
        if (!messages.isEmpty()) {
            MBMessage message = (MBMessage)messages.get(0);
            SocialActivityManagerUtil.deleteActivities((ClassedModel)message);
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
            this._mbThreadLocalService.deleteThread(thread);
        }
        this._mbDiscussionLocalService.deleteMBDiscussion(discussion);
    }

    @Indexable(type=IndexableType.DELETE)
    public MBMessage deleteMessage(long messageId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.mbMessageLocalService.deleteMessage(message);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public MBMessage deleteMessage(MBMessage message) throws PortalException {
        int count;
        long folderId = message.getAttachmentsFolderId();
        if (folderId != 0L) {
            this._portletFileRepository.deletePortletFolder(folderId);
        }
        if ((count = this.mbMessagePersistence.countByThreadId(message.getThreadId())) == 1) {
            long threadAttachmentsFolderId = message.getThreadAttachmentsFolderId();
            if (threadAttachmentsFolderId != 0L) {
                this._portletFileRepository.deletePortletFolder(threadAttachmentsFolderId);
            }
            this._subscriptionLocalService.deleteSubscriptions(message.getCompanyId(), MBThread.class.getName(), message.getThreadId());
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
            this._mbThreadLocalService.deleteMBThread(thread);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
            indexer.delete((Object)thread);
        } else {
            List childrenMessages;
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
            if (thread.getRootMessageId() == message.getMessageId()) {
                childrenMessages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
                if (childrenMessages.size() > 1) {
                    throw new RequiredMessageException(String.valueOf(message.getMessageId()));
                }
                if (childrenMessages.size() == 1) {
                    MBMessage childMessage = (MBMessage)childrenMessages.get(0);
                    long defaultParentMessageId = 0L;
                    childMessage.setRootMessageId(childMessage.getMessageId());
                    childMessage.setParentMessageId(defaultParentMessageId);
                    childMessage.setTreePath(childMessage.buildTreePath());
                    childMessage = (MBMessage)this.mbMessagePersistence.update((BaseModel)childMessage);
                    List repliesMessages = this.mbMessagePersistence.findByThreadReplies(message.getThreadId());
                    for (MBMessage repliesMessage : repliesMessages) {
                        repliesMessage.setRootMessageId(childMessage.getMessageId());
                        this.mbMessagePersistence.update((BaseModel)repliesMessage);
                    }
                    thread.setRootMessageId(childMessage.getMessageId());
                    thread.setRootMessageUserId(childMessage.getUserId());
                    this._mbThreadLocalService.updateMBThread(thread);
                }
            } else {
                childrenMessages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
                if (!childrenMessages.isEmpty()) {
                    for (MBMessage childMessage : childrenMessages) {
                        childMessage.setParentMessageId(message.getParentMessageId());
                        childMessage.setTreePath(childMessage.buildTreePath());
                        this.mbMessagePersistence.update((BaseModel)childMessage);
                    }
                    Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
                    indexer.reindex((Collection)childrenMessages);
                } else if (message.getStatus() == 0) {
                    MessageCreateDateComparator comparator = new MessageCreateDateComparator(true);
                    MBMessage[] prevAndNextMessages = this.mbMessagePersistence.findByT_S_PrevAndNext(message.getMessageId(), thread.getThreadId(), 0, (OrderByComparator)comparator);
                    if (prevAndNextMessages[2] == null) {
                        this._mbThreadLocalService.updateLastPostDate(thread.getThreadId(), prevAndNextMessages[0].getModifiedDate());
                    }
                }
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
            indexer.reindex((Object)thread);
        }
        this.assetEntryLocalService.deleteEntry(message.getWorkflowClassName(), message.getMessageId());
        this.expandoRowLocalService.deleteRows(message.getMessageId());
        this.ratingsStatsLocalService.deleteStats(message.getWorkflowClassName(), message.getMessageId());
        if (!message.isDiscussion()) {
            this.resourceLocalService.deleteResource(message.getCompanyId(), message.getWorkflowClassName(), 4, message.getMessageId());
        }
        this.mbMessagePersistence.remove((BaseModel)message);
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(message.getCompanyId(), message.getGroupId(), message.getWorkflowClassName(), message.getMessageId());
        return message;
    }

    public void deleteMessageAttachment(long messageId, String fileName) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        this._portletFileRepository.deletePortletFileEntry(message.getGroupId(), folderId, fileName);
    }

    public void deleteMessageAttachments(long messageId) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        this._portletFileRepository.deletePortletFileEntries(message.getGroupId(), folderId);
    }

    public void deleteTempAttachment(long groupId, long userId, String folderName, String fileName) throws PortalException {
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)userId, (String)folderName, (String)fileName);
    }

    public void emptyMessageAttachments(long messageId) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        this._portletFileRepository.deletePortletFileEntries(message.getGroupId(), folderId, 8);
    }

    public MBMessage fetchFileEntryMessage(long fileEntryId) throws PortalException {
        return this.mbMessagePersistence.fetchByPrimaryKey(this._getFileEntryMessageId(fileEntryId));
    }

    public MBMessage fetchFirstMessage(long threadId, long parentMessageId) throws PortalException {
        return this.mbMessagePersistence.fetchByT_P_First(threadId, parentMessageId, null);
    }

    public MBMessage fetchMBMessageByUrlSubject(long groupId, String urlSubject) {
        return this.mbMessagePersistence.fetchByG_US(groupId, urlSubject);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_C(groupId, categoryId, start, end);
        }
        return this.mbMessagePersistence.findByG_C_S(groupId, categoryId, status, start, end);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end, OrderByComparator<MBMessage> orderByComparator) {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_C(groupId, categoryId, start, end, orderByComparator);
        }
        return this.mbMessagePersistence.findByG_C_S(groupId, categoryId, status, start, end, orderByComparator);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, long threadId) {
        return this.mbMessagePersistence.findByG_C_T(groupId, categoryId, threadId);
    }

    public int getCategoryMessagesCount(long groupId, long categoryId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByG_C(groupId, categoryId);
        }
        return this.mbMessagePersistence.countByG_C_S(groupId, categoryId, status);
    }

    public List<MBMessage> getChildMessages(long parentMessageId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.findByParentMessageId(parentMessageId);
        }
        return this.mbMessagePersistence.findByP_S(parentMessageId, status);
    }

    public List<MBMessage> getChildMessages(long parentMessageId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByParentMessageId(parentMessageId, start, end);
        }
        return this.mbMessagePersistence.findByP_S(parentMessageId, status, start, end);
    }

    public int getChildMessagesCount(long parentMessageId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByParentMessageId(parentMessageId);
        }
        return this.mbMessagePersistence.countByP_S(parentMessageId, status);
    }

    public List<MBMessage> getCompanyMessages(long companyId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByCompanyId(companyId, start, end);
        }
        return this.mbMessagePersistence.findByC_S(companyId, status, start, end);
    }

    public List<MBMessage> getCompanyMessages(long companyId, int status, int start, int end, OrderByComparator<MBMessage> orderByComparator) {
        if (status == -1) {
            return this.mbMessagePersistence.findByCompanyId(companyId, start, end, orderByComparator);
        }
        return this.mbMessagePersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public int getCompanyMessagesCount(long companyId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByCompanyId(companyId);
        }
        return this.mbMessagePersistence.countByC_S(companyId, status);
    }

    public MBMessageDisplay getDiscussionMessageDisplay(long userId, long groupId, String className, long classPK, int status) throws PortalException {
        return this.getDiscussionMessageDisplay(userId, groupId, className, classPK, status, (Comparator<MBMessage>)new MessageThreadComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBMessageDisplay getDiscussionMessageDisplay(long userId, long groupId, String className, long classPK, int status, Comparator<MBMessage> comparator) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        MBMessage message = null;
        MBDiscussion discussion = this._mbDiscussionLocalService.fetchDiscussion(classNameId, classPK);
        if (discussion != null) {
            MBThread mbThread = this.mbThreadPersistence.findByPrimaryKey(discussion.getThreadId());
            message = this.mbMessagePersistence.findByPrimaryKey(mbThread.getRootMessageId());
        } else {
            boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
            WorkflowThreadLocal.setEnabled((boolean)false);
            try {
                String subject = String.valueOf(classPK);
                message = this.mbMessageLocalService.addDiscussionMessage(userId, null, groupId, className, classPK, 0L, 0L, subject, subject, new ServiceContext());
            }
            catch (SystemException systemException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Add failed, fetch {threadId=0, parentMessageId=0}");
                }
                if ((message = this.mbMessagePersistence.fetchByT_P_First(0L, 0L, null)) == null) {
                    throw systemException;
                }
            }
            finally {
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
        }
        return this.getMessageDisplay(userId, message, status, comparator);
    }

    public int getDiscussionMessagesCount(long classNameId, long classPK, int status) {
        MBDiscussion discussion = this._mbDiscussionLocalService.fetchDiscussion(classNameId, classPK);
        if (discussion == null) {
            return 0;
        }
        int count = 0;
        count = status == -1 ? this.mbMessagePersistence.countByThreadId(discussion.getThreadId()) : this.mbMessagePersistence.countByT_S(discussion.getThreadId(), status);
        if (count >= 1) {
            return count - 1;
        }
        return 0;
    }

    public int getDiscussionMessagesCount(String className, long classPK, int status) {
        return this.getDiscussionMessagesCount(this.classNameLocalService.getClassNameId(className), classPK, status);
    }

    public List<MBDiscussion> getDiscussions(String className) {
        return this._mbDiscussionLocalService.getDiscussions(className);
    }

    public MBMessage getFileEntryMessage(long fileEntryId) throws PortalException {
        return this.mbMessagePersistence.findByPrimaryKey(this._getFileEntryMessageId(fileEntryId));
    }

    public MBMessage getFirstMessage(long threadId, long parentMessageId) throws PortalException {
        return this.mbMessagePersistence.findByT_P_First(threadId, parentMessageId, null);
    }

    public List<MBMessage> getGroupMessages(long groupId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByGroupId(groupId, start, end);
        }
        return this.mbMessagePersistence.findByG_S(groupId, status, start, end);
    }

    public List<MBMessage> getGroupMessages(long groupId, int status, int start, int end, OrderByComparator<MBMessage> orderByComparator) {
        if (status == -1) {
            return this.mbMessagePersistence.findByGroupId(groupId, start, end, orderByComparator);
        }
        return this.mbMessagePersistence.findByG_S(groupId, status, start, end, orderByComparator);
    }

    public List<MBMessage> getGroupMessages(long groupId, long userId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_U(groupId, userId, start, end);
        }
        return this.mbMessagePersistence.findByG_U_S(groupId, userId, status, start, end);
    }

    public List<MBMessage> getGroupMessages(long groupId, long userId, int status, int start, int end, OrderByComparator<MBMessage> orderByComparator) {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_U(groupId, userId, start, end, orderByComparator);
        }
        return this.mbMessagePersistence.findByG_U_S(groupId, userId, status, start, end, orderByComparator);
    }

    public int getGroupMessagesCount(long groupId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByGroupId(groupId);
        }
        return this.mbMessagePersistence.countByG_S(groupId, status);
    }

    public int getGroupMessagesCount(long groupId, long userId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByG_U(groupId, userId);
        }
        return this.mbMessagePersistence.countByG_U_S(groupId, userId, status);
    }

    public MBMessage getLastThreadMessage(long threadId, int status) throws PortalException {
        return this.mbMessagePersistence.findByT_S_Last(threadId, status, null);
    }

    public MBMessage getMessage(long messageId) throws PortalException {
        return this.mbMessagePersistence.findByPrimaryKey(messageId);
    }

    public MBMessageDisplay getMessageDisplay(long userId, long messageId, int status) throws PortalException {
        return this.getMessageDisplay(userId, this.getMessage(messageId), status);
    }

    public MBMessageDisplay getMessageDisplay(long userId, MBMessage message, int status) throws PortalException {
        return this.getMessageDisplay(userId, message, status, (Comparator<MBMessage>)new MessageThreadComparator());
    }

    public MBMessageDisplay getMessageDisplay(long userId, MBMessage message, int status, Comparator<MBMessage> comparator) throws PortalException {
        MBCategoryImpl category = null;
        if (message.getCategoryId() != 0L && message.getCategoryId() != -1L) {
            category = this._mbCategoryPersistence.findByPrimaryKey(message.getCategoryId());
        } else {
            category = new MBCategoryImpl();
            category.setCategoryId(message.getCategoryId());
            category.setDisplayStyle(MBCategoryConstants.DEFAULT_DISPLAY_STYLE);
        }
        MBMessage parentMessage = null;
        if (message.isReply()) {
            parentMessage = this.mbMessagePersistence.findByPrimaryKey(message.getParentMessageId());
        }
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        if (message.isApproved() && !message.isDiscussion()) {
            this._mbThreadLocalService.incrementViewCounter(thread.getThreadId(), 1);
            SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)thread, (int)10001, (String)"", (long)0L);
        }
        List<MBMessage> messages = null;
        messages = userId > 0L ? this.getThreadMessages(userId, message.getThreadId(), status, -1, -1, comparator) : this.getThreadMessages(message.getThreadId(), status, comparator);
        int discussionMessagesCount = 0;
        if (message.isDiscussion() && PropsValues.DISCUSSION_MAX_COMMENTS > 0) {
            discussionMessagesCount = this.getDiscussionMessagesCount(message.getClassName(), message.getClassPK(), 0);
        }
        return new MBMessageDisplayImpl(message, parentMessage, messages, category, thread, discussionMessagesCount);
    }

    public List<MBMessage> getMessages(String className, long classPK, int status) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        if (status == -1) {
            return this.mbMessagePersistence.findByC_C(classNameId, classPK);
        }
        return this.mbMessagePersistence.findByC_C_S(classNameId, classPK, status);
    }

    public int getPositionInThread(long messageId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.mbMessageFinder.countByC_T(message.getCreateDate(), message.getThreadId());
    }

    public List<MBMessage> getRootDiscussionMessages(String className, long classPK, int status) throws PortalException {
        return this.getRootDiscussionMessages(className, classPK, status, -1, -1);
    }

    public List<MBMessage> getRootDiscussionMessages(String className, long classPK, int status, int start, int end) throws PortalException {
        long rootDiscussionMessageId = this._getRootDiscussionMessageId(className, classPK);
        return this.getChildMessages(rootDiscussionMessageId, status, start, end);
    }

    public int getRootDiscussionMessagesCount(String className, long classPK, int status) {
        int count;
        block2: {
            count = 0;
            try {
                long rootDiscussionMessageId = this._getRootDiscussionMessageId(className, classPK);
                count = this.getChildMessagesCount(rootDiscussionMessageId, status);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to obtain root discussion message id for ", "class name ", className, " and class PK ", classPK}), (Throwable)portalException);
            }
        }
        return count;
    }

    public String[] getTempAttachmentNames(long groupId, long userId, String folderName) throws PortalException {
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)userId, (String)folderName);
    }

    public List<MBMessage> getThreadMessages(long threadId, int status) {
        return this.getThreadMessages(threadId, status, (Comparator<MBMessage>)new MessageThreadComparator());
    }

    public List<MBMessage> getThreadMessages(long threadId, int status, Comparator<MBMessage> comparator) {
        List messages = null;
        messages = status == -1 ? this.mbMessagePersistence.findByThreadId(threadId) : this.mbMessagePersistence.findByT_S(threadId, status);
        return ListUtil.sort((List)messages, comparator);
    }

    public List<MBMessage> getThreadMessages(long threadId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByThreadId(threadId, start, end);
        }
        return this.mbMessagePersistence.findByT_S(threadId, status, start, end);
    }

    public List<MBMessage> getThreadMessages(long threadId, long parentMessageId) {
        return this.mbMessagePersistence.findByT_P(threadId, parentMessageId);
    }

    public List<MBMessage> getThreadMessages(long userId, long threadId, int status, int start, int end, Comparator<MBMessage> comparator) {
        return MBMessageUtil.getThreadMessages(this.mbMessagePersistence, this.mbMessageFinder, userId, threadId, status, start, end, comparator);
    }

    public int getThreadMessagesCount(long threadId, boolean answer) {
        return this.mbMessagePersistence.countByT_A(threadId, answer);
    }

    public int getThreadMessagesCount(long threadId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByThreadId(threadId);
        }
        return this.mbMessagePersistence.countByT_S(threadId, status);
    }

    public List<MBMessage> getThreadRepliesMessages(long threadId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByThreadReplies(threadId, start, end);
        }
        return this.mbMessagePersistence.findByTR_S(threadId, status, start, end);
    }

    public List<MBMessage> getUserDiscussionMessages(long userId, long classNameId, long classPK, int status, int start, int end, OrderByComparator<MBMessage> orderByComparator) {
        if (status == -1) {
            return this.mbMessagePersistence.findByU_C_C(userId, classNameId, classPK, start, end, orderByComparator);
        }
        return this.mbMessagePersistence.findByU_C_C_S(userId, classNameId, classPK, status, start, end, orderByComparator);
    }

    public List<MBMessage> getUserDiscussionMessages(long userId, long[] classNameIds, int status, int start, int end, OrderByComparator<MBMessage> orderByComparator) {
        if (status == -1) {
            return this.mbMessagePersistence.findByU_C(userId, classNameIds, start, end, orderByComparator);
        }
        return this.mbMessagePersistence.findByU_C_S(userId, classNameIds, status, start, end, orderByComparator);
    }

    public List<MBMessage> getUserDiscussionMessages(long userId, String className, long classPK, int status, int start, int end, OrderByComparator<MBMessage> orderByComparator) {
        return this.getUserDiscussionMessages(userId, this.classNameLocalService.getClassNameId(className), classPK, status, start, end, orderByComparator);
    }

    public int getUserDiscussionMessagesCount(long userId, long classNameId, long classPK, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByU_C_C(userId, classNameId, classPK);
        }
        return this.mbMessagePersistence.countByU_C_C_S(userId, classNameId, classPK, status);
    }

    public int getUserDiscussionMessagesCount(long userId, long[] classNameIds, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByU_C(userId, classNameIds);
        }
        return this.mbMessagePersistence.countByU_C_S(userId, classNameIds, status);
    }

    public int getUserDiscussionMessagesCount(long userId, String className, long classPK, int status) {
        return this.getUserDiscussionMessagesCount(userId, this.classNameLocalService.getClassNameId(className), classPK, status);
    }

    public long moveMessageAttachmentToTrash(long userId, long messageId, String fileName) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        FileEntry fileEntry = this._portletFileRepository.getPortletFileEntry(message.getGroupId(), folderId, fileName);
        this._portletFileRepository.movePortletFileEntryToTrash(userId, fileEntry.getFileEntryId());
        return fileEntry.getFileEntryId();
    }

    public void restoreMessageAttachmentFromTrash(long userId, long messageId, String deletedFileName) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        Folder folder = message.addAttachmentsFolder();
        this._portletFileRepository.restorePortletFileEntryFromTrash(message.getGroupId(), userId, folder.getFolderId(), deletedFileName);
    }

    public void subscribeMessage(long userId, long messageId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this._subscriptionLocalService.addSubscription(userId, message.getGroupId(), MBThread.class.getName(), message.getThreadId());
    }

    public void unsubscribeMessage(long userId, long messageId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this._subscriptionLocalService.deleteSubscription(userId, MBThread.class.getName(), message.getThreadId());
    }

    public void updateAnswer(long messageId, boolean answer, boolean cascade) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.updateAnswer(message, answer, cascade);
    }

    public void updateAnswer(MBMessage message, boolean answer, boolean cascade) throws PortalException {
        MBMessageUtil.updateAnswer(this.mbMessagePersistence, message, answer, cascade);
    }

    public void updateAsset(long userId, MBMessage message, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        this.updateAsset(userId, message, assetCategoryIds, assetTagNames, assetLinkEntryIds, true);
    }

    public MBMessage updateDiscussionMessage(long userId, long messageId, String className, long classPK, String subject, String body, ServiceContext serviceContext) throws PortalException {
        subject = this.getDiscussionMessageSubject(subject, body);
        List inputStreamOVPs = null;
        double priority = 0.0;
        boolean allowPingbacks = false;
        serviceContext.setAttribute("className", (Serializable)((Object)className));
        serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(classPK)));
        return this.mbMessageLocalService.updateMessage(userId, messageId, subject, body, inputStreamOVPs, priority, allowPingbacks, serviceContext);
    }

    public MBMessage updateMessage(long userId, long messageId, String body, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.mbMessageLocalService.updateMessage(userId, messageId, message.getSubject(), body, null, message.getPriority(), message.isAllowPingbacks(), serviceContext);
    }

    public MBMessage updateMessage(long userId, long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this._updateMessage(userId, messageId, subject, body, priority, allowPingbacks, serviceContext);
        if (ListUtil.isNotEmpty(inputStreamOVPs)) {
            Folder folder = message.addAttachmentsFolder();
            this._portletFileRepository.addPortletFileEntries(message.getGroupId(), userId, MBMessage.class.getName(), message.getMessageId(), "com.liferay.message.boards", folder.getFolderId(), inputStreamOVPs);
        }
        return message;
    }

    public MBMessage updateStatus(long userId, long messageId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        int oldStatus = message.getStatus();
        User user = this.userLocalService.getUser(userId);
        Date modifiedDate = serviceContext.getModifiedDate(new Date());
        message.setStatus(status);
        message.setStatusByUserId(userId);
        message.setStatusByUserName(user.getFullName());
        message.setStatusDate(modifiedDate);
        message = (MBMessage)this.mbMessagePersistence.update((BaseModel)message);
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        this.updateThreadStatus(thread, message, user, oldStatus, modifiedDate);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        if (status == 0) {
            long notifySubscribersUserId = userId;
            if (oldStatus != 0) {
                notifySubscribersUserId = message.getUserId();
                if (serviceContext.isAssetEntryVisible() && (message.getClassNameId() == 0L || message.getParentMessageId() != 0L)) {
                    Date publishDate = null;
                    AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(message.getWorkflowClassName(), message.getMessageId());
                    if (assetEntry != null && assetEntry.getPublishDate() != null) {
                        publishDate = assetEntry.getPublishDate();
                    } else {
                        publishDate = modifiedDate;
                        serviceContext.setCommand("add");
                    }
                    this.assetEntryLocalService.updateEntry(message.getWorkflowClassName(), message.getMessageId(), publishDate, null, true, true);
                }
            }
            this._updateSocialActivity(user, message, serviceContext);
            this.notifySubscribers(notifySubscribersUserId, (MBMessage)message.clone(), (String)((Object)workflowContext.get("url")), serviceContext);
            indexer.reindex((Object)message);
            this.pingPingback(message, serviceContext);
        } else if (oldStatus == 0) {
            this.assetEntryLocalService.updateVisible(message.getWorkflowClassName(), message.getMessageId(), false);
            indexer.delete((Object)message);
        }
        return message;
    }

    public void updateUserName(long userId, String userName) {
        List messages = this.mbMessagePersistence.findByUserId(userId);
        for (MBMessage message : messages) {
            message.setUserName(userName);
            this.mbMessagePersistence.update((BaseModel)message);
        }
    }

    protected String getBody(String subject, String body, String format) {
        if (!Validator.isBlank((String)body)) {
            return body;
        }
        if (StringUtil.equals((String)format, (String)"html")) {
            return HtmlUtil.escape((String)subject);
        }
        return subject;
    }

    protected String getDiscussionMessageSubject(String subject, String body) throws MessageBodyException {
        if (Validator.isNotNull((String)subject)) {
            return subject;
        }
        if (Validator.isNull((String)body)) {
            throw new MessageBodyException("Body is null");
        }
        subject = HtmlUtil.extractText((String)body);
        if (subject.length() <= 50) {
            return subject;
        }
        String subjectSubstring = subject.substring(0, 50);
        return subjectSubstring + "...";
    }

    protected String getMessageURL(MBMessage message, ServiceContext serviceContext) throws PortalException {
        String entryURL = GetterUtil.getString((Object)serviceContext.getAttribute("entryURL"));
        if (Validator.isNotNull((String)entryURL)) {
            return entryURL;
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            if (Validator.isNull((String)serviceContext.getLayoutFullURL())) {
                return "";
            }
            return StringBundler.concat((Object[])new Object[]{serviceContext.getLayoutFullURL(), "/-/", "message_boards/view_message/", message.getMessageId()});
        }
        String portletId = PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        String layoutURL = this._portal.getLayoutFullURL(message.getGroupId(), portletId);
        if (Validator.isNotNull((String)layoutURL)) {
            return StringBundler.concat((Object[])new Object[]{layoutURL, "/-/", "message_boards/view_message/", message.getMessageId()});
        }
        Group group = this.groupLocalService.fetchGroup(message.getGroupId());
        portletId = PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
        return PortletURLBuilder.create((PortletURL)this._portal.getControlPanelPortletURL(httpServletRequest, group, portletId, 0L, 0L, "RENDER_PHASE")).setMVCRenderCommandName("/message_boards/view_message").setParameter("messageId", (Object)message.getMessageId()).buildString();
    }

    protected String getSubject(String subject, String body) {
        if (Validator.isNull((String)subject)) {
            return StringUtil.shorten((String)body);
        }
        return subject;
    }

    protected MBSubscriptionSender getSubscriptionSender(long userId, MBCategory category, MBMessage message, String messageURL, String entryTitle, boolean htmlFormat, String messageBody, String messageSubject, String messageSubjectPrefix, String inReplyTo, String fromName, String fromAddress, String replyToAddress, String emailAddress, String fullName, LocalizedValuesMap subjectLocalizedValuesMap, LocalizedValuesMap bodyLocalizedValuesMap, ServiceContext serviceContext) throws PortalException {
        MBSubscriptionSender subscriptionSender = new MBSubscriptionSender("com.liferay.message.boards");
        subscriptionSender.setAnonymous(message.isAnonymous());
        subscriptionSender.setBulk(PropsValues.MESSAGE_BOARDS_EMAIL_BULK);
        subscriptionSender.setClassName(message.getModelClassName());
        subscriptionSender.setClassPK(message.getMessageId());
        subscriptionSender.setCompanyId(message.getCompanyId());
        subscriptionSender.setContextAttribute("[$MESSAGE_BODY$]", messageBody, false);
        long groupId = message.getGroupId();
        Group group = this.groupLocalService.getGroup(groupId);
        if (category.getCategoryId() != 0L) {
            subscriptionSender.setContextAttribute("[$CATEGORY_NAME$]", category.getName(), true);
        } else {
            subscriptionSender.setLocalizedContextAttribute("[$CATEGORY_NAME$]", new EscapableLocalizableFunction(locale -> this._getLocalizedRootCategoryName(group, (Locale)locale)));
        }
        subscriptionSender.setContextAttributes(new Object[]{"[$MAILING_LIST_ADDRESS$]", replyToAddress, "[$MESSAGE_ID$]", message.getMessageId(), "[$MESSAGE_SUBJECT$]", messageSubject, "[$MESSAGE_SUBJECT_PREFIX$]", messageSubjectPrefix, "[$MESSAGE_URL$]", messageURL, "[$MESSAGE_USER_ADDRESS$]", emailAddress, "[$MESSAGE_USER_NAME$]", fullName});
        subscriptionSender.setCreatorUserId(message.getUserId());
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(entryTitle);
        subscriptionSender.setEntryURL(messageURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setFullName(fullName);
        subscriptionSender.setHtmlFormat(htmlFormat);
        subscriptionSender.setInReplyTo(inReplyTo);
        subscriptionSender.setLocalizedContextAttribute("[$SITE_NAME$]", new EscapableLocalizableFunction(locale -> this._getGroupDescriptiveName(group, (Locale)locale)));
        if (bodyLocalizedValuesMap != null) {
            subscriptionSender.setLocalizedBodyMap(LocalizationUtil.getMap((LocalizedValuesMap)bodyLocalizedValuesMap));
        }
        if (subjectLocalizedValuesMap != null) {
            subscriptionSender.setLocalizedSubjectMap(LocalizationUtil.getMap((LocalizedValuesMap)subjectLocalizedValuesMap));
        }
        Date modifiedDate = message.getModifiedDate();
        subscriptionSender.setMailId("mb_message.", new Object[]{message.getCategoryId(), message.getMessageId(), modifiedDate.getTime()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        String portletId = PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setReplyToAddress(replyToAddress);
        subscriptionSender.setScopeGroupId(groupId);
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUniqueMailId(false);
        return subscriptionSender;
    }

    protected String getUniqueUrlSubject(long groupId, long mbMessageId, String subject) {
        String urlSubject;
        String uniqueUrlSubject = urlSubject = this._getUrlSubject(mbMessageId, subject);
        MBMessage mbMessage = this.mbMessagePersistence.fetchByG_US(groupId, uniqueUrlSubject);
        int i = 1;
        while (mbMessage != null) {
            uniqueUrlSubject = urlSubject + "-" + i;
            mbMessage = this.mbMessagePersistence.fetchByG_US(groupId, uniqueUrlSubject);
            ++i;
        }
        return uniqueUrlSubject;
    }

    protected void notifyDiscussionSubscribers(long userId, MBMessage message, ServiceContext serviceContext) throws PortalException {
        CommentGroupServiceConfiguration commentGroupServiceConfiguration = this._getCommentGroupServiceConfiguration(message.getGroupId());
        MBDiscussion mbDiscussion = this._mbDiscussionLocalService.getThreadDiscussion(message.getThreadId());
        String contentURL = (String)((Object)serviceContext.getAttribute("contentURL"));
        contentURL = this._http.addParameter(contentURL, serviceContext.getAttribute("namespace") + "messageId", message.getMessageId());
        String userAddress = "";
        String userName = (String)((Object)serviceContext.getAttribute("pingbackUserName"));
        if (Validator.isNull((String)userName)) {
            userAddress = this._portal.getUserEmailAddress(message.getUserId());
            userName = this._portal.getUserName(message.getUserId(), "");
        }
        MBDiscussionSubcriptionSender subscriptionSender = new MBDiscussionSubcriptionSender(commentGroupServiceConfiguration);
        subscriptionSender.setCompanyId(message.getCompanyId());
        subscriptionSender.setClassName(MBDiscussion.class.getName());
        subscriptionSender.setClassPK(mbDiscussion.getDiscussionId());
        subscriptionSender.setContextAttribute("[$COMMENTS_BODY$]", message.getBody(message.isFormatBBCode()), false);
        subscriptionSender.setContextAttributes(new Object[]{"[$COMMENTS_USER_ADDRESS$]", userAddress, "[$COMMENTS_USER_NAME$]", userName, "[$CONTENT_URL$]", contentURL});
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(message.getBody());
        subscriptionSender.setEntryURL(contentURL);
        subscriptionSender.setFrom(commentGroupServiceConfiguration.emailFromAddress(), commentGroupServiceConfiguration.emailFromName());
        subscriptionSender.setHtmlFormat(true);
        Map localizedBodyMap = null;
        Map localizedSubjectMap = null;
        if (serviceContext.isCommandUpdate()) {
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)commentGroupServiceConfiguration.discussionEmailUpdatedBody());
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)commentGroupServiceConfiguration.discussionEmailUpdatedSubject());
        } else {
            localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)commentGroupServiceConfiguration.discussionEmailBody());
            localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)commentGroupServiceConfiguration.discussionEmailSubject());
        }
        if (localizedBodyMap != null) {
            subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        }
        if (localizedSubjectMap != null) {
            subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        }
        Date modifiedDate = message.getModifiedDate();
        subscriptionSender.setMailId("mb_discussion", new Object[]{message.getCategoryId(), message.getMessageId(), modifiedDate.getTime()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        String portletId = PortletProviderUtil.getPortletId((String)Comment.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setScopeGroupId(message.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUniqueMailId(false);
        String className = (String)((Object)serviceContext.getAttribute("className"));
        long classPK = ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK");
        subscriptionSender.addPersistedSubscribers(MBUtil.getSubscriptionClassName((String)className), classPK);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void notifySubscribers(long userId, MBMessage message, String messageURL, ServiceContext serviceContext) throws PortalException {
        long categoryId;
        if (!message.isApproved() || Validator.isNull((String)messageURL)) {
            return;
        }
        if (message.isDiscussion()) {
            try {
                this.notifyDiscussionSubscribers(userId, message, serviceContext);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
            return;
        }
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)message.getGroupId());
        if (!(serviceContext.isCommandAdd() && mbGroupServiceSettings.isEmailMessageAddedEnabled() || serviceContext.isCommandUpdate() && mbGroupServiceSettings.isEmailMessageUpdatedEnabled())) {
            return;
        }
        Company company = this.companyLocalService.getCompany(message.getCompanyId());
        User user = this.userLocalService.getUser(userId);
        String emailAddress = user.getEmailAddress();
        String fullName = user.getFullName();
        if (message.isAnonymous()) {
            emailAddress = "";
            fullName = serviceContext.translate("anonymous", new Object[0]);
        }
        MBCategory category = message.getCategory();
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        categoryIds.add(message.getCategoryId());
        if (message.getCategoryId() != 0L) {
            categoryIds.addAll(category.getAncestorCategoryIds());
        }
        String entryTitle = message.getSubject();
        String fromName = mbGroupServiceSettings.getEmailFromName();
        String fromAddress = mbGroupServiceSettings.getEmailFromAddress();
        String replyToAddress = "";
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            replyToAddress = MBMailUtil.getReplyToAddress(message.getCategoryId(), message.getMessageId(), company.getMx(), fromAddress);
        }
        LocalizedValuesMap subjectLocalizedValuesMap = null;
        LocalizedValuesMap bodyLocalizedValuesMap = null;
        if (serviceContext.isCommandUpdate()) {
            subjectLocalizedValuesMap = mbGroupServiceSettings.getEmailMessageUpdatedSubject();
            bodyLocalizedValuesMap = mbGroupServiceSettings.getEmailMessageUpdatedBody();
        } else {
            subjectLocalizedValuesMap = mbGroupServiceSettings.getEmailMessageAddedSubject();
            bodyLocalizedValuesMap = mbGroupServiceSettings.getEmailMessageAddedBody();
        }
        boolean htmlFormat = mbGroupServiceSettings.isEmailHtmlFormat();
        String messageBody = message.getBody();
        if (htmlFormat && message.isFormatBBCode()) {
            try {
                messageBody = BBCodeTranslatorUtil.getHTML((String)messageBody);
                HttpServletRequest httpServletRequest = serviceContext.getRequest();
                if (httpServletRequest != null) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    messageBody = com.liferay.message.boards.internal.util.MBUtil.replaceMessageBodyPaths(themeDisplay, messageBody);
                }
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to parse message ", message.getMessageId(), ": ", exception.getMessage()}));
            }
        }
        String inReplyTo = null;
        String messageSubject = message.getSubject();
        String messageSubjectPrefix = "";
        if (message.getParentMessageId() != 0L) {
            MBMessage parentMessage = this.mbMessageLocalService.getMessage(message.getParentMessageId());
            Date modifiedDate = parentMessage.getModifiedDate();
            inReplyTo = this._portal.getMailId(company.getMx(), "mb_message.", new Object[]{message.getCategoryId(), parentMessage.getMessageId(), modifiedDate.getTime()});
            if (messageSubject.startsWith("RE: ")) {
                messageSubjectPrefix = "RE: ";
                messageSubject = messageSubject.substring(messageSubjectPrefix.length());
            }
        }
        MBSubscriptionSender subscriptionSender = this.getSubscriptionSender(userId, category, message, messageURL, entryTitle, htmlFormat, messageBody, messageSubject, messageSubjectPrefix, inReplyTo, fromName, fromAddress, replyToAddress, emailAddress, fullName, subjectLocalizedValuesMap, bodyLocalizedValuesMap, serviceContext);
        subscriptionSender.addPersistedSubscribers(MBCategory.class.getName(), message.getGroupId());
        Iterator iterator = categoryIds.iterator();
        while (iterator.hasNext()) {
            categoryId = (Long)iterator.next();
            if (categoryId == 0L) continue;
            subscriptionSender.addPersistedSubscribers(MBCategory.class.getName(), categoryId);
        }
        subscriptionSender.addPersistedSubscribers(MBThread.class.getName(), message.getThreadId());
        subscriptionSender.flushNotificationsAsync();
        if (!MailingListThreadLocal.isSourceMailingList()) {
            iterator = categoryIds.iterator();
            while (iterator.hasNext()) {
                categoryId = (Long)iterator.next();
                MBSubscriptionSender sourceMailingListSubscriptionSender = this.getSubscriptionSender(userId, category, message, messageURL, entryTitle, htmlFormat, messageBody, messageSubject, messageSubjectPrefix, inReplyTo, fromName, fromAddress, replyToAddress, emailAddress, fullName, subjectLocalizedValuesMap, bodyLocalizedValuesMap, serviceContext);
                sourceMailingListSubscriptionSender.setBulk(false);
                sourceMailingListSubscriptionSender.addMailingListSubscriber(message.getGroupId(), categoryId);
                sourceMailingListSubscriptionSender.flushNotificationsAsync();
            }
        }
    }

    protected void pingPingback(MBMessage message, ServiceContext serviceContext) {
        if (!(PropsValues.BLOGS_PINGBACK_ENABLED && message.isAllowPingbacks() && message.isApproved())) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        String sourceUri = StringBundler.concat((Object[])new Object[]{layoutFullURL, "/-/", "message_boards/view_message/", message.getMessageId()});
        Source source = new Source((CharSequence)message.getBody(message.isFormatBBCode()));
        List startTags = source.getAllStartTags("a");
        for (StartTag startTag : startTags) {
            String targetUri = startTag.getAttributeValue("href");
            if (!Validator.isNotNull((String)targetUri)) continue;
            try {
                LinkbackProducerUtil.sendPingback((String)sourceUri, (String)targetUri);
            }
            catch (Exception exception) {
                _log.error((Object)("Error while sending pingback " + targetUri), (Throwable)exception);
            }
        }
    }

    protected MBMessage startWorkflowInstance(long userId, MBMessage message, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = HashMapBuilder.put((Object)"url", (Object)this.getMessageURL(message, serviceContext)).build();
        return (MBMessage)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)message.getCompanyId(), (long)message.getGroupId(), (long)userId, (String)message.getWorkflowClassName(), (long)message.getMessageId(), (Object)message, (ServiceContext)serviceContext, (Map)workflowContext);
    }

    protected void updateAsset(long userId, MBMessage message, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, boolean assetEntryVisible) throws PortalException {
        boolean visible = false;
        Date publishDate = null;
        if (assetEntryVisible && message.isApproved() && (message.getClassNameId() == 0L || message.getParentMessageId() != 0L)) {
            visible = true;
            publishDate = message.getModifiedDate();
        }
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, message.getGroupId(), message.getCreateDate(), message.getModifiedDate(), message.getWorkflowClassName(), message.getMessageId(), message.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, publishDate, null, "text/html", message.getSubject(), null, null, null, null, 0, 0, Double.valueOf(message.getPriority()));
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    protected void updatePriorities(long threadId, double priority) {
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            if (message.getPriority() == priority) continue;
            message.setPriority(priority);
            this.mbMessagePersistence.update((BaseModel)message);
        }
    }

    protected MBThread updateThreadStatus(MBThread thread, MBMessage message, User user, int oldStatus, Date modifiedDate) throws PortalException {
        int status = message.getStatus();
        if (status == oldStatus) {
            return thread;
        }
        if (thread.getRootMessageId() == message.getMessageId()) {
            thread.setModifiedDate(modifiedDate);
            thread.setStatus(status);
            thread.setStatusByUserId(user.getUserId());
            thread.setStatusByUserName(user.getFullName());
            thread.setStatusDate(modifiedDate);
            if (status == 0) {
                if (message.isAnonymous()) {
                    thread.setLastPostByUserId(0L);
                } else {
                    thread.setLastPostByUserId(message.getUserId());
                }
                thread.setLastPostDate(modifiedDate);
            }
            thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
            indexer.reindex((Object)thread);
        } else if (status == 0) {
            this._mbThreadLocalService.updateLastPostDate(thread.getThreadId(), modifiedDate);
        }
        return thread;
    }

    protected void validate(String subject, String body) throws PortalException {
        if (Validator.isNull((String)subject) && Validator.isNull((String)body)) {
            throw new MessageSubjectException("Subject and body are null");
        }
    }

    protected void validateDiscussionMaxComments(String className, long classPK) throws PortalException {
        if (PropsValues.DISCUSSION_MAX_COMMENTS <= 0) {
            return;
        }
        int count = this.mbMessageLocalService.getDiscussionMessagesCount(className, classPK, 0);
        if (count >= PropsValues.DISCUSSION_MAX_COMMENTS) {
            int max = PropsValues.DISCUSSION_MAX_COMMENTS - 1;
            throw new DiscussionMaxCommentsException(count + " exceeds " + max);
        }
    }

    private CommentGroupServiceConfiguration _getCommentGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (CommentGroupServiceConfiguration)this._configurationProvider.getConfiguration(CommentGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.comment"));
    }

    private long _getFileEntryMessageId(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
        if (dlFileEntry != null) {
            DLFolder dlFolder = dlFileEntry.getFolder();
            return GetterUtil.getLong((String)dlFolder.getName());
        }
        FileEntry fileEntry = this._portletFileRepository.getPortletFileEntry(fileEntryId);
        Folder folder = this._portletFileRepository.getPortletFolder(fileEntry.getFolderId());
        return GetterUtil.getLong((String)folder.getName());
    }

    private String _getGroupDescriptiveName(Group group, Locale locale) {
        try {
            return group.getDescriptiveName(locale);
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get descriptive name for group " + group.getGroupId()), (Throwable)portalException);
            return "";
        }
    }

    private String _getLocalizedRootCategoryName(Group group, Locale locale) {
        try {
            return LanguageUtil.get((Locale)locale, (String)"home") + " - " + group.getDescriptiveName(locale);
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to get descriptive name for group " + group.getGroupId()), (Throwable)portalException);
            return LanguageUtil.get((Locale)locale, (String)"home");
        }
    }

    private long _getRootDiscussionMessageId(String className, long classPK) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByC_C_First(this.classNameLocalService.getClassNameId(className), classPK, (OrderByComparator)new MessageCreateDateComparator(true));
        return message.getMessageId();
    }

    private String _getUrlSubject(long id, String subject) {
        if (subject == null) {
            return String.valueOf(id);
        }
        subject = Validator.isNull((String)(subject = StringUtil.toLowerCase((String)subject.trim()))) || Validator.isNumber((String)subject) || subject.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)subject);
        return ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"urlSubject", (String)subject);
    }

    private MBMessage _updateMessage(long userId, long messageId, String subject, String body, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        int oldStatus = message.getStatus();
        String oldSubject = message.getSubject();
        Date modifiedDate = serviceContext.getModifiedDate(null);
        subject = ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"subject", (String)subject);
        subject = this.getSubject(subject, body);
        body = this.getBody(subject, body, message.getFormat());
        body = SanitizerUtil.sanitize((long)message.getCompanyId(), (long)message.getGroupId(), (long)userId, (String)MBMessage.class.getName(), (long)messageId, (String)("text/" + message.getFormat()), (String)"ALL", (String)body, (Map)HashMapBuilder.put((Object)"discussion", (Object)message.isDiscussion()).build());
        this.validate(subject, body);
        message.setModifiedDate(modifiedDate);
        message.setSubject(subject);
        message.setBody(body);
        message.setAllowPingbacks(allowPingbacks);
        if (priority != -1.0) {
            message.setPriority(priority);
        }
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        if (serviceContext.getWorkflowAction() == 2 && !message.isDraft() && !message.isPending()) {
            message.setStatus(2);
            thread = this.updateThreadStatus(thread, message, this.userLocalService.getUser(userId), oldStatus, modifiedDate);
            this.assetEntryLocalService.updateVisible(message.getWorkflowClassName(), message.getMessageId(), false);
            if (!message.isDiscussion()) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
                indexer.delete((Object)message);
            }
        }
        message.setExpandoBridgeAttributes(serviceContext);
        message = (MBMessage)this.mbMessagePersistence.update((BaseModel)message);
        if (priority != -1.0 && thread.getPriority() != priority) {
            thread.setPriority(priority);
            thread = this._mbThreadLocalService.updateMBThread(thread);
            this.updatePriorities(thread.getThreadId(), priority);
        }
        if (message.isRoot()) {
            if (!Objects.equals(subject, oldSubject)) {
                thread.setTitle(subject);
            }
            this._mbThreadLocalService.updateMBThread(thread);
        }
        this.updateAsset(userId, message, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        return this.startWorkflowInstance(userId, message, serviceContext);
    }

    private void _updateSocialActivity(User user, MBMessage message, ServiceContext serviceContext) throws PortalException {
        long classPK;
        String className;
        AssetEntry assetEntry;
        long parentMessageId;
        String title = message.getSubject();
        if (message.isDiscussion()) {
            title = HtmlUtil.stripHtml((String)title);
        }
        JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)title);
        if (!message.isDiscussion()) {
            if (!message.isAnonymous() && !user.isDefaultUser()) {
                long receiverUserId = 0L;
                MBMessage parentMessage = this.mbMessagePersistence.fetchByPrimaryKey(message.getParentMessageId());
                if (parentMessage != null) {
                    receiverUserId = parentMessage.getUserId();
                }
                int activityKey = 3;
                if (serviceContext.isCommandAdd()) {
                    activityKey = 1;
                }
                SocialActivityManagerUtil.addActivity((long)message.getUserId(), (ClassedModel)message, (int)activityKey, (String)extraDataJSONObject.toString(), (long)receiverUserId);
                if (parentMessage != null && receiverUserId != message.getUserId()) {
                    SocialActivityManagerUtil.addActivity((long)message.getUserId(), (ClassedModel)parentMessage, (int)2, (String)extraDataJSONObject.toString(), (long)0L);
                }
            }
        } else if (serviceContext.isCommandAdd() && (parentMessageId = message.getParentMessageId()) != 0L && (assetEntry = this.assetEntryLocalService.fetchEntry(className = (String)((Object)serviceContext.getAttribute("className")), classPK = ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK"))) != null) {
            extraDataJSONObject.put("messageId", message.getMessageId());
            SocialActivityManagerUtil.addActivity((long)message.getUserId(), (ClassedModel)assetEntry, (int)10005, (String)extraDataJSONObject.toString(), (long)assetEntry.getUserId());
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.fetchByG_ERC(groupId, externalReferenceCode);
        if (message != null) {
            throw new DuplicateMessageExternalReferenceCodeException(StringBundler.concat((Object[])new Object[]{"Duplicate message external reference code ", externalReferenceCode, " in group ", groupId}));
        }
    }
}

