/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.message.boards.exception.SplitThreadException;
import com.liferay.message.boards.internal.util.MBMessageUtil;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.impl.MBTreeWalkerImpl;
import com.liferay.message.boards.service.base.MBThreadLocalServiceBaseImpl;
import com.liferay.message.boards.service.persistence.MBCategoryPersistence;
import com.liferay.message.boards.util.comparator.MessageThreadComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.DateOverrideIncrement;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ExceptionRetryAcceptor;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.view.count.ViewCountManager;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBThread"}, service={AopService.class})
public class MBThreadLocalServiceImpl
extends MBThreadLocalServiceBaseImpl {
    @Reference
    protected ExpandoRowLocalService expandoRowLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private MBCategoryPersistence _mbCategoryPersistence;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;
    @Reference
    private ViewCountManager _viewCountManager;

    public MBThread addThread(long categoryId, MBMessage message, ServiceContext serviceContext) throws PortalException {
        long threadId = message.getThreadId();
        if (!message.isRoot() || threadId <= 0L) {
            threadId = this.counterLocalService.increment();
        }
        MBThread thread = this.mbThreadPersistence.create(threadId);
        thread.setUuid(serviceContext.getUuid());
        thread.setGroupId(message.getGroupId());
        thread.setCompanyId(message.getCompanyId());
        thread.setUserId(message.getUserId());
        thread.setUserName(message.getUserName());
        thread.setCategoryId(categoryId);
        thread.setRootMessageId(message.getMessageId());
        thread.setRootMessageUserId(message.getUserId());
        thread.setTitle(message.getSubject());
        if (message.isAnonymous()) {
            thread.setLastPostByUserId(0L);
        } else {
            thread.setLastPostByUserId(message.getUserId());
        }
        thread.setLastPostDate(message.getModifiedDate());
        if (message.getPriority() != -1.0) {
            thread.setPriority(message.getPriority());
        }
        thread.setStatus(message.getStatus());
        thread.setStatusByUserId(message.getStatusByUserId());
        thread.setStatusByUserName(message.getStatusByUserName());
        thread.setStatusDate(message.getStatusDate());
        thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
        if (categoryId >= 0L) {
            this.assetEntryLocalService.updateEntry(message.getUserId(), message.getGroupId(), thread.getStatusDate(), thread.getLastPostDate(), MBThread.class.getName(), thread.getThreadId(), thread.getUuid(), 0L, new long[0], new String[0], true, false, null, null, thread.getStatusDate(), null, null, String.valueOf(thread.getRootMessageId()), null, null, null, null, 0, 0, Double.valueOf(serviceContext.getAssetPriority()));
        }
        return thread;
    }

    public void deleteThread(long threadId) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        this.mbThreadLocalService.deleteThread(thread);
    }

    @SystemEvent(action=1, type=1)
    public void deleteThread(MBThread thread) throws PortalException {
        MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
        Indexer messageIndexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        long folderId = thread.getAttachmentsFolderId();
        if (folderId != 0L) {
            PortletFileRepositoryUtil.deletePortletFolder((long)folderId);
        }
        this._subscriptionLocalService.deleteSubscriptions(thread.getCompanyId(), MBThread.class.getName(), thread.getThreadId());
        List messages = this.mbMessagePersistence.findByThreadId(thread.getThreadId());
        for (MBMessage message : messages) {
            this.ratingsStatsLocalService.deleteStats(message.getWorkflowClassName(), message.getMessageId());
            this.assetEntryLocalService.deleteEntry(message.getWorkflowClassName(), message.getMessageId());
            this.expandoRowLocalService.deleteRows(message.getMessageId());
            if (!message.isDiscussion()) {
                this.resourceLocalService.deleteResource(message.getCompanyId(), message.getWorkflowClassName(), 4, message.getMessageId());
            }
            this.mbMessagePersistence.remove((BaseModel)message);
            messageIndexer.delete((Object)message);
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(message.getCompanyId(), message.getGroupId(), message.getWorkflowClassName(), message.getMessageId());
        }
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(MBThread.class.getName(), thread.getThreadId());
        if (assetEntry != null) {
            assetEntry.setTitle(rootMessage.getSubject());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
        this.assetEntryLocalService.deleteEntry(MBThread.class.getName(), thread.getThreadId());
        this._viewCountManager.deleteViewCount(thread.getCompanyId(), this._classNameLocalService.getClassNameId(MBThread.class), thread.getThreadId());
        Indexer threadIndexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        threadIndexer.delete((Object)thread);
        this.mbThreadPersistence.remove((BaseModel)thread);
    }

    public void deleteThreads(long groupId, long categoryId) throws PortalException {
        this.mbThreadLocalService.deleteThreads(groupId, categoryId, true);
    }

    public void deleteThreads(long groupId, long categoryId, boolean includeTrashedEntries) throws PortalException {
        List threads = this.mbThreadPersistence.findByG_C(groupId, categoryId);
        for (MBThread thread : threads) {
            if (!includeTrashedEntries && thread.isInTrashExplicitly()) continue;
            this.mbThreadLocalService.deleteThread(thread);
        }
        if (this.mbThreadPersistence.countByGroupId(groupId) == 0) {
            PortletFileRepositoryUtil.deletePortletRepository((long)groupId, (String)"com.liferay.message.boards");
        }
    }

    public MBThread fetchThread(long threadId) {
        return this.mbThreadPersistence.fetchByPrimaryKey(threadId);
    }

    public int getCategoryThreadsCount(long groupId, long categoryId, int status) {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_C(groupId, categoryId);
        }
        return this.mbThreadPersistence.countByG_C_S(groupId, categoryId, status);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, boolean subscribed, boolean includeAnonymous, QueryDefinition<MBThread> queryDefinition) {
        if (userId <= 0L) {
            return this.getGroupThreads(groupId, queryDefinition);
        }
        if (subscribed) {
            return this.mbThreadFinder.findByS_G_U_C(groupId, userId, null, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.findByG_U_C(groupId, userId, null, queryDefinition);
        }
        return this.mbThreadFinder.findByG_U_C_A(groupId, userId, null, false, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, boolean subscribed, QueryDefinition<MBThread> queryDefinition) {
        return this.getGroupThreads(groupId, userId, subscribed, true, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, QueryDefinition<MBThread> queryDefinition) {
        return this.getGroupThreads(groupId, userId, false, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, QueryDefinition<MBThread> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.mbThreadPersistence.findByG_NotC_NotS(groupId, -1L, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd());
        }
        return this.mbThreadPersistence.findByG_NotC_S(groupId, -1L, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd());
    }

    public int getGroupThreadsCount(long groupId, long userId, boolean subscribed, boolean includeAnonymous, QueryDefinition<MBThread> queryDefinition) {
        if (userId <= 0L) {
            return this.getGroupThreadsCount(groupId, queryDefinition);
        }
        if (subscribed) {
            return this.mbThreadFinder.countByS_G_U_C(groupId, userId, null, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.countByG_U_C(groupId, userId, null, queryDefinition);
        }
        return this.mbThreadFinder.countByG_U_C_A(groupId, userId, null, false, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, long userId, boolean subscribed, QueryDefinition<MBThread> queryDefinition) {
        return this.getGroupThreadsCount(groupId, userId, subscribed, true, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, long userId, QueryDefinition<MBThread> queryDefinition) {
        return this.getGroupThreadsCount(groupId, userId, false, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, QueryDefinition<MBThread> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.mbThreadPersistence.countByG_NotC_NotS(groupId, -1L, queryDefinition.getStatus());
        }
        return this.mbThreadPersistence.countByG_NotC_S(groupId, -1L, queryDefinition.getStatus());
    }

    public int getMessageCount(long threadId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByThreadId(threadId);
        }
        return this.mbMessagePersistence.countByT_S(threadId, status);
    }

    public List<MBThread> getPriorityThreads(long categoryId, double priority) throws PortalException {
        return this.getPriorityThreads(categoryId, priority, false);
    }

    public List<MBThread> getPriorityThreads(long categoryId, double priority, boolean inherit) throws PortalException {
        if (!inherit) {
            return this.mbThreadPersistence.findByC_P(categoryId, priority);
        }
        ArrayList<MBThread> threads = new ArrayList<MBThread>();
        while (categoryId != 0L && categoryId != -1L) {
            threads.addAll(0, this.mbThreadPersistence.findByC_P(categoryId, priority));
            MBCategory category = this._mbCategoryPersistence.findByPrimaryKey(categoryId);
            categoryId = category.getParentCategoryId();
        }
        return threads;
    }

    public MBThread getThread(long threadId) throws PortalException {
        return this.mbThreadPersistence.findByPrimaryKey(threadId);
    }

    public List<MBThread> getThreads(long groupId, long categoryId, int status, int start, int end) {
        if (status == -1) {
            return this.mbThreadPersistence.findByG_C(groupId, categoryId, start, end);
        }
        return this.mbThreadPersistence.findByG_C_S(groupId, categoryId, status, start, end);
    }

    public int getThreadsCount(long groupId, long categoryId, int status) {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_C(groupId, categoryId);
        }
        return this.mbThreadPersistence.countByG_C_S(groupId, categoryId, status);
    }

    public boolean hasAnswerMessage(long threadId) {
        int count = this.mbMessagePersistence.countByT_A(threadId, true);
        return count > 0;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void incrementViewCounter(long threadId, int increment) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        MBThread thread = this.mbThreadPersistence.fetchByPrimaryKey(threadId);
        if (thread == null) {
            return;
        }
        this._viewCountManager.incrementViewCount(thread.getCompanyId(), this._classNameLocalService.getClassNameId(MBThread.class), thread.getThreadId(), increment);
    }

    public void moveDependentsToTrash(long groupId, long threadId, long trashEntryId) throws PortalException {
        HashSet<Long> userIds = new HashSet<Long>();
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            if (message.isDiscussion()) continue;
            int oldStatus = message.getStatus();
            message.setStatus(8);
            message = (MBMessage)this.mbMessagePersistence.update((BaseModel)message);
            userIds.add(message.getUserId());
            int status = oldStatus;
            if (oldStatus == 1) {
                status = 2;
            }
            if (oldStatus != 0) {
                this._trashVersionLocalService.addTrashVersion(trashEntryId, MBMessage.class.getName(), message.getMessageId(), status, null);
            }
            if (oldStatus == 0) {
                this.assetEntryLocalService.updateVisible(MBMessage.class.getName(), message.getMessageId(), false);
            }
            for (FileEntry fileEntry : message.getAttachmentsFileEntries()) {
                PortletFileRepositoryUtil.movePortletFileEntryToTrash((long)thread.getStatusByUserId(), (long)fileEntry.getFileEntryId());
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
            if (oldStatus != 1) continue;
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(message.getCompanyId(), message.getGroupId(), MBMessage.class.getName(), message.getMessageId());
        }
    }

    public MBThread moveThread(long groupId, long categoryId, long threadId) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        long oldCategoryId = thread.getCategoryId();
        thread.setCategoryId(categoryId);
        thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
        List messages = this.mbMessagePersistence.findByG_C_T(groupId, oldCategoryId, thread.getThreadId());
        for (MBMessage message : messages) {
            message.setCategoryId(categoryId);
            if ((message = (MBMessage)this.mbMessagePersistence.update((BaseModel)message)).isDiscussion()) continue;
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        indexer.reindex((Object)thread);
        return thread;
    }

    public MBThread moveThreadFromTrash(long userId, long categoryId, long threadId) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        if (!thread.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (thread.isInTrashExplicitly()) {
            this.restoreThreadFromTrash(userId, threadId);
        } else {
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(MBThread.class.getName(), thread.getThreadId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, threadId, status);
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this.mbThreadLocalService.restoreDependentsFromTrash(thread.getGroupId(), threadId);
        }
        return this.moveThread(thread.getGroupId(), categoryId, threadId);
    }

    public void moveThreadsToTrash(long groupId, long userId) throws PortalException {
        List threads = this.mbThreadPersistence.findByGroupId(groupId);
        for (MBThread thread : threads) {
            this.moveThreadToTrash(userId, thread);
        }
    }

    public MBThread moveThreadToTrash(long userId, long threadId) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        return this.moveThreadToTrash(userId, thread);
    }

    public MBThread moveThreadToTrash(long userId, MBThread thread) throws PortalException {
        if (thread.isInTrash()) {
            throw new TrashEntryException();
        }
        if (thread.getCategoryId() == -1L) {
            return thread;
        }
        int oldStatus = thread.getStatus();
        if (oldStatus == 1) {
            thread.setStatus(2);
            thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
        }
        thread = this.updateStatus(userId, thread.getThreadId(), 8);
        TrashEntry trashEntry = this._trashEntryLocalService.addTrashEntry(userId, thread.getGroupId(), MBThread.class.getName(), thread.getThreadId(), thread.getUuid(), null, oldStatus, null, null);
        this.mbThreadLocalService.moveDependentsToTrash(thread.getGroupId(), thread.getThreadId(), trashEntry.getEntryId());
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"rootMessageId", (Object)thread.getRootMessageId()).put("title", message.getSubject());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)thread, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        return thread;
    }

    public void restoreDependentsFromTrash(long groupId, long threadId) throws PortalException {
        HashSet<Long> userIds = new HashSet<Long>();
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            if (message.isDiscussion()) continue;
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(MBMessage.class.getName(), message.getMessageId());
            int oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            message.setStatus(oldStatus);
            message = (MBMessage)this.mbMessagePersistence.update((BaseModel)message);
            userIds.add(message.getUserId());
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            if (oldStatus == 0) {
                this.assetEntryLocalService.updateVisible(MBMessage.class.getName(), message.getMessageId(), true);
            }
            for (FileEntry fileEntry : message.getDeletedAttachmentsFileEntries()) {
                PortletFileRepositoryUtil.restorePortletFileEntryFromTrash((long)thread.getStatusByUserId(), (long)fileEntry.getFileEntryId());
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
    }

    public void restoreThreadFromTrash(long userId, long threadId) throws PortalException {
        MBThread thread = this.getThread(threadId);
        if (!thread.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (thread.getCategoryId() == -1L) {
            return;
        }
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(MBThread.class.getName(), threadId);
        this.updateStatus(userId, threadId, trashEntry.getStatus());
        this.mbThreadLocalService.restoreDependentsFromTrash(thread.getGroupId(), threadId);
        this._trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
        JSONObject extraDataJSONObject = JSONUtil.put((String)"rootMessageId", (Object)thread.getRootMessageId()).put("title", message.getSubject());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)thread, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        return this.search(groupId, userId, creatorUserId, 0L, 0L, status, start, end);
    }

    public Hits search(long groupId, long userId, long creatorUserId, long startDate, long endDate, int status, int start, int end) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)MBThread.class.getName());
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        if (endDate > 0L) {
            searchContext.setAttribute("endDate", (Serializable)Long.valueOf(endDate));
        }
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("participantUserId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        if (startDate > 0L) {
            searchContext.setAttribute("startDate", (Serializable)Long.valueOf(startDate));
        }
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("lastPostDate", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return indexer.search(searchContext);
    }

    public MBThread splitThread(long userId, long messageId, String subject, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        if (message.isRoot()) {
            throw new SplitThreadException("Unable to split message " + messageId + " because it is a root message");
        }
        MBCategory category = message.getCategory();
        MBThread oldThread = message.getThread();
        MBMessage rootMessage = this.mbMessagePersistence.findByPrimaryKey(oldThread.getRootMessageId());
        long oldAttachmentsFolderId = message.getAttachmentsFolderId();
        MBMessageUtil.updateAnswer(this.mbMessagePersistence, message, false, true);
        MBThread thread = this.addThread(message.getCategoryId(), message, serviceContext);
        oldThread = (MBThread)this.mbThreadPersistence.update((BaseModel)oldThread);
        Indexer messageIndexer = this._indexerRegistry.nullSafeGetIndexer(MBMessage.class);
        if (Validator.isNotNull((String)subject)) {
            List<MBMessage> messages = MBMessageUtil.getThreadMessages(this.mbMessagePersistence, this.mbMessageFinder, userId, message.getThreadId(), -1, -1, -1, (Comparator<MBMessage>)new MessageThreadComparator());
            MBTreeWalkerImpl treeWalker = new MBTreeWalkerImpl(messages);
            int[] range = treeWalker.getChildrenRange(message);
            for (int i = range[0]; i < range[1]; ++i) {
                MBMessage curMessage = messages.get(i);
                String oldSubject = message.getSubject();
                String curSubject = curMessage.getSubject();
                curSubject = oldSubject.startsWith("RE: ") ? StringUtil.replace((String)curSubject, (String)rootMessage.getSubject(), (String)subject) : StringUtil.replace((String)curSubject, (String)oldSubject, (String)subject);
                curMessage.setSubject(curSubject);
                messageIndexer.reindex((Object)this.mbMessagePersistence.update((BaseModel)curMessage));
            }
            message.setSubject(subject);
            thread.setTitle(subject);
            this.mbThreadLocalService.updateMBThread(thread);
        }
        message.setThreadId(thread.getThreadId());
        message.setRootMessageId(thread.getRootMessageId());
        message.setParentMessageId(0L);
        messageIndexer.reindex((Object)this.mbMessagePersistence.update((BaseModel)message));
        this.moveAttachmentsFolders(message, oldAttachmentsFolderId, oldThread, thread, serviceContext);
        if (!message.isDiscussion()) {
            messageIndexer.reindex((Object)message);
        }
        this.moveChildrenMessages(message, category, oldThread.getThreadId());
        Indexer threadIndexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        threadIndexer.reindex((Object)oldThread);
        threadIndexer.reindex((Object)message.getThread());
        return thread;
    }

    @BufferedIncrement(configuration="MBThread", incrementClass=DateOverrideIncrement.class)
    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.hibernate.StaleObjectStateException")})
    public void updateLastPostDate(long threadId, Date lastPostDate) {
        MBThread thread = this.mbThreadPersistence.fetchByPrimaryKey(threadId);
        if (thread == null) {
            return;
        }
        MBMessage message = this.mbMessagePersistence.fetchByT_S_Last(threadId, 0, null);
        if (message == null || message.isAnonymous()) {
            thread.setLastPostByUserId(0L);
        } else {
            thread.setLastPostByUserId(message.getUserId());
        }
        thread.setLastPostDate(lastPostDate);
        this.mbThreadPersistence.update((BaseModel)thread);
    }

    public void updateQuestion(long threadId, boolean question) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        if (thread.isQuestion() == question) {
            return;
        }
        thread.setQuestion(question);
        thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(thread.getRootMessageId());
        if (!question) {
            MBMessageUtil.updateAnswer(this.mbMessagePersistence, message, false, true);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        indexer.reindex((Object)message);
    }

    public MBThread updateStatus(long userId, long threadId, int status) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        User user = this.userLocalService.getUser(userId);
        thread.setStatus(status);
        thread.setStatusByUserId(user.getUserId());
        thread.setStatusByUserName(user.getFullName());
        thread.setStatusDate(new Date());
        thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        indexer.reindex((Object)thread);
        return thread;
    }

    protected void moveAttachmentsFolders(MBMessage message, long oldAttachmentsFolderId, MBThread oldThread, MBThread newThread, ServiceContext serviceContext) throws PortalException {
        if (oldAttachmentsFolderId != 0L) {
            Folder newThreadFolder = newThread.addAttachmentsFolder();
            PortletFileRepositoryUtil.movePortletFolder((long)message.getGroupId(), (long)message.getUserId(), (long)oldAttachmentsFolderId, (long)newThreadFolder.getFolderId(), (ServiceContext)serviceContext);
        }
        List childMessages = this.mbMessagePersistence.findByT_P(oldThread.getThreadId(), message.getMessageId());
        for (MBMessage childMessage : childMessages) {
            this.moveAttachmentsFolders(childMessage, childMessage.getAttachmentsFolderId(), oldThread, newThread, serviceContext);
        }
    }

    protected void moveChildrenMessages(MBMessage parentMessage, MBCategory category, long oldThreadId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        List messages = this.mbMessagePersistence.findByT_P(oldThreadId, parentMessage.getMessageId());
        for (MBMessage message : messages) {
            message.setCategoryId(parentMessage.getCategoryId());
            message.setThreadId(parentMessage.getThreadId());
            message.setRootMessageId(parentMessage.getRootMessageId());
            indexer.reindex((Object)this.mbMessagePersistence.update((BaseModel)message));
            this.moveChildrenMessages(message, category, oldThreadId);
        }
    }
}

