/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.search.spi.model.index.contributor;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.IndexerWriterMode;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.message.boards.model.MBMessage"}, service={ModelIndexerWriterContributor.class})
public class MBMessageModelIndexerWriterContributor
implements ModelIndexerWriterContributor<MBMessage> {
    private static final Log _log = LogFactoryUtil.getLog(MBMessageModelIndexerWriterContributor.class);
    @Reference
    private DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setAddCriteriaMethod(dynamicQuery -> {
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.in((Object[])new Integer[]{0, 8}));
        });
        batchIndexingActionable.setPerformActionMethod(mbMessage -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Reindexing message boards messages for message ", "board category ID ", mbMessage.getCategoryId(), " and group ID ", mbMessage.getGroupId()}));
            }
            if (mbMessage.isDiscussion() && mbMessage.isRoot()) {
                return;
            }
            batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)mbMessage)});
        });
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this._dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this._mbMessageLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(MBMessage mbMessage) {
        return mbMessage.getCompanyId();
    }

    public IndexerWriterMode getIndexerWriterMode(MBMessage mbMessage) {
        int status = mbMessage.getStatus();
        if (mbMessage.isDiscussion() && mbMessage.isRoot()) {
            return IndexerWriterMode.SKIP;
        }
        if (status == 0 || status == 8) {
            return IndexerWriterMode.UPDATE;
        }
        return IndexerWriterMode.DELETE;
    }

    public void modelIndexed(MBMessage mbMessage) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        try {
            for (FileEntry attachmentsFileEntry : mbMessage.getAttachmentsFileEntries()) {
                indexer.reindex((Object)((DLFileEntry)attachmentsFileEntry.getModel()));
            }
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }
}

