/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.trash;

import com.liferay.message.boards.internal.util.MBTrashUtil;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.trash.TrashRendererFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.trash.BaseTrashHandler;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBCategory"}, service={TrashHandler.class})
public class MBCategoryTrashHandler
extends BaseTrashHandler {
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBCategory)")
    private ModelResourcePermission<MBCategory> _categoryModelResourcePermission;
    private MBCategoryLocalService _mbCategoryLocalService;
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private Portal _portal;
    private TrashRendererFactory _trashRendererFactory;

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._mbCategoryLocalService.deleteCategory(this._mbCategoryLocalService.getCategory(classPK), false);
    }

    public String getClassName() {
        return MBCategory.class.getName();
    }

    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        return this._mbCategoryLocalService.getCategory(containerModelId);
    }

    public String getContainerModelClassName(long classPK) {
        return MBCategory.class.getName();
    }

    public String getContainerModelName() {
        return "category";
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        List categories = this._mbCategoryLocalService.getCategories(category.getGroupId(), parentContainerModelId, 0, start, end);
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        for (MBCategory curCategory : categories) {
            containerModels.add((ContainerModel)curCategory);
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        return this._mbCategoryLocalService.getCategoriesCount(category.getGroupId(), parentContainerModelId, 0);
    }

    public String getDeleteMessage() {
        return "found-in-deleted-category-x";
    }

    public List<ContainerModel> getParentContainerModels(long containerModelId) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        ContainerModel containerModel = this.getContainerModel(containerModelId);
        while (containerModel.getParentContainerModelId() > 0L && (containerModel = this.getContainerModel(containerModel.getParentContainerModelId())) != null) {
            containerModels.add(containerModel);
        }
        return containerModels;
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        return PortletURLBuilder.create((PortletURL)this.getRestoreURL(portletRequest, classPK)).setParameter("mbCategoryId", (Object)category.getCategoryId()).buildString();
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        return PortletURLBuilder.create((PortletURL)this.getRestoreURL(portletRequest, classPK)).setParameter("mbCategoryId", (Object)category.getParentCategoryId()).buildString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        return MBTrashUtil.getAbsolutePath(portletRequest, category.getParentCategoryId());
    }

    public String getRootContainerModelName() {
        return "category";
    }

    public String getSubcontainerModelName() {
        return "category";
    }

    public String getTrashContainedModelName() {
        return "threads";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        return this._mbThreadLocalService.getThreadsCount(category.getGroupId(), classPK, 8);
    }

    public String getTrashContainerModelName() {
        return "categories";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        return this._mbCategoryLocalService.getCategoriesCount(category.getGroupId(), classPK, 8);
    }

    public TrashedModel getTrashedModel(long classPK) {
        return this._mbCategoryLocalService.fetchMBCategory(classPK);
    }

    public int getTrashModelsCount(long classPK) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        return this._mbCategoryLocalService.getCategoriesAndThreadsCount(category.getGroupId(), classPK, 8);
    }

    public List<TrashedModel> getTrashModelTrashedModels(long classPK, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        List categoriesAndThreads = this._mbCategoryLocalService.getCategoriesAndThreads(category.getGroupId(), classPK, 8, start, end);
        ArrayList<TrashedModel> trashedModels = new ArrayList<TrashedModel>(categoriesAndThreads.size());
        for (Object categoryOrThread : categoriesAndThreads) {
            if (categoryOrThread instanceof MBThread) {
                MBThread mbThread = (MBThread)categoryOrThread;
                trashedModels.add((TrashedModel)mbThread);
                continue;
            }
            if (categoryOrThread instanceof MBCategory) {
                MBCategory mbCategory = (MBCategory)categoryOrThread;
                trashedModels.add((TrashedModel)mbCategory);
                continue;
            }
            throw new IllegalStateException("Expected MBThread or MBCategory, received " + categoryOrThread.getClass());
        }
        return trashedModels;
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        return this._trashRendererFactory.getTrashRenderer(classPK);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return ModelResourcePermissionUtil.contains(this._categoryModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)"ADD_CATEGORY");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isMovable(long classPK) throws PortalException {
        MBCategory parentCategory;
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        return category.getParentCategoryId() > 0L && ((parentCategory = this._mbCategoryLocalService.fetchMBCategory(category.getParentCategoryId())) == null || parentCategory.isInTrash());
    }

    public boolean isRestorable(long classPK) throws PortalException {
        MBCategory parentCategory;
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        if (category.getParentCategoryId() > 0L && (parentCategory = this._mbCategoryLocalService.fetchMBCategory(category.getParentCategoryId())) == null) {
            return false;
        }
        if (!this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), category.getGroupId(), classPK, "RESTORE")) {
            return false;
        }
        return !category.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this._mbCategoryLocalService.moveCategory(classPK, containerModelId, false);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this._mbCategoryLocalService.moveCategoryFromTrash(userId, classPK, containerModelId);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        this._mbCategoryLocalService.restoreCategoryFromTrash(userId, classPK);
    }

    public void updateTitle(long classPK, String name) throws PortalException {
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        category.setName(name);
        this._mbCategoryLocalService.updateMBCategory(category);
    }

    protected PortletURL getRestoreURL(PortletRequest portletRequest, long classPK) throws PortalException {
        LiferayPortletURL portletURL = null;
        MBCategory category = this._mbCategoryLocalService.getCategory(classPK);
        String portletId = PortletProviderUtil.getPortletId((String)MBCategory.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        long plid = this._portal.getPlidFromPortletId(category.getGroupId(), portletId);
        if (plid == 0L) {
            portletId = PortletProviderUtil.getPortletId((String)MBCategory.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
            portletURL = this._portal.getControlPanelPortletURL(portletRequest, portletId, "RENDER_PHASE");
        } else {
            portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        }
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_category");
        return portletURL;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return this._categoryModelResourcePermission.contains(permissionChecker, (ClassedModel)this._mbCategoryLocalService.getCategory(classPK), actionId);
    }

    @Reference(unbind="-")
    protected void setMBCategoryLocalService(MBCategoryLocalService mbCategoryLocalService) {
        this._mbCategoryLocalService = mbCategoryLocalService;
    }

    @Reference(unbind="-")
    protected void setMBThreadLocalService(MBThreadLocalService mbThreadLocalService) {
        this._mbThreadLocalService = mbThreadLocalService;
    }

    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBCategory)", unbind="-")
    protected void setTrashRendererFactory(TrashRendererFactory trashRendererFactory) {
        this._trashRendererFactory = trashRendererFactory;
    }
}

