/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.upgrade.v3_1_0;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UrlSubjectUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.alterTableAddColumn("MBMessage", "urlSubject", "VARCHAR(255) null");
        try (SafeCloseable safeCloseable = this.addTempIndex("MBMessage", false, new String[]{"subject", "messageId"});){
            this._populateUrlSubject();
        }
    }

    private String _getURLSubject(long id, String subject) {
        if (subject == null) {
            return String.valueOf(id);
        }
        subject = Validator.isNull((String)(subject = StringUtil.toLowerCase((String)subject.trim()))) || Validator.isNumber((String)subject) || subject.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)subject);
        return subject.substring(0, Math.min(subject.length(), 254));
    }

    private void _populateUrlSubject() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select messageId, subject from MBMessage order by subject, messageId asc");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update MBMessage set urlSubject = ? where messageId = ?");){
            int count = 0;
            String curURLSubject = null;
            String previousURLSubject = null;
            while (resultSet.next()) {
                long messageId = resultSet.getLong(1);
                String subject = resultSet.getString(2);
                curURLSubject = this._getURLSubject(messageId, subject);
                String suffix = null;
                if (StringUtil.equals(previousURLSubject, (String)curURLSubject)) {
                    suffix = "-" + ++count;
                } else {
                    count = 0;
                    previousURLSubject = curURLSubject;
                    suffix = "";
                }
                preparedStatement2.setString(1, curURLSubject + suffix);
                preparedStatement2.setLong(2, messageId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

