/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBSuspiciousActivity;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.base.MBSuspiciousActivityLocalServiceBaseImpl;
import com.liferay.message.boards.service.persistence.MBMessagePersistence;
import com.liferay.message.boards.service.persistence.MBThreadPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBSuspiciousActivity"}, service={AopService.class})
public class MBSuspiciousActivityLocalServiceImpl
extends MBSuspiciousActivityLocalServiceBaseImpl {
    @Reference
    private MBMessagePersistence _mbMessagePersistence;
    @Reference
    private MBThreadPersistence _mbThreadPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public MBSuspiciousActivity addOrUpdateSuspiciousActivity(long userId, long messageId, String description, String type) throws PortalException {
        MBSuspiciousActivity suspiciousActivity = this.mbSuspiciousActivityPersistence.fetchByU_M(userId, messageId);
        if (suspiciousActivity == null) {
            long suspiciousActivityId = this.counterLocalService.increment();
            suspiciousActivity = this.mbSuspiciousActivityPersistence.create(suspiciousActivityId);
            MBMessage message = this._mbMessagePersistence.findByPrimaryKey(messageId);
            MBThread thread = this._mbThreadPersistence.findByPrimaryKey(message.getThreadId());
            suspiciousActivity.setGroupId(thread.getGroupId());
            User user = this._userLocalService.getUser(userId);
            suspiciousActivity.setCompanyId(user.getCompanyId());
            suspiciousActivity.setUserId(user.getUserId());
            suspiciousActivity.setUserName(user.getFullName());
            suspiciousActivity.setMessageId(messageId);
            suspiciousActivity.setThreadId(thread.getThreadId());
        }
        suspiciousActivity.setDescription(description);
        suspiciousActivity.setType(type);
        return this.mbSuspiciousActivityLocalService.updateMBSuspiciousActivity(suspiciousActivity);
    }

    public MBSuspiciousActivity deleteSuspiciousActivity(long suspiciousActivityId) throws PortalException {
        return this.mbSuspiciousActivityPersistence.remove(suspiciousActivityId);
    }

    public List<MBSuspiciousActivity> getMessageSuspiciousActivities(long messageId) {
        return this.mbSuspiciousActivityPersistence.findByMessageId(messageId);
    }

    public MBSuspiciousActivity getSuspiciousActivity(long suspiciousActivityId) throws PortalException {
        return this.mbSuspiciousActivityPersistence.findByPrimaryKey(suspiciousActivityId);
    }

    public List<MBSuspiciousActivity> getThreadSuspiciousActivities(long threadId) {
        return this.mbSuspiciousActivityPersistence.findByThreadId(threadId);
    }

    public MBSuspiciousActivity updateValidated(long suspiciousActivityId) throws PortalException {
        MBSuspiciousActivity suspiciousActivity;
        suspiciousActivity.setValidated(!(suspiciousActivity = this.mbSuspiciousActivityPersistence.findByPrimaryKey(suspiciousActivityId)).isValidated());
        return (MBSuspiciousActivity)this.mbSuspiciousActivityPersistence.update((BaseModel)suspiciousActivity);
    }
}

