/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.exception.LockedThreadException;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.base.MBThreadServiceBaseImpl;
import com.liferay.message.boards.service.persistence.MBMessageFinder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=mb", "json.web.service.context.path=MBThread"}, service={AopService.class})
public class MBThreadServiceImpl
extends MBThreadServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBCategory)")
    private ModelResourcePermission<MBCategory> _categoryModelResourcePermission;
    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.message.boards.service)(name=service))")
    private Configuration _configuration;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    @Reference
    private LockManager _lockManager;
    @Reference
    private MBCategoryService _mbCategoryService;
    @Reference
    private MBMessageFinder _mbMessageFinder;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    private long _mbThreadLockExpirationTime;
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBMessage)")
    private ModelResourcePermission<MBMessage> _messageModelResourcePermission;

    public void deleteThread(long threadId) throws PortalException {
        if (this._lockManager.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException(StringBundler.concat((Object[])new Object[]{"Thread is locked for class name ", MBThread.class.getName(), " and class PK ", threadId}));
        }
        List messages = this._mbMessageLocalService.getThreadMessages(threadId, -1, null);
        for (MBMessage message : messages) {
            this._messageModelResourcePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        this.mbThreadLocalService.deleteThread(threadId);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, Date modifiedDate, boolean includeAnonymous, int status, int start, int end) throws PortalException {
        if (!this._inlineSQLHelper.isEnabled(groupId)) {
            QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
            if (includeAnonymous) {
                return this.mbThreadFinder.findByG_U_LPD(groupId, userId, modifiedDate, queryDefinition);
            }
            return this.mbThreadFinder.findByG_U_LPD_A(groupId, userId, modifiedDate, false, queryDefinition);
        }
        long[] categoryIds = this._mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return Collections.emptyList();
        }
        List threadIds = null;
        threadIds = includeAnonymous ? this._mbMessageFinder.filterFindByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status, start, end) : this._mbMessageFinder.filterFindByG_U_MD_C_A_S(groupId, userId, modifiedDate, categoryIds, false, status, start, end);
        ArrayList<MBThread> threads = new ArrayList<MBThread>(threadIds.size());
        Iterator iterator = threadIds.iterator();
        while (iterator.hasNext()) {
            long threadId = (Long)iterator.next();
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
            threads.add(thread);
        }
        return threads;
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, Date modifiedDate, int status, int start, int end) throws PortalException {
        return this.mbThreadService.getGroupThreads(groupId, userId, modifiedDate, true, status, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous, int start, int end) throws PortalException {
        if (!this._inlineSQLHelper.isEnabled(groupId)) {
            return this.doGetGroupThreads(groupId, userId, status, subscribed, includeAnonymous, start, end);
        }
        long[] categoryIds = this._mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return Collections.emptyList();
        }
        List threadIds = null;
        if (userId <= 0L) {
            threadIds = this._mbMessageFinder.filterFindByG_U_C_S(groupId, 0L, categoryIds, status, start, end);
        } else {
            if (subscribed) {
                QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
                return this.mbThreadFinder.filterFindByS_G_U_C(groupId, userId, categoryIds, queryDefinition);
            }
            threadIds = includeAnonymous ? this._mbMessageFinder.filterFindByG_U_C_S(groupId, userId, categoryIds, status, start, end) : this._mbMessageFinder.filterFindByG_U_C_A_S(groupId, userId, categoryIds, false, status, start, end);
        }
        ArrayList<MBThread> threads = new ArrayList<MBThread>(threadIds.size());
        Iterator iterator = threadIds.iterator();
        while (iterator.hasNext()) {
            long threadId = (Long)iterator.next();
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
            threads.add(thread);
        }
        return threads;
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, boolean subscribed, int start, int end) throws PortalException {
        return this.getGroupThreads(groupId, userId, status, subscribed, true, start, end);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, int status, int start, int end) throws PortalException {
        return this.getGroupThreads(groupId, userId, status, false, start, end);
    }

    public int getGroupThreadsCount(long groupId, long userId, Date modifiedDate, boolean includeAnonymous, int status) {
        if (!this._inlineSQLHelper.isEnabled(groupId)) {
            QueryDefinition queryDefinition = new QueryDefinition(status);
            if (includeAnonymous) {
                return this.mbThreadFinder.countByG_U_LPD(groupId, userId, modifiedDate, queryDefinition);
            }
            return this.mbThreadFinder.countByG_U_LPD_A(groupId, userId, modifiedDate, false, queryDefinition);
        }
        long[] categoryIds = this._mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return 0;
        }
        if (includeAnonymous) {
            return this._mbMessageFinder.filterCountByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status);
        }
        return this._mbMessageFinder.filterCountByG_U_MD_C_A_S(groupId, userId, modifiedDate, categoryIds, false, status);
    }

    public int getGroupThreadsCount(long groupId, long userId, Date modifiedDate, int status) {
        return this.mbThreadService.getGroupThreadsCount(groupId, userId, modifiedDate, true, status);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status) {
        return this.getGroupThreadsCount(groupId, userId, status, false);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed) {
        return this.getGroupThreadsCount(groupId, userId, status, subscribed, true);
    }

    public int getGroupThreadsCount(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous) {
        if (!this._inlineSQLHelper.isEnabled(groupId)) {
            return this.doGetGroupThreadsCount(groupId, userId, status, subscribed, includeAnonymous);
        }
        long[] categoryIds = this._mbCategoryService.getCategoryIds(groupId, 0L);
        if (categoryIds.length == 0) {
            return 0;
        }
        if (userId <= 0L) {
            return this._mbMessageFinder.filterCountByG_U_C_S(groupId, 0L, categoryIds, status);
        }
        if (subscribed) {
            QueryDefinition queryDefinition = new QueryDefinition(status);
            return this.mbThreadFinder.filterCountByS_G_U_C(groupId, userId, categoryIds, queryDefinition);
        }
        if (includeAnonymous) {
            return this._mbMessageFinder.filterCountByG_U_C_S(groupId, userId, categoryIds, status);
        }
        return this._mbMessageFinder.filterCountByG_U_C_A_S(groupId, userId, categoryIds, false, status);
    }

    public List<MBThread> getThreads(long groupId, long categoryId, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.mbThreadFinder.filterFindByG_C(groupId, categoryId, queryDefinition);
    }

    public List<MBThread> getThreads(long groupId, long categoryId, QueryDefinition<MBThread> queryDefinition) throws PortalException {
        if (queryDefinition.isIncludeOwner() && queryDefinition.getOwnerUserId() != 0L) {
            queryDefinition.setOwnerUserId(this.getUserId());
        }
        return this.mbThreadFinder.filterFindByG_C(groupId, categoryId, queryDefinition);
    }

    public int getThreadsCount(long groupId, long categoryId, int status) {
        if (status == -1) {
            return this.mbThreadFinder.filterCountByG_C(groupId, categoryId);
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.mbThreadFinder.filterCountByG_C(groupId, categoryId, queryDefinition);
    }

    public int getThreadsCount(long groupId, long categoryId, QueryDefinition<MBThread> queryDefinition) throws PortalException {
        if (queryDefinition.isIncludeOwner() && queryDefinition.getOwnerUserId() != 0L) {
            queryDefinition.setOwnerUserId(this.getUserId());
        }
        return this.mbThreadFinder.filterCountByG_C(groupId, categoryId, queryDefinition);
    }

    public Lock lockThread(long threadId) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)thread.getGroupId(), (long)thread.getCategoryId(), (String)"LOCK_THREAD");
        return this._lockManager.lock(this.getUserId(), MBThread.class.getName(), threadId, String.valueOf(threadId), false, this._mbThreadLockExpirationTime);
    }

    public MBThread moveThread(long categoryId, long threadId) throws PortalException {
        if (this._lockManager.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException(StringBundler.concat((Object[])new Object[]{"Thread is locked for class name ", MBThread.class.getName(), " and class PK ", threadId}));
        }
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)thread.getGroupId(), (long)thread.getCategoryId(), (String)"MOVE_THREAD");
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)thread.getGroupId(), (long)categoryId, (String)"MOVE_THREAD");
        return this.mbThreadLocalService.moveThread(thread.getGroupId(), categoryId, threadId);
    }

    public MBThread moveThreadFromTrash(long categoryId, long threadId) throws PortalException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)thread.getGroupId(), (long)thread.getCategoryId(), (String)"UPDATE");
        return this.mbThreadLocalService.moveThreadFromTrash(this.getUserId(), categoryId, threadId);
    }

    public MBThread moveThreadToTrash(long threadId) throws PortalException {
        if (this._lockManager.isLocked(MBThread.class.getName(), threadId)) {
            throw new LockedThreadException(StringBundler.concat((Object[])new Object[]{"Thread is locked for class name ", MBThread.class.getName(), " and class PK ", threadId}));
        }
        List messages = this._mbMessageLocalService.getThreadMessages(threadId, -1, null);
        for (MBMessage message : messages) {
            this._messageModelResourcePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        return this.mbThreadLocalService.moveThreadToTrash(this.getUserId(), threadId);
    }

    public void restoreThreadFromTrash(long threadId) throws PortalException {
        List messages = this._mbMessageLocalService.getThreadMessages(threadId, -1, null);
        for (MBMessage message : messages) {
            this._messageModelResourcePermission.check(this.getPermissionChecker(), message.getMessageId(), "DELETE");
        }
        this.mbThreadLocalService.restoreThreadFromTrash(this.getUserId(), threadId);
    }

    public Hits search(long groupId, long creatorUserId, int status, int start, int end) throws PortalException {
        return this.mbThreadLocalService.search(groupId, this.getUserId(), creatorUserId, status, start, end);
    }

    public Hits search(long groupId, long creatorUserId, long startDate, long endDate, int status, int start, int end) throws PortalException {
        return this.mbThreadLocalService.search(groupId, this.getUserId(), creatorUserId, startDate, endDate, status, start, end);
    }

    public MBThread splitThread(long messageId, String subject, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        MBMessage message = this._mbMessageLocalService.getMessage(messageId);
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"MOVE_THREAD");
        this._messageModelResourcePermission.check(permissionChecker, messageId, "VIEW");
        return this.mbThreadLocalService.splitThread(this.getUserId(), messageId, subject, serviceContext);
    }

    public void unlockThread(long threadId) throws PortalException {
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        ModelResourcePermissionUtil.check(this._categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)thread.getGroupId(), (long)thread.getCategoryId(), (String)"LOCK_THREAD");
        this._lockManager.unlock(MBThread.class.getName(), threadId);
    }

    @Activate
    protected void activate() {
        this._mbThreadLockExpirationTime = GetterUtil.getLong((String)this._configuration.get("lock.expiration.time.com.liferay.message.boards.model.MBThread"));
    }

    protected List<MBThread> doGetGroupThreads(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous, int start, int end) {
        if (userId <= 0L) {
            if (status == -1) {
                return this.mbThreadPersistence.findByGroupId(groupId, start, end);
            }
            return this.mbThreadPersistence.findByG_S(groupId, status, start, end);
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        if (subscribed) {
            return this.mbThreadFinder.findByS_G_U(groupId, userId, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.findByG_U(groupId, userId, queryDefinition);
        }
        return this.mbThreadFinder.findByG_U_A(groupId, userId, false, queryDefinition);
    }

    protected int doGetGroupThreadsCount(long groupId, long userId, int status, boolean subscribed, boolean includeAnonymous) {
        if (userId <= 0L) {
            if (status == -1) {
                return this.mbThreadPersistence.countByGroupId(groupId);
            }
            return this.mbThreadPersistence.countByG_S(groupId, status);
        }
        QueryDefinition queryDefinition = new QueryDefinition(status);
        if (subscribed) {
            return this.mbThreadFinder.countByS_G_U(groupId, userId, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.countByG_U(groupId, userId, queryDefinition);
        }
        return this.mbThreadFinder.countByG_U_A(groupId, userId, false, queryDefinition);
    }
}

