/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.persistence.impl;

import com.liferay.message.boards.exception.NoSuchDiscussionException;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBDiscussionTable;
import com.liferay.message.boards.model.impl.MBDiscussionImpl;
import com.liferay.message.boards.model.impl.MBDiscussionModelImpl;
import com.liferay.message.boards.service.persistence.MBDiscussionPersistence;
import com.liferay.message.boards.service.persistence.MBDiscussionUtil;
import com.liferay.message.boards.service.persistence.impl.MBDiscussionModelArgumentsResolver;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUID;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={MBDiscussionPersistence.class, BasePersistence.class})
public class MBDiscussionPersistenceImpl
extends BasePersistenceImpl<MBDiscussion>
implements MBDiscussionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = MBDiscussionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "mbDiscussion.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(mbDiscussion.uuid IS NULL OR mbDiscussion.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "mbDiscussion.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(mbDiscussion.uuid IS NULL OR mbDiscussion.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "mbDiscussion.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "mbDiscussion.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(mbDiscussion.uuid IS NULL OR mbDiscussion.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "mbDiscussion.companyId = ?";
    private FinderPath _finderPathFetchByThreadId;
    private FinderPath _finderPathCountByThreadId;
    private static final String _FINDER_COLUMN_THREADID_THREADID_2 = "mbDiscussion.threadId = ?";
    private FinderPath _finderPathFetchByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_CLASSNAMEID_2 = "mbDiscussion.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLASSPK_2 = "mbDiscussion.classPK = ?";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_MBDISCUSSION = "SELECT mbDiscussion FROM MBDiscussion mbDiscussion";
    private static final String _SQL_SELECT_MBDISCUSSION_WHERE = "SELECT mbDiscussion FROM MBDiscussion mbDiscussion WHERE ";
    private static final String _SQL_COUNT_MBDISCUSSION = "SELECT COUNT(mbDiscussion) FROM MBDiscussion mbDiscussion";
    private static final String _SQL_COUNT_MBDISCUSSION_WHERE = "SELECT COUNT(mbDiscussion) FROM MBDiscussion mbDiscussion WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "mbDiscussion.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No MBDiscussion exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No MBDiscussion exists with the key {";
    private static final Log _log;
    private static final Set<String> _badColumnNames;
    @Reference
    private PortalUUID _portalUUID;
    @Reference
    private MBDiscussionModelArgumentsResolver _mbDiscussionModelArgumentsResolver;

    public List<MBDiscussion> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<MBDiscussion> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<MBDiscussion> findByUuid(String uuid, int start, int end, OrderByComparator<MBDiscussion> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<MBDiscussion> findByUuid(String uuid, int start, int end, OrderByComparator<MBDiscussion> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (MBDiscussion mbDiscussion : list) {
                if (uuid.equals(mbDiscussion.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_MBDISCUSSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY mbDiscussion.discussionId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public MBDiscussion findByUuid_First(String uuid, OrderByComparator<MBDiscussion> orderByComparator) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.fetchByUuid_First(uuid, orderByComparator);
        if (mbDiscussion != null) {
            return mbDiscussion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchDiscussionException(sb.toString());
    }

    public MBDiscussion fetchByUuid_First(String uuid, OrderByComparator<MBDiscussion> orderByComparator) {
        List<MBDiscussion> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MBDiscussion findByUuid_Last(String uuid, OrderByComparator<MBDiscussion> orderByComparator) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.fetchByUuid_Last(uuid, orderByComparator);
        if (mbDiscussion != null) {
            return mbDiscussion;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchDiscussionException(sb.toString());
    }

    public MBDiscussion fetchByUuid_Last(String uuid, OrderByComparator<MBDiscussion> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<MBDiscussion> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MBDiscussion[] findByUuid_PrevAndNext(long discussionId, String uuid, OrderByComparator<MBDiscussion> orderByComparator) throws NoSuchDiscussionException {
        uuid = Objects.toString(uuid, "");
        MBDiscussion mbDiscussion = this.findByPrimaryKey(discussionId);
        Session session = null;
        try {
            session = this.openSession();
            MBDiscussion[] array = new MBDiscussionImpl[]{this.getByUuid_PrevAndNext(session, mbDiscussion, uuid, orderByComparator, true), mbDiscussion, this.getByUuid_PrevAndNext(session, mbDiscussion, uuid, orderByComparator, false)};
            MBDiscussion[] mBDiscussionArray = array;
            return mBDiscussionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected MBDiscussion getByUuid_PrevAndNext(Session session, MBDiscussion mbDiscussion, String uuid, OrderByComparator<MBDiscussion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_MBDISCUSSION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY mbDiscussion.discussionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)mbDiscussion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (MBDiscussion)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (MBDiscussion mbDiscussion : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)mbDiscussion);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByUuid;
            finderArgs = new Object[]{uuid};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_MBDISCUSSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public MBDiscussion findByUUID_G(String uuid, long groupId) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.fetchByUUID_G(uuid, groupId);
        if (mbDiscussion == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchDiscussionException(sb.toString());
        }
        return mbDiscussion;
    }

    public MBDiscussion fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public MBDiscussion fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        MBDiscussion mbDiscussion;
        uuid = Objects.toString(uuid, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs);
        }
        if (result instanceof MBDiscussion && (!Objects.equals(uuid, (mbDiscussion = (MBDiscussion)result).getUuid()) || groupId != mbDiscussion.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_MBDISCUSSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(mbDiscussion.uuid IS NULL OR mbDiscussion.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("mbDiscussion.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache && productionMode) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    MBDiscussion mbDiscussion2 = (MBDiscussion)list.get(0);
                    result = mbDiscussion2;
                    this.cacheResult(mbDiscussion2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (MBDiscussion)result;
    }

    public MBDiscussion removeByUUID_G(String uuid, long groupId) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.findByUUID_G(uuid, groupId);
        return (MBDiscussion)this.remove((BaseModel)mbDiscussion);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByUUID_G;
            finderArgs = new Object[]{uuid, groupId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_MBDISCUSSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(mbDiscussion.uuid IS NULL OR mbDiscussion.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("mbDiscussion.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<MBDiscussion> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<MBDiscussion> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<MBDiscussion> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<MBDiscussion> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<MBDiscussion> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<MBDiscussion> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (MBDiscussion mbDiscussion : list) {
                if (uuid.equals(mbDiscussion.getUuid()) && companyId == mbDiscussion.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_MBDISCUSSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(mbDiscussion.uuid IS NULL OR mbDiscussion.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("mbDiscussion.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY mbDiscussion.discussionId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public MBDiscussion findByUuid_C_First(String uuid, long companyId, OrderByComparator<MBDiscussion> orderByComparator) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (mbDiscussion != null) {
            return mbDiscussion;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchDiscussionException(sb.toString());
    }

    public MBDiscussion fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<MBDiscussion> orderByComparator) {
        List<MBDiscussion> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MBDiscussion findByUuid_C_Last(String uuid, long companyId, OrderByComparator<MBDiscussion> orderByComparator) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (mbDiscussion != null) {
            return mbDiscussion;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchDiscussionException(sb.toString());
    }

    public MBDiscussion fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<MBDiscussion> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<MBDiscussion> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MBDiscussion[] findByUuid_C_PrevAndNext(long discussionId, String uuid, long companyId, OrderByComparator<MBDiscussion> orderByComparator) throws NoSuchDiscussionException {
        uuid = Objects.toString(uuid, "");
        MBDiscussion mbDiscussion = this.findByPrimaryKey(discussionId);
        Session session = null;
        try {
            session = this.openSession();
            MBDiscussion[] array = new MBDiscussionImpl[]{this.getByUuid_C_PrevAndNext(session, mbDiscussion, uuid, companyId, orderByComparator, true), mbDiscussion, this.getByUuid_C_PrevAndNext(session, mbDiscussion, uuid, companyId, orderByComparator, false)};
            MBDiscussion[] mBDiscussionArray = array;
            return mBDiscussionArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected MBDiscussion getByUuid_C_PrevAndNext(Session session, MBDiscussion mbDiscussion, String uuid, long companyId, OrderByComparator<MBDiscussion> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_MBDISCUSSION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(mbDiscussion.uuid IS NULL OR mbDiscussion.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("mbDiscussion.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY mbDiscussion.discussionId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)mbDiscussion)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (MBDiscussion)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (MBDiscussion mbDiscussion : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)mbDiscussion);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByUuid_C;
            finderArgs = new Object[]{uuid, companyId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_MBDISCUSSION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(mbDiscussion.uuid IS NULL OR mbDiscussion.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("mbDiscussion.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public MBDiscussion findByThreadId(long threadId) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.fetchByThreadId(threadId);
        if (mbDiscussion == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("threadId=");
            sb.append(threadId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchDiscussionException(sb.toString());
        }
        return mbDiscussion;
    }

    public MBDiscussion fetchByThreadId(long threadId) {
        return this.fetchByThreadId(threadId, true);
    }

    public MBDiscussion fetchByThreadId(long threadId, boolean useFinderCache) {
        MBDiscussion mbDiscussion;
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{threadId};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = this.finderCache.getResult(this._finderPathFetchByThreadId, finderArgs);
        }
        if (result instanceof MBDiscussion && threadId != (mbDiscussion = (MBDiscussion)result).getThreadId()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_MBDISCUSSION_WHERE);
            sb.append(_FINDER_COLUMN_THREADID_THREADID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(threadId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache && productionMode) {
                        this.finderCache.putResult(this._finderPathFetchByThreadId, finderArgs, (Object)list);
                    }
                } else {
                    MBDiscussion mbDiscussion2 = (MBDiscussion)list.get(0);
                    result = mbDiscussion2;
                    this.cacheResult(mbDiscussion2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (MBDiscussion)result;
    }

    public MBDiscussion removeByThreadId(long threadId) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.findByThreadId(threadId);
        return (MBDiscussion)this.remove((BaseModel)mbDiscussion);
    }

    public int countByThreadId(long threadId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByThreadId;
            finderArgs = new Object[]{threadId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_MBDISCUSSION_WHERE);
            sb.append(_FINDER_COLUMN_THREADID_THREADID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(threadId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public MBDiscussion findByC_C(long classNameId, long classPK) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.fetchByC_C(classNameId, classPK);
        if (mbDiscussion == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchDiscussionException(sb.toString());
        }
        return mbDiscussion;
    }

    public MBDiscussion fetchByC_C(long classNameId, long classPK) {
        return this.fetchByC_C(classNameId, classPK, true);
    }

    public MBDiscussion fetchByC_C(long classNameId, long classPK, boolean useFinderCache) {
        MBDiscussion mbDiscussion;
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{classNameId, classPK};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = this.finderCache.getResult(this._finderPathFetchByC_C, finderArgs);
        }
        if (result instanceof MBDiscussion && (classNameId != (mbDiscussion = (MBDiscussion)result).getClassNameId() || classPK != mbDiscussion.getClassPK())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_MBDISCUSSION_WHERE);
            sb.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache && productionMode) {
                        this.finderCache.putResult(this._finderPathFetchByC_C, finderArgs, (Object)list);
                    }
                } else {
                    MBDiscussion mbDiscussion2 = (MBDiscussion)list.get(0);
                    result = mbDiscussion2;
                    this.cacheResult(mbDiscussion2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (MBDiscussion)result;
    }

    public MBDiscussion removeByC_C(long classNameId, long classPK) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.findByC_C(classNameId, classPK);
        return (MBDiscussion)this.remove((BaseModel)mbDiscussion);
    }

    public int countByC_C(long classNameId, long classPK) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByC_C;
            finderArgs = new Object[]{classNameId, classPK};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_MBDISCUSSION_WHERE);
            sb.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public MBDiscussionPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(MBDiscussion.class);
        this.setModelImplClass(MBDiscussionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)MBDiscussionTable.INSTANCE);
    }

    public void cacheResult(MBDiscussion mbDiscussion) {
        if (mbDiscussion.getCtCollectionId() != 0L) {
            return;
        }
        this.entityCache.putResult(MBDiscussionImpl.class, (Serializable)Long.valueOf(mbDiscussion.getPrimaryKey()), (Serializable)mbDiscussion);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{mbDiscussion.getUuid(), mbDiscussion.getGroupId()}, (Object)mbDiscussion);
        this.finderCache.putResult(this._finderPathFetchByThreadId, new Object[]{mbDiscussion.getThreadId()}, (Object)mbDiscussion);
        this.finderCache.putResult(this._finderPathFetchByC_C, new Object[]{mbDiscussion.getClassNameId(), mbDiscussion.getClassPK()}, (Object)mbDiscussion);
    }

    public void cacheResult(List<MBDiscussion> mbDiscussions) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && mbDiscussions.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (MBDiscussion mbDiscussion : mbDiscussions) {
            if (mbDiscussion.getCtCollectionId() != 0L || this.entityCache.getResult(MBDiscussionImpl.class, (Serializable)Long.valueOf(mbDiscussion.getPrimaryKey())) != null) continue;
            this.cacheResult(mbDiscussion);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(MBDiscussionImpl.class);
        this.finderCache.clearCache(MBDiscussionImpl.class);
    }

    public void clearCache(MBDiscussion mbDiscussion) {
        this.entityCache.removeResult(MBDiscussionImpl.class, (BaseModel)mbDiscussion);
    }

    public void clearCache(List<MBDiscussion> mbDiscussions) {
        for (MBDiscussion mbDiscussion : mbDiscussions) {
            this.entityCache.removeResult(MBDiscussionImpl.class, (BaseModel)mbDiscussion);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(MBDiscussionImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(MBDiscussionImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(MBDiscussionModelImpl mbDiscussionModelImpl) {
        Object[] args = new Object[]{mbDiscussionModelImpl.getUuid(), mbDiscussionModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)mbDiscussionModelImpl);
        args = new Object[]{mbDiscussionModelImpl.getThreadId()};
        this.finderCache.putResult(this._finderPathCountByThreadId, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByThreadId, args, (Object)mbDiscussionModelImpl);
        args = new Object[]{mbDiscussionModelImpl.getClassNameId(), mbDiscussionModelImpl.getClassPK()};
        this.finderCache.putResult(this._finderPathCountByC_C, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByC_C, args, (Object)mbDiscussionModelImpl);
    }

    public MBDiscussion create(long discussionId) {
        MBDiscussionImpl mbDiscussion = new MBDiscussionImpl();
        mbDiscussion.setNew(true);
        mbDiscussion.setPrimaryKey(discussionId);
        String uuid = this._portalUUID.generate();
        mbDiscussion.setUuid(uuid);
        mbDiscussion.setCompanyId(CompanyThreadLocal.getCompanyId());
        return mbDiscussion;
    }

    public MBDiscussion remove(long discussionId) throws NoSuchDiscussionException {
        return this.remove(Long.valueOf(discussionId));
    }

    public MBDiscussion remove(Serializable primaryKey) throws NoSuchDiscussionException {
        Session session = null;
        try {
            session = this.openSession();
            MBDiscussion mbDiscussion = (MBDiscussion)session.get(MBDiscussionImpl.class, primaryKey);
            if (mbDiscussion == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchDiscussionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            MBDiscussion mBDiscussion = (MBDiscussion)this.remove((BaseModel)mbDiscussion);
            return mBDiscussion;
        }
        catch (NoSuchDiscussionException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected MBDiscussion removeImpl(MBDiscussion mbDiscussion) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)mbDiscussion)) {
                mbDiscussion = (MBDiscussion)session.get(MBDiscussionImpl.class, mbDiscussion.getPrimaryKeyObj());
            }
            if (mbDiscussion != null && this.ctPersistenceHelper.isRemove((CTModel)mbDiscussion)) {
                session.delete((Object)mbDiscussion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (mbDiscussion != null) {
            this.clearCache(mbDiscussion);
        }
        return mbDiscussion;
    }

    public MBDiscussion updateImpl(MBDiscussion mbDiscussion) {
        boolean isNew = mbDiscussion.isNew();
        if (!(mbDiscussion instanceof MBDiscussionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(mbDiscussion.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)mbDiscussion);
                throw new IllegalArgumentException("Implement ModelWrapper in mbDiscussion proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom MBDiscussion implementation " + mbDiscussion.getClass());
        }
        MBDiscussionModelImpl mbDiscussionModelImpl = (MBDiscussionModelImpl)mbDiscussion;
        if (Validator.isNull((String)mbDiscussion.getUuid())) {
            String uuid = this._portalUUID.generate();
            mbDiscussion.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && mbDiscussion.getCreateDate() == null) {
            if (serviceContext == null) {
                mbDiscussion.setCreateDate(date);
            } else {
                mbDiscussion.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!mbDiscussionModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                mbDiscussion.setModifiedDate(date);
            } else {
                mbDiscussion.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)mbDiscussion)) {
                if (!isNew) {
                    session.evict(MBDiscussionImpl.class, mbDiscussion.getPrimaryKeyObj());
                }
                session.save((Object)mbDiscussion);
            } else {
                mbDiscussion = (MBDiscussion)session.merge((Object)mbDiscussion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (mbDiscussion.getCtCollectionId() != 0L) {
            if (isNew) {
                mbDiscussion.setNew(false);
            }
            mbDiscussion.resetOriginalValues();
            return mbDiscussion;
        }
        this.entityCache.putResult(MBDiscussionImpl.class, (BaseModel)mbDiscussionModelImpl, false, true);
        this.cacheUniqueFindersCache(mbDiscussionModelImpl);
        if (isNew) {
            mbDiscussion.setNew(false);
        }
        mbDiscussion.resetOriginalValues();
        return mbDiscussion;
    }

    public MBDiscussion findByPrimaryKey(Serializable primaryKey) throws NoSuchDiscussionException {
        MBDiscussion mbDiscussion = this.fetchByPrimaryKey(primaryKey);
        if (mbDiscussion == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchDiscussionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return mbDiscussion;
    }

    public MBDiscussion findByPrimaryKey(long discussionId) throws NoSuchDiscussionException {
        return this.findByPrimaryKey(Long.valueOf(discussionId));
    }

    public MBDiscussion fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(MBDiscussion.class, primaryKey)) {
            return (MBDiscussion)super.fetchByPrimaryKey(primaryKey);
        }
        MBDiscussion mbDiscussion = null;
        Session session = null;
        try {
            session = this.openSession();
            mbDiscussion = (MBDiscussion)session.get(MBDiscussionImpl.class, primaryKey);
            if (mbDiscussion != null) {
                this.cacheResult(mbDiscussion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return mbDiscussion;
    }

    public MBDiscussion fetchByPrimaryKey(long discussionId) {
        return this.fetchByPrimaryKey(Long.valueOf(discussionId));
    }

    public Map<Serializable, MBDiscussion> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(MBDiscussion.class)) {
            return super.fetchByPrimaryKeys(primaryKeys);
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, MBDiscussion> map = new HashMap<Serializable, MBDiscussion>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            MBDiscussion mbDiscussion = this.fetchByPrimaryKey(primaryKey);
            if (mbDiscussion != null) {
                map.put(primaryKey, mbDiscussion);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (MBDiscussion mbDiscussion : query.list()) {
                map.put(mbDiscussion.getPrimaryKeyObj(), mbDiscussion);
                this.cacheResult(mbDiscussion);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<MBDiscussion> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<MBDiscussion> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<MBDiscussion> findAll(int start, int end, OrderByComparator<MBDiscussion> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<MBDiscussion> findAll(int start, int end, OrderByComparator<MBDiscussion> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_MBDISCUSSION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_MBDISCUSSION;
                sql = sql.concat(" ORDER BY mbDiscussion.discussionId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (MBDiscussion mbDiscussion : this.findAll()) {
            this.remove((BaseModel)mbDiscussion);
        }
    }

    public int countAll() {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(MBDiscussion.class);
        Long count = null;
        if (productionMode) {
            count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        }
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_MBDISCUSSION);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "discussionId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_MBDISCUSSION;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return MBDiscussionModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "MBDiscussion";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathFetchByUUID_G = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, true);
        this._finderPathCountByUUID_G = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathFetchByThreadId = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByThreadId", new String[]{Long.class.getName()}, new String[]{"threadId"}, true);
        this._finderPathCountByThreadId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByThreadId", new String[]{Long.class.getName()}, new String[]{"threadId"}, false);
        this._finderPathFetchByC_C = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, true);
        this._finderPathCountByC_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, false);
        this._setMBDiscussionUtilPersistence(this);
    }

    @Deactivate
    public void deactivate() {
        this._setMBDiscussionUtilPersistence(null);
        this.entityCache.removeCache(MBDiscussionImpl.class.getName());
    }

    private void _setMBDiscussionUtilPersistence(MBDiscussionPersistence mbDiscussionPersistence) {
        try {
            Field field = MBDiscussionUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, mbDiscussionPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.message.boards.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.message.boards.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.message.boards.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctIgnoreColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("uuid_");
        ctStrictColumnNames.add("groupId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("userId");
        ctStrictColumnNames.add("userName");
        ctStrictColumnNames.add("createDate");
        ctIgnoreColumnNames.add("modifiedDate");
        ctStrictColumnNames.add("classNameId");
        ctStrictColumnNames.add("classPK");
        ctStrictColumnNames.add("threadId");
        ctStrictColumnNames.add("lastPublishDate");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.IGNORE, ctIgnoreColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("discussionId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"uuid_", "groupId"});
        _uniqueIndexColumnNames.add(new String[]{"threadId"});
        _uniqueIndexColumnNames.add(new String[]{"classNameId", "classPK"});
        _log = LogFactoryUtil.getLog(MBDiscussionPersistenceImpl.class);
        _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    }
}

